/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsDirectoryException;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsException;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b,\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u0012\u0006\u0010\u0018\u001a\u00020\u0015\u0012\u0006\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\u0004\bL\u0010MJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0018\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0014\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002R\u0014\u0010\u0014\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010(\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010,\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010+\u001a\u0004\b)\u0010'R\u001a\u0010/\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010+\u001a\u0004\b-\u0010'R\u001a\u00102\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010+\u001a\u0004\b0\u0010'R\u001a\u00105\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010+\u001a\u0004\b3\u0010'R\u0011\u00107\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b6\u0010'R\u001a\u0010:\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b9\u0010+\u001a\u0004\b8\u0010'R\u001a\u0010=\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b<\u0010+\u001a\u0004\b;\u0010'R\u001a\u0010@\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b?\u0010+\u001a\u0004\b>\u0010'R\u001a\u0010C\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bB\u0010+\u001a\u0004\bA\u0010'R\u001a\u0010F\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bE\u0010+\u001a\u0004\bD\u0010'R\u001a\u0010I\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bH\u0010+\u001a\u0004\bG\u0010'R\u0011\u0010K\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010'\u00a8\u0006N"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "Lio/scanbot/sdk/blob/BlobType;", "blobType", "Ljava/io/File;", "a", "Lio/scanbot/sdk/entity/Blob;", "blob", "Landroid/net/Uri;", "blobUri", "", "", "blobs", "", "allBlobsAvailable", "isBlobAvailable", "fetch", "forceFetch", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Landroid/content/res/AssetManager;", "b", "Landroid/content/res/AssetManager;", "assetManager", "Lio/scanbot/sdk/blob/BlobFactory;", "c", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "Lio/scanbot/sdk/util/log/Logger;", "d", "Lio/scanbot/sdk/util/log/Logger;", "logger", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "allLanguagesWithAvailableOcrBlobs", "getOcrBlobsDirectory", "()Ljava/io/File;", "ocrBlobsDirectory", "getBanksDataFile", "getBanksDataFile$annotations", "()V", "banksDataFile", "getBarcodeDetectionModelFile", "getBarcodeDetectionModelFile$annotations", "barcodeDetectionModelFile", "getBarcodeBinarizationModelFile", "getBarcodeBinarizationModelFile$annotations", "barcodeBinarizationModelFile", "getBlurEstimatorModelFile", "getBlurEstimatorModelFile$annotations", "blurEstimatorModelFile", "getMrzCascadeFile", "mrzCascadeFile", "getFilterPredictionModelFile", "getFilterPredictionModelFile$annotations", "filterPredictionModelFile", "getCheckDigitPredictionModelFile", "getCheckDigitPredictionModelFile$annotations", "checkDigitPredictionModelFile", "getDcModelsFolderFile", "getDcModelsFolderFile$annotations", "dcModelsFolderFile", "getIdCardScannerModelsFolderFile", "getIdCardScannerModelsFolderFile$annotations", "idCardScannerModelsFolderFile", "getGenericTextRecognizerModelsFolderFile", "getGenericTextRecognizerModelsFolderFile$annotations", "genericTextRecognizerModelsFolderFile", "getDocumentDetectorModelFile", "getDocumentDetectorModelFile$annotations", "documentDetectorModelFile", "getImageProcessorModelsFolderFile", "imageProcessorModelsFolderFile", "<init>", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "sdk-base_release"})
public final class BlobManager {
    @NotNull
    public final BlobStoreStrategy a;
    @NotNull
    public final AssetManager b;
    @NotNull
    public final BlobFactory c;
    @NotNull
    public final Logger d;

    /*
     * WARNING - void declaration
     */
    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        BlobManager blobManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobFactory");
        this.a = var1_1;
        this.b = var2_2;
        blobManager.c = var3_3;
        blobManager.d = LoggerProvider.getLogger();
    }

    @Deprecated(message="banksDataFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBanksDataFile$annotations() {
    }

    @Deprecated(message="barcodeDetectionModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeDetectionModelFile$annotations() {
    }

    @Deprecated(message="barcodeBinarizationModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeBinarizationModelFile$annotations() {
    }

    @Deprecated(message="blurEstimatorModel file is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBlurEstimatorModelFile$annotations() {
    }

    @Deprecated(message="filterPredictionModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getFilterPredictionModelFile$annotations() {
    }

    @Deprecated(message="check_digit_model files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getCheckDigitPredictionModelFile$annotations() {
    }

    @Deprecated(message="dc_forms_models files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDcModelsFolderFile$annotations() {
    }

    @Deprecated(message="idCardScannerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getIdCardScannerModelsFolderFile$annotations() {
    }

    @Deprecated(message="genericTextRecognizerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getGenericTextRecognizerModelsFolderFile$annotations() {
    }

    @Deprecated(message="documentDetectorModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDocumentDetectorModelFile$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final File a(BlobType blobType) throws IOException {
        void var1_1;
        File this_ = ((BlobManager)((Object)this_)).a.getLocalFileFor((BlobType)var1_1);
        if (this_.exists()) {
            return this_;
        }
        throw new BlobsException("Can't get file for blob type: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Blob blob, Uri blobUri) throws IOException {
        String string = blobUri.getPath();
        if (string != null) {
            void var1_1;
            InputStream inputStream = this.b.open(string);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(it)");
            FileUtilsKt.copyToFileAndClose(inputStream, new File(var1_1.getLocalPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Blob blob) throws IOException {
        void var1_1;
        File file = new File(var1_1.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new BlobsDirectoryException("Can't create destination directory");
        }
    }

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) throws IOException {
        Collection<Blob> collection = blobs;
        Intrinsics.checkNotNullParameter(collection, (String)"blobs");
        Iterator<Blob> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isBlobAvailable(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlobAvailable(@NotNull Blob blob) throws IOException {
        boolean bl;
        block5: {
            block4: {
                void var1_1;
                File file;
                Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
                File file2 = file;
                file2(var1_1.getLocalPath());
                InputStream inputStream = ((BlobManager)((Object)inputStream)).b.open(var1_1.getRemotePath());
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(blob.remotePath)");
                try {
                    if (!file.exists()) break block4;
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
                long l = inputStream.available();
                if (l != file2.length()) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        inputStream.close();
        return bl;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        BlobManager blobManager = this_;
        EnumSet<Language> this_ = EnumSet.noneOf(Language.class);
        Intrinsics.checkNotNullExpressionValue(this_, (String)"noneOf(Language::class.java)");
        File[] fileArray = blobManager.a.getOcrDataDirectory().listFiles();
        if (fileArray == null) {
            return this_;
        }
        for (Object object : fileArray) {
            if (object.isDirectory()) continue;
            File file = object;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            object = Language.Companion.languageByTessTag(FilesKt.getNameWithoutExtension((File)file));
            if (object == null) continue;
            this_.add((Language)((Object)object));
        }
        return this_;
    }

    @NotNull
    public final File getOcrBlobsDirectory() throws IOException {
        File this_ = ((BlobManager)((Object)this_)).a.getOcrDataDirectory();
        if (!this_.exists() && !this_.mkdirs()) {
            throw new BlobsDirectoryException("Can't get OCR blobs directory");
        }
        return this_;
    }

    @NotNull
    public final File getBanksDataFile() throws IOException {
        return this.a(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeDetectionModelFile() {
        return this.a.getLocalFileFor(BlobType.BARCODE_DETECTION_MODEL);
    }

    @NotNull
    public final File getBarcodeBinarizationModelFile() {
        return this.a.getLocalFileFor(BlobType.BARCODE_BINARIZATION_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() throws IOException {
        return this.a(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getFilterPredictionModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getCheckDigitPredictionModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.CHECK_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getGenericTextRecognizerModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.GENERIC_TEXT_RECOGNIZER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() {
        return this.a.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    @NotNull
    public final File getImageProcessorModelsFolderFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.IMAGE_PROCESSOR_MODELS);
    }

    /*
     * WARNING - void declaration
     */
    public final void fetch(@NotNull Blob blob) throws IOException {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"blob");
        if (this_.isBlobAvailable((Blob)v0)) {
            return;
        }
        BlobManager blobManager = this_;
        void v2 = var1_1;
        this_.a((Blob)var1_1);
        BlobManager this_ = Uri.parse((String)v2.getRemotePath());
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"blobUri");
        blobManager.a((Blob)v2, (Uri)this_);
    }

    public final void forceFetch(@NotNull BlobType blobType) throws IOException {
        Iterator<Blob> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"blobType");
        iterator = this.c.getBlobsForType((BlobType)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            this.fetch(iterator.next());
        }
    }
}

