/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "()V", "convertNV21ToBitmap", "Landroid/graphics/Bitmap;", "nv21Image", "", "imageWidth", "", "imageHeight", "imageOrientation", "convertYUV420toNV21", "image", "Landroidx/camera/core/ImageProxy;", "sdk-camera_release"})
public final class PreviewImageUtil {
    @NotNull
    public static final PreviewImageUtil INSTANCE = new PreviewImageUtil();

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Bitmap bitmap;
        Throwable throwable;
        ByteArrayOutputStream byteArrayOutputStream;
        block13: {
            void var3_6;
            Matrix matrix;
            Rect rect;
            YuvImage yuvImage;
            void var2_5;
            void var1_4;
            ByteArrayOutputStream byteArrayOutputStream2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)object, (String)"nv21Image");
            byteArrayOutputStream = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            throwable = null;
            try {
                yuvImage = new YuvImage(object, 17, (int)var1_4, (int)var2_5, null);
            }
            catch (Throwable throwable2) {
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)throwable2);
                    throw throwable3;
                }
            }
            object = rect;
            rect = new Rect(0, 0, (int)var1_4, (int)var2_5);
            yuvImage.compressToJpeg((Rect)object, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            int n2 = 0;
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)n2, (int)byArray.length);
            if (imageOrientation == 0) break block13;
            Bitmap bitmap2 = bitmap;
            bitmap = matrix;
            bitmap();
            float f2 = (float)var3_6;
            matrix.postRotate(f2);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)var1_4, (int)var2_5, (Matrix)bitmap, (boolean)false);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"resultBitmap");
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, throwable);
        return bitmap;
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n2, n3, n4);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        Rect rect = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"image.cropRect");
        int n2 = imageProxy.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        int n5 = n2;
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        n2 = n3 * n4;
        byte[] byArray = new byte[ImageFormat.getBitsPerPixel((int)n5) * n2 / 8];
        ImageProxy.PlaneProxy planeProxy = planeProxyArray[0];
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"planes[0]");
        byte[] byArray2 = new byte[planeProxy.getRowStride()];
        int n6 = 0;
        int n7 = 1;
        int n8 = planeProxyArray.length;
        for (int i2 = 0; i2 < n8; ++i2) {
            if (i2 != 0) {
                if (i2 != 1) {
                    if (i2 == 2) {
                        n7 = n6 = 2;
                        n6 = n2;
                    }
                } else {
                    n6 = n2 + 1;
                    n7 = 2;
                }
            } else {
                n6 = 0;
                n7 = 1;
            }
            ImageProxy.PlaneProxy planeProxy2 = planeProxyArray[i2];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy2, (String)"planes[i]");
            ByteBuffer byteBuffer = planeProxy2.getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[i].buffer");
            ImageProxy.PlaneProxy planeProxy3 = planeProxyArray[i2];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy3, (String)"planes[i]");
            int n9 = planeProxy3.getRowStride();
            ImageProxy.PlaneProxy planeProxy4 = planeProxyArray[i2];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy4, (String)"planes[i]");
            int n10 = planeProxy4.getPixelStride();
            int n11 = i2 == 0 ? 0 : 1;
            int n12 = n3 >> n11;
            int n13 = n4 >> n11;
            int n14 = n9 * (rect.top >> n11);
            byteBuffer.position(n10 * (rect.left >> n11) + n14);
            for (n11 = 0; n11 < n13; ++n11) {
                if (n10 == 1 && n7 == 1) {
                    byteBuffer.get(byArray, n6, n12);
                    n6 += n12;
                    n14 = n12;
                } else {
                    n14 = (n12 - 1) * n10 + 1;
                    byteBuffer.get(byArray2, 0, n14);
                    for (int i3 = 0; i3 < n12; ++i3) {
                        byArray[n6] = byArray2[i3 * n10];
                        n6 += n7;
                    }
                }
                if (n11 >= n13 - 1) continue;
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n9 - n14);
            }
        }
        return byArray;
    }
}

