/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.content.Context;
import android.graphics.Point;
import android.util.Pair;
import android.util.Size;
import android.view.View;
import android.view.WindowManager;
import io.scanbot.sdk.exceptions.camera.CameraTransformationException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/ui/camera/util/ScaleTypeTransform;", "", "()V", "getFillScaleWithBufferAspectRatio", "Landroid/util/Pair;", "", "view", "Landroid/view/View;", "bufferSize", "Landroid/util/Size;", "getFitScaleWithBufferAspectRatio", "getOriginOfCenteredView", "Landroid/graphics/Point;", "container", "getRotationDegrees", "", "isNaturalPortrait", "", "context", "Landroid/content/Context;", "rotationDegrees", "rotationDegreesFromSurfaceRotation", "rotationConstant", "sdk-camera_release"})
public final class ScaleTypeTransform {
    @NotNull
    public static final ScaleTypeTransform INSTANCE = new ScaleTypeTransform();

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFillScaleWithBufferAspectRatio(@NotNull View view, @NotNull Size bufferSize) {
        void var1_3;
        View view2;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"bufferSize");
        if (view.getWidth() != 0 && view2.getHeight() != 0 && var1_3.getWidth() != 0 && var1_3.getHeight() != 0) {
            void v0 = var1_3;
            float f2 = (float)v0.getWidth() / (float)view2.getMeasuredWidth();
            float f3 = Math.max((float)view2.getMeasuredWidth() / (float)var1_3.getWidth(), (float)view2.getMeasuredHeight() / (float)var1_3.getHeight());
            float f4 = f2 * f3;
            f3 = (float)v0.getHeight() / (float)view2.getMeasuredHeight() * f3;
            Float f5 = Float.valueOf(f4);
            return new Pair((Object)f5, (Object)Float.valueOf(f3));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFitScaleWithBufferAspectRatio(@NotNull View view, @NotNull Size bufferSize) {
        void var1_3;
        View view2;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"bufferSize");
        if (view.getWidth() != 0 && view2.getHeight() != 0 && var1_3.getWidth() != 0 && var1_3.getHeight() != 0) {
            void v0 = var1_3;
            float f2 = (float)v0.getWidth() / (float)view2.getMeasuredWidth();
            float f3 = Math.min((float)view2.getMeasuredWidth() / (float)var1_3.getWidth(), (float)view2.getMeasuredHeight() / (float)var1_3.getHeight());
            float f4 = f2 * f3;
            f3 = (float)v0.getHeight() / (float)view2.getMeasuredHeight() * f3;
            Float f5 = Float.valueOf(f4);
            return new Pair((Object)f5, (Object)Float.valueOf(f3));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    @JvmStatic
    @NotNull
    public static final Point getOriginOfCenteredView(@NotNull View container, @NotNull View view) {
        int n2;
        View view2;
        View view3 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view3, (String)"view");
        int n3 = (view3.getWidth() - view2.getWidth()) / 2;
        int n4 = n2 = (view3.getHeight() - view2.getHeight()) / 2;
        n2 = -n3;
        return new Point(n2, -n4);
    }

    @JvmStatic
    public static final int getRotationDegrees(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Object object = view2.getContext().getSystemService("window");
        if (object != null) {
            return ScaleTypeTransform.rotationDegreesFromSurfaceRotation(((WindowManager)object).getDefaultDisplay().getRotation());
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isNaturalPortrait(@NotNull Context context, int rotationDegrees) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = context2.getSystemService("window");
        if (object != null) {
            void var1_2;
            object = ((WindowManager)object).getDefaultDisplay();
            Point point = new Point();
            object.getRealSize(point);
            int n2 = point.x;
            int n3 = point.y;
            return (var1_2 == false || var1_2 == 180) && n2 < n3 || (var1_2 == 90 || var1_2 == 270) && n2 >= n3;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
    }

    @JvmStatic
    public static final int rotationDegreesFromSurfaceRotation(int rotationConstant) {
        int n2;
        switch (rotationConstant) {
            default: {
                int n3;
                throw new CameraTransformationException(Intrinsics.stringPlus((String)"Unsupported surface rotation constant: ", (Object)n3));
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        return n2;
    }
}

