/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import io.scanbot.sdk.exceptions.camera.CodecFailedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\nH\u0007J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraImageUtils;", "", "()V", "TAG", "", "argbToNv21", "", "argb", "", "width", "", "height", "bitmapToNv21", "src", "Landroid/graphics/Bitmap;", "computeCropRectFromAspectRatio", "Landroid/graphics/Rect;", "sourceSize", "Landroid/util/Size;", "aspectRatio", "Landroid/util/Rational;", "cropByteArray", "data", "cropRect", "imageToJpegByteArray", "image", "Landroidx/camera/core/ImageProxy;", "inverseRational", "rational", "isAspectRatioValid", "", "isCropAspectRatioHasEffect", "jpegImageToJpegByteArray", "nv21ToJpeg", "nv21", "rotate", "rotation", "shouldCropImage", "yuv420888toNv21", "yuvImageToJpegByteArray", "sdk-camera_release"})
public final class CameraImageUtils {
    @NotNull
    public static final CameraImageUtils INSTANCE = new CameraImageUtils();
    @NotNull
    private static final String a = "ImageUtil";

    private CameraImageUtils() {
    }

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy image) throws CodecFailedException {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        byte[] byArray = null;
        int n2 = imageProxy2.getFormat();
        if (n2 != 35) {
            if (n2 != 256) {
                Log.w((String)a, (String)Intrinsics.stringPlus((String)"Unrecognized image format: ", (Object)imageProxy.getFormat()));
            } else {
                byArray = INSTANCE.a(imageProxy);
            }
        } else {
            byArray = INSTANCE.d(imageProxy);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] data, @Nullable Rect cropRect) throws CodecFailedException {
        block7: {
            ByteArrayOutputStream byteArrayOutputStream;
            Bitmap bitmap;
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
            if (cropRect == null) {
                return byArray;
            }
            int n2 = 0;
            Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n2, (int)byArray.length, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(data, 0, dat\u2026                   false)");
            bitmap = object.decodeRegion((Rect)bitmap, new BitmapFactory.Options());
            try {
                object.recycle();
                if (bitmap == null) break block7;
            }
            catch (IOException iOException) {
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CodecFailedException(Intrinsics.stringPlus((String)"Decode byte array failed with illegal argument.", (Object)illegalArgumentException), CodecFailedException.FailureType.DECODE_FAILED);
            }
            object = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                bitmap.recycle();
                byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
                return byArray2;
            }
            throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size sourceSize, @NotNull Rational aspectRatio) {
        void var1_2;
        Size size;
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
        if (!INSTANCE.isAspectRatioValid((Rational)var1_2)) {
            Log.w((String)a, (String)"Invalid view ratio.");
            return null;
        }
        void v0 = var1_2;
        int n2 = size.getWidth();
        int n3 = size.getHeight();
        float f2 = n2;
        float f3 = n3;
        float f4 = f2 / f3;
        int n4 = 0;
        int n5 = 0;
        int n6 = v0.getNumerator();
        int n7 = v0.getDenominator();
        if (v0.floatValue() > f4) {
            int n8 = n3;
            n3 = Math.round(f2 / (float)n6 * (float)n7);
            n5 = (n8 - n3) / 2;
        } else {
            int n9 = n2;
            n2 = Math.round(f3 / (float)n7 * (float)n6);
            n4 = (n9 - n2) / 2;
        }
        n2 = n4 + n2;
        n3 = n5 + n3;
        return new Rect(n4, n5, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int rotation) {
        void var1_1;
        Rational rational2;
        Intrinsics.checkNotNullParameter((Object)rational2, (String)"rational");
        if (rotation == 90 || var1_1 == 270) {
            rational2 = INSTANCE.a(rational2);
        }
        return rational2;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] a(byte[] nv21, int width, int height, Rect cropRect) throws CodecFailedException {
        Rect rect;
        void var3_3;
        void var2_2;
        void var1_1;
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage((byte[])var1_1, 17, (int)var2_2, (int)var3_3, null);
        if (cropRect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, (int)var2_2, (int)var3_3);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
            return byArray;
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] c(ImageProxy image) {
        void var1_2;
        ImageProxy imageProxy = image;
        CameraImageUtils cameraImageUtils = imageProxy.getPlanes()[0];
        void v1 = var1_2;
        ImageProxy.PlaneProxy planeProxy = v1.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy2 = v1.getPlanes()[2];
        ByteBuffer byteBuffer = cameraImageUtils.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"yPlane.buffer");
        ByteBuffer byteBuffer2 = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"uPlane.buffer");
        ByteBuffer byteBuffer3 = planeProxy2.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"vPlane.buffer");
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        byte[] byArray = new byte[n2 + var1_2.getWidth() * var1_2.getHeight() / 2];
        int n4 = 0;
        int n5 = imageProxy.getHeight();
        while (n4 < n5) {
            ++n4;
            byteBuffer.get(byArray, n3, var1_2.getWidth());
            n3 += var1_2.getWidth();
            byteBuffer.position(Math.min(n2, byteBuffer.position() - var1_2.getWidth() + cameraImageUtils.getRowStride()));
        }
        void v2 = var1_2;
        int n6 = v2.getHeight() / 2;
        int n7 = v2.getWidth() / 2;
        int n8 = planeProxy2.getRowStride();
        n2 = planeProxy.getRowStride();
        int n9 = planeProxy2.getPixelStride();
        int n10 = planeProxy.getPixelStride();
        byte[] byArray2 = new byte[n8];
        byte[] byArray3 = new byte[n2];
        int n11 = 0;
        while (n11 < n6) {
            ++n11;
            byteBuffer3.get(byArray2, 0, Math.min(n8, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n2, byteBuffer2.remaining()));
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            while (n14 < n7) {
                ++n14;
                int n15 = n3 + 1;
                byArray[n3] = byArray2[n12];
                n3 = n15 + 1;
                byArray[n15] = byArray3[n13];
                n12 += n9;
                n13 += n10;
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean a(Size sourceSize, Rational aspectRatio) {
        int n2;
        float f2;
        void var2_4;
        Size size = sourceSize;
        int n3 = size.getWidth();
        int n4 = size.getHeight();
        void v1 = var2_4;
        int n5 = v1.getNumerator();
        float f3 = n5;
        return n4 != Math.round((float)n3 / f3 * (f2 = (float)(n2 = v1.getDenominator()))) || n3 != Math.round((float)n4 / f2 * f3);
    }

    /*
     * WARNING - void declaration
     */
    private final Rational a(Rational rational) {
        CameraImageUtils cameraImageUtils;
        void var1_1;
        if (rational == null) {
            cameraImageUtils = var1_1;
        } else {
            Rational rational2;
            cameraImageUtils = rational2;
            void v1 = var1_1;
            int n2 = v1.getDenominator();
            rational2 = new Rational(n2, v1.getNumerator());
        }
        return cameraImageUtils;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean b(ImageProxy image) {
        void var1_1;
        Size size;
        CameraImageUtils cameraImageUtils = size;
        void v1 = var1_1;
        int n2 = v1.getWidth();
        size = new Size(n2, v1.getHeight());
        return Intrinsics.areEqual((Object)new Size(var1_1.getCropRect().width(), var1_1.getCropRect().height()), (Object)cameraImageUtils) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] a(ImageProxy image) throws CodecFailedException {
        void var1_1;
        CameraImageUtils cameraImageUtils = this_;
        void v1 = var1_1;
        ImageProxy.PlaneProxy[] planeProxyArray = v1.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        ByteBuffer byteBuffer = planeProxyArray[0].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[0].buffer");
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.capacity()];
        Object this_ = byArray;
        byteBuffer.get(byArray);
        if (cameraImageUtils.b((ImageProxy)v1)) {
            this_ = CameraImageUtils.cropByteArray((byte[])this_, var1_1.getCropRect());
        }
        return this_;
    }

    private final byte[] d(ImageProxy image) throws CodecFailedException {
        Rect rect;
        void v0 = rect;
        byte[] byArray = this.c((ImageProxy)rect);
        int n2 = v0.getWidth();
        int n3 = v0.getHeight();
        rect = this.b((ImageProxy)v0) ? rect.getCropRect() : null;
        return this.a(byArray, n2, n3, rect);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] bitmapToNv21(@NotNull Bitmap src, int width, int height) throws CodecFailedException {
        void var2_2;
        Object object;
        void var1_1;
        Bitmap bitmap = src;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"src");
        if (bitmap.getWidth() >= var1_1 && object.getHeight() >= var2_2) {
            Bitmap bitmap2 = object;
            int[] nArray = new int[var1_1 * var2_2];
            object = nArray;
            bitmap2.getPixels(nArray, 0, (int)var1_1, 0, 0, (int)var1_1, (int)var2_2);
            return INSTANCE.a((int[])object, (int)var1_1, (int)var2_2);
        }
        throw new CodecFailedException("Invalid source Bitmap image!");
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] a(int[] argb, int width, int height) {
        void var3_4;
        int n2 = width * var3_4;
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 * 3 / 2;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        while (n6 < var3_4) {
            void var2_3;
            int n7 = n6 + 1;
            int n8 = 0;
            while (n8 < var2_3) {
                void var1_2;
                ++n8;
                int n9 = (var1_2[n4] & 0xFF0000) >> 16;
                int n10 = (var1_2[n4] & 0xFF00) >> 8;
                int n11 = var1_2[n4] & 0xFF;
                int n12 = (n9 * 66 + n10 * 129 + n11 * 25 + 128 >> 8) + 16;
                int n13 = n9;
                n9 = (n13 * 112 - n10 * 94 - n11 * 18 + 128 >> 8) + 128;
                n10 = (n13 * -38 - n10 * 74 + n11 * 112 + 128 >> 8) + 128;
                n11 = n3 + 1;
                if (n12 < 0) {
                    n12 = 0;
                } else if (n12 > 255) {
                    n12 = 255;
                }
                byArray[n3] = (byte)n12;
                if (n6 % 2 == 0 && n4 % 2 == 0 && n2 < n5 - 2) {
                    n3 = n2 + 1;
                    if (n10 < 0) {
                        n10 = 0;
                    } else if (n10 > 255) {
                        n10 = 255;
                    }
                    byArray[n2] = (byte)n10;
                    n2 = n3 + 1;
                    if (n9 < 0) {
                        n9 = 0;
                    } else if (n9 > 255) {
                        n9 = 255;
                    }
                    byArray[n3] = (byte)n9;
                }
                ++n4;
                n3 = n11;
            }
            n6 = n7;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        void var1_1;
        return aspectRatio != null && var1_1.floatValue() > 0.0f && !var1_1.isNaN();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@NotNull Size sourceSize, @Nullable Rational aspectRatio) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sourceSize");
        return aspectRatio != null && var2_2.floatValue() > 0.0f && this.a((Size)var1_1, (Rational)var2_2) && !var2_2.isNaN();
    }
}

