/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import android.util.Log;
import com.android.mms.exif.CountedDataInputStream;
import com.android.mms.exif.ExifInterface;
import com.android.mms.exif.ExifInvalidFormatException;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.JpegHeader;
import com.android.mms.exif.Rational;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;

public class ExifParser {
    private static final boolean LOGV = false;
    private static final String TAG = "ExifParser";
    public static final int EVENT_START_OF_IFD = 0;
    public static final int EVENT_NEW_TAG = 1;
    public static final int EVENT_VALUE_OF_REGISTERED_TAG = 2;
    public static final int EVENT_COMPRESSED_IMAGE = 3;
    public static final int EVENT_UNCOMPRESSED_STRIP = 4;
    public static final int EVENT_END = 5;
    public static final int OPTION_IFD_0 = 1;
    public static final int OPTION_IFD_1 = 2;
    public static final int OPTION_IFD_EXIF = 4;
    public static final int OPTION_IFD_GPS = 8;
    public static final int OPTION_IFD_INTEROPERABILITY = 16;
    public static final int OPTION_THUMBNAIL = 32;
    public static final int EXIF_HEADER = 1165519206;
    public static final short EXIF_HEADER_TAIL = 0;
    public static final short LITTLE_ENDIAN_TAG = 18761;
    public static final short BIG_ENDIAN_TAG = 19789;
    public static final short TIFF_HEADER_TAIL = 42;
    public static final int TAG_SIZE = 12;
    public static final int OFFSET_SIZE = 2;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final int DEFAULT_IFD0_OFFSET = 8;
    private static final short TAG_EXIF_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_EXIF_IFD);
    private static final short TAG_GPS_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_GPS_IFD);
    private static final short TAG_INTEROPERABILITY_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_INTEROPERABILITY_IFD);
    private static final short TAG_JPEG_INTERCHANGE_FORMAT = ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT);
    private static final short TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
    private static final short TAG_STRIP_OFFSETS = ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS);
    private static final short TAG_STRIP_BYTE_COUNTS = ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS);
    private final CountedDataInputStream mTiffStream;
    private final int mOptions;
    private int mIfdStartOffset = 0;
    private int mNumOfTagInIfd = 0;
    private int mIfdType;
    private ExifTag mTag;
    private ImageEvent mImageEvent;
    private int mStripCount;
    private ExifTag mStripSizeTag;
    private ExifTag mJpegSizeTag;
    private boolean mNeedToParseOffsetsInCurrentIfd;
    private boolean mContainExifData = false;
    private int mApp1End;
    private int mOffsetToApp1EndFromSOF = 0;
    private byte[] mDataAboveIfd0;
    private int mIfd0Position;
    private int mTiffStartPosition;
    private final ExifInterface mInterface;
    private final TreeMap<Integer, Object> mCorrespondingEvent;

    private boolean isIfdRequested(int ifdType) {
        switch (ifdType) {
            default: {
                return false;
            }
            case 4: {
                return (this.mOptions & 8) != 0;
            }
            case 3: {
                return (this.mOptions & 0x10) != 0;
            }
            case 2: {
                return (this.mOptions & 4) != 0;
            }
            case 1: {
                return (this.mOptions & 2) != 0;
            }
            case 0: 
        }
        return (this.mOptions & 1) != 0;
    }

    private boolean isThumbnailRequested() {
        return (this.mOptions & 0x20) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private ExifParser(InputStream inputStream, int options, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        TreeMap treeMap;
        TreeMap treeMap2 = treeMap;
        treeMap = new TreeMap();
        ((ExifParser)object).mCorrespondingEvent = treeMap2;
        if (inputStream != null) {
            void var2_3;
            CountedDataInputStream countedDataInputStream;
            void var1_1;
            void var3_5;
            ((ExifParser)object).mInterface = var3_5;
            ((ExifParser)object).mContainExifData = ((ExifParser)object).seekTiffData((InputStream)var1_1);
            CountedDataInputStream countedDataInputStream2 = countedDataInputStream;
            ((ExifParser)object).mTiffStream = new CountedDataInputStream((InputStream)var1_1);
            ((ExifParser)object).mOptions = var2_3;
            if (!((ExifParser)object).mContainExifData) {
                return;
            }
            ((ExifParser)object).parseTiffHeader();
            long l2 = countedDataInputStream2.readUnsignedInt();
            if (l2 <= Integer.MAX_VALUE) {
                int n2;
                ((ExifParser)object).mIfd0Position = n2 = (int)l2;
                ((ExifParser)object).mIfdType = 0;
                if (((ExifParser)object).isIfdRequested(0) || ((ExifParser)object).needToParseOffsetsInCurrentIfd()) {
                    ((ExifParser)object).registerIfd(0, l2);
                    if (l2 != 8L) {
                        ExifParser exifParser = object;
                        byte[] byArray = new byte[n2 - 8];
                        Object object = byArray;
                        exifParser.mDataAboveIfd0 = byArray;
                        exifParser.read((byte[])object);
                    }
                }
                return;
            }
            throw new ExifInvalidFormatException("Invalid offset " + l2);
        }
        throw new IOException("Null argument inputStream to ExifParser");
    }

    /*
     * WARNING - void declaration
     */
    public static ExifParser parse(InputStream inputStream, int options, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        void var2_2;
        void var1_1;
        InputStream inputStream2;
        return new ExifParser(inputStream2, (int)var1_1, (ExifInterface)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ExifParser parse(InputStream inputStream, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        void var1_1;
        InputStream inputStream2;
        return new ExifParser(inputStream2, 63, (ExifInterface)var1_1);
    }

    private boolean needToParseOffsetsInCurrentIfd() {
        int n2 = this.mIfdType;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return false;
                }
                return this.isIfdRequested(3);
            }
            return this.isThumbnailRequested();
        }
        return this.isIfdRequested(2) || this.isIfdRequested(4) || this.isIfdRequested(3) || this.isIfdRequested(1);
    }

    /*
     * WARNING - void declaration
     */
    private void skipTo(int offset) throws IOException {
        void var1_1;
        this.mTiffStream.skipTo((long)var1_1);
        while (!this.mCorrespondingEvent.isEmpty() && this.mCorrespondingEvent.firstKey() < var1_1) {
            this.mCorrespondingEvent.pollFirstEntry();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerIfd(int ifdType, long offset) {
        void var1_1;
        void var2_2;
        this.mCorrespondingEvent.put((int)var2_2, new IfdEvent((int)var1_1, this.isIfdRequested((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private void registerCompressedImage(long offset) {
        void var1_1;
        this.mCorrespondingEvent.put((int)var1_1, new ImageEvent(3));
    }

    /*
     * WARNING - void declaration
     */
    private void registerUncompressedStrip(int stripIndex, long offset) {
        void var1_1;
        void var2_2;
        this.mCorrespondingEvent.put((int)var2_2, new ImageEvent(4, (int)var1_1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExifTag readTag() throws IOException, ExifInvalidFormatException {
        ExifTag exifTag;
        int n2 = this_.mTiffStream.readShort();
        short s2 = this_.mTiffStream.readShort();
        long l2 = this_.mTiffStream.readUnsignedInt();
        if (l2 > Integer.MAX_VALUE) throw new ExifInvalidFormatException("Number of component is larger then Integer.MAX_VALUE");
        if (!ExifTag.isValidType(s2)) {
            Object[] objectArray = this_;
            Object[] objectArray2 = new Object[2];
            Object[] this_ = objectArray2;
            this_[0] = (short)n2;
            objectArray2[1] = s2;
            Log.w((String)TAG, (String)String.format("Tag %04x: Invalid data type %d", this_));
            objectArray.mTiffStream.skip(4L);
            return null;
        }
        int n3 = (int)l2;
        int n4 = this_.mIfdType;
        boolean bl = n3 != 0;
        ExifTag exifTag2 = exifTag;
        exifTag2((short)n2, s2, n3, n4, bl);
        n2 = exifTag2.getDataSize();
        if (n2 > 4) {
            long l3 = this_.mTiffStream.readUnsignedInt();
            if (l3 > Integer.MAX_VALUE) throw new ExifInvalidFormatException("offset is larger then Integer.MAX_VALUE");
            if (l3 < (long)this_.mIfd0Position && s2 == 7) {
                byte[] byArray = new byte[n3];
                System.arraycopy(this_.mDataAboveIfd0, (int)l3 - 8, byArray, 0, n3);
                exifTag.setValue(byArray);
                return exifTag;
            } else {
                exifTag.setOffset((int)l3);
            }
            return exifTag;
        } else {
            ExifTag exifTag3 = exifTag;
            boolean bl2 = exifTag3.hasDefinedCount();
            exifTag3.setHasDefinedCount(false);
            this_.readFullTagValue(exifTag3);
            exifTag.setHasDefinedCount(bl2);
            this_.mTiffStream.skip(4 - n2);
            exifTag.setOffset(this_.mTiffStream.getReadByteCount() - 4);
        }
        return exifTag;
    }

    /*
     * WARNING - void declaration
     */
    private void checkOffsetOrImageTag(ExifTag tag) {
        void var1_4;
        if (tag.getComponentCount() == 0) {
            return;
        }
        int n2 = var1_4.getTagId();
        int n3 = var1_4.getIfd();
        if (n2 == TAG_EXIF_IFD && this.checkAllowed(n3, ExifInterface.TAG_EXIF_IFD)) {
            if (this.isIfdRequested(2) || this.isIfdRequested(3)) {
                long l2 = var1_4.getValueAt(0);
                this.registerIfd(2, l2);
            }
        } else if (n2 == TAG_GPS_IFD && this.checkAllowed(n3, ExifInterface.TAG_GPS_IFD)) {
            if (this.isIfdRequested(4)) {
                long l3 = var1_4.getValueAt(0);
                this.registerIfd(4, l3);
            }
        } else if (n2 == TAG_INTEROPERABILITY_IFD && this.checkAllowed(n3, ExifInterface.TAG_INTEROPERABILITY_IFD)) {
            if (this.isIfdRequested(3)) {
                long l4 = var1_4.getValueAt(0);
                this.registerIfd(3, l4);
            }
        } else if (n2 == TAG_JPEG_INTERCHANGE_FORMAT && this.checkAllowed(n3, ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)) {
            if (this.isThumbnailRequested()) {
                this.registerCompressedImage(var1_4.getValueAt(0));
            }
        } else if (n2 == TAG_JPEG_INTERCHANGE_FORMAT_LENGTH && this.checkAllowed(n3, ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH)) {
            if (this.isThumbnailRequested()) {
                this.mJpegSizeTag = var1_4;
            }
        } else if (n2 == TAG_STRIP_OFFSETS && this.checkAllowed(n3, ExifInterface.TAG_STRIP_OFFSETS)) {
            if (this.isThumbnailRequested()) {
                if (var1_4.hasValue()) {
                    for (n2 = 0; n2 < var1_4.getComponentCount(); ++n2) {
                        long l5;
                        if (var1_4.getDataType() == 3) {
                            l5 = var1_4.getValueAt(n2);
                            this.registerUncompressedStrip(n2, l5);
                            continue;
                        }
                        l5 = var1_4.getValueAt(n2);
                        this.registerUncompressedStrip(n2, l5);
                    }
                } else {
                    this.mCorrespondingEvent.put(var1_4.getOffset(), new ExifTagEvent((ExifTag)var1_4, false));
                }
            }
        } else if (n2 == TAG_STRIP_BYTE_COUNTS && this.checkAllowed(n3, ExifInterface.TAG_STRIP_BYTE_COUNTS) && this.isThumbnailRequested() && var1_4.hasValue()) {
            this.mStripSizeTag = var1_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAllowed(int ifd, int tagId) {
        void var1_2;
        void var2_3;
        int n2 = this.mInterface.getTagInfo().get((int)var2_3);
        if (n2 == 0) {
            return false;
        }
        return ExifInterface.isIfdAllowed(n2, (int)var1_2);
    }

    private void parseTiffHeader() throws IOException, ExifInvalidFormatException {
        block6: {
            block5: {
                short s2;
                block4: {
                    s2 = this.mTiffStream.readShort();
                    if (18761 != s2) break block4;
                    this.mTiffStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    break block5;
                }
                if (19789 != s2) break block6;
                this.mTiffStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            if (this.mTiffStream.readShort() == 42) {
                return;
            }
            throw new ExifInvalidFormatException("Invalid TIFF header");
        }
        throw new ExifInvalidFormatException("Invalid TIFF header");
    }

    /*
     * WARNING - void declaration
     */
    private boolean seekTiffData(InputStream inputStream) throws IOException, ExifInvalidFormatException {
        void var1_1;
        CountedDataInputStream countedDataInputStream;
        CountedDataInputStream countedDataInputStream2 = countedDataInputStream;
        if (new CountedDataInputStream((InputStream)var1_1).readShort() == -40) {
            int n2 = countedDataInputStream2.readShort();
            while (n2 != -39 && !JpegHeader.isSofMarker((short)n2)) {
                long l2;
                int n3 = n2;
                n2 = countedDataInputStream2.readUnsignedShort();
                if (n3 == -31 && n2 >= 8) {
                    short s2 = countedDataInputStream2.readShort();
                    n2 -= 6;
                    if (countedDataInputStream2.readInt() == 1165519206 && s2 == 0) {
                        int n4;
                        this.mTiffStartPosition = n4 = countedDataInputStream2.getReadByteCount();
                        this.mApp1End = n2;
                        this.mOffsetToApp1EndFromSOF = n4 + n2;
                        return true;
                    }
                }
                if (n2 >= 2 && (l2 = (long)(n2 - 2)) == countedDataInputStream2.skip(l2)) {
                    n2 = countedDataInputStream2.readShort();
                    continue;
                }
                Log.w((String)TAG, (String)"Invalid JPEG format.");
                return false;
            }
            return false;
        }
        throw new ExifInvalidFormatException("Invalid JPEG format");
    }

    public int next() throws IOException, ExifInvalidFormatException {
        if (!((ExifParser)((Object)this_)).mContainExifData) {
            return 5;
        }
        int n2 = ((ExifParser)((Object)this_)).mTiffStream.getReadByteCount();
        ExifParser exifParser = this_;
        int n3 = exifParser.mIfdStartOffset + 2;
        if (n2 < (n3 = exifParser.mNumOfTagInIfd * 12 + n3)) {
            ExifTag exifTag;
            ((ExifParser)((Object)this_)).mTag = exifTag = ((ExifParser)((Object)this_)).readTag();
            if (exifTag == null) {
                return ((ExifParser)((Object)this_)).next();
            }
            if (((ExifParser)((Object)this_)).mNeedToParseOffsetsInCurrentIfd) {
                ((ExifParser)((Object)this_)).checkOffsetOrImageTag(exifTag);
            }
            return 1;
        }
        if (n2 == n3) {
            if (((ExifParser)((Object)this_)).mIfdType == 0) {
                ExifParser exifParser2 = this_;
                long l2 = exifParser2.readUnsignedLong();
                if ((exifParser2.isIfdRequested(1) || ((ExifParser)((Object)this_)).isThumbnailRequested()) && l2 != 0L) {
                    ((ExifParser)((Object)this_)).registerIfd(1, l2);
                }
            } else {
                n2 = 4;
                if (((ExifParser)((Object)this_)).mCorrespondingEvent.size() > 0) {
                    n2 = ((ExifParser)((Object)this_)).mCorrespondingEvent.firstEntry().getKey() - ((ExifParser)((Object)this_)).mTiffStream.getReadByteCount();
                }
                if (n2 < 4) {
                    Log.w((String)TAG, (String)("Invalid size of link to next IFD: " + n2));
                } else {
                    long l3 = ((ExifParser)((Object)this_)).readUnsignedLong();
                    if (l3 != 0L) {
                        Log.w((String)TAG, (String)("Invalid link to next IFD: " + l3));
                    }
                }
            }
        }
        while (((ExifParser)((Object)this_)).mCorrespondingEvent.size() != 0) {
            ExifParser exifParser3 = this_;
            Object object = exifParser3.mCorrespondingEvent.pollFirstEntry();
            Object object2 = object.getValue();
            try {
                exifParser3.skipTo(object.getKey());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)("Failed to skip to data at: " + object.getKey() + " for " + object2.getClass().getName() + ", the file may be broken."));
                continue;
            }
            if (object2 instanceof IfdEvent) {
                int n4;
                Map.Entry<Integer, Object> entry = object;
                object = (IfdEvent)object2;
                ((ExifParser)((Object)this_)).mIfdType = ((IfdEvent)object).ifd;
                ((ExifParser)((Object)this_)).mNumOfTagInIfd = ((ExifParser)((Object)this_)).mTiffStream.readUnsignedShort();
                ((ExifParser)((Object)this_)).mIfdStartOffset = n4 = entry.getKey().intValue();
                if (((ExifParser)((Object)this_)).mNumOfTagInIfd * 12 + n4 + 2 > ((ExifParser)((Object)this_)).mApp1End) {
                    Log.w((String)TAG, (String)("Invalid size of IFD " + ((ExifParser)((Object)this_)).mIfdType));
                    return 5;
                }
                ((ExifParser)((Object)this_)).mNeedToParseOffsetsInCurrentIfd = super.needToParseOffsetsInCurrentIfd();
                if (((IfdEvent)object).isRequested) {
                    return 0;
                }
                ((ExifParser)((Object)this_)).skipRemainingTagsInCurrentIfd();
                continue;
            }
            if (object2 instanceof ImageEvent) {
                ExifParser exifParser4 = this_;
                ImageEvent this_ = (ImageEvent)object2;
                exifParser4.mImageEvent = this_;
                return this_.type;
            }
            object = (ExifTagEvent)object2;
            object2 = ((ExifTagEvent)object).tag;
            ((ExifParser)((Object)this_)).mTag = object2;
            if (((ExifTag)object2).getDataType() != 7) {
                ImageEvent imageEvent = this_;
                ((ExifParser)((Object)imageEvent)).readFullTagValue(((ExifParser)((Object)imageEvent)).mTag);
                super.checkOffsetOrImageTag(((ExifParser)((Object)imageEvent)).mTag);
            }
            if (!((ExifTagEvent)object).isRequested) continue;
            return 2;
        }
        return 5;
    }

    public void skipRemainingTagsInCurrentIfd() throws IOException, ExifInvalidFormatException {
        ExifParser exifParser = this;
        int n2 = exifParser.mIfdStartOffset + 2;
        n2 = exifParser.mNumOfTagInIfd * 12 + n2;
        int n3 = exifParser.mTiffStream.getReadByteCount();
        if (n3 > n2) {
            return;
        }
        if (this.mNeedToParseOffsetsInCurrentIfd) {
            while (n3 < n2) {
                ExifTag exifTag;
                this.mTag = exifTag = this.readTag();
                n3 += 12;
                if (exifTag == null) continue;
                this.checkOffsetOrImageTag(exifTag);
            }
        } else {
            this.skipTo(n2);
        }
        ExifParser exifParser2 = this;
        long l2 = exifParser2.readUnsignedLong();
        if (exifParser2.mIfdType == 0 && (this.isIfdRequested(1) || this.isThumbnailRequested()) && l2 > 0L) {
            this.registerIfd(1, l2);
        }
    }

    public ExifTag getTag() {
        return this.mTag;
    }

    public int getTagCountInCurrentIfd() {
        return this.mNumOfTagInIfd;
    }

    public int getCurrentIfd() {
        return this.mIfdType;
    }

    public int getStripIndex() {
        return this.mImageEvent.stripIndex;
    }

    public int getStripCount() {
        return this.mStripCount;
    }

    public int getStripSize() {
        ExifTag this_ = ((ExifParser)((Object)this_)).mStripSizeTag;
        if (this_ == null) {
            return 0;
        }
        return (int)this_.getValueAt(0);
    }

    public int getCompressedImageSize() {
        ExifTag this_ = ((ExifParser)((Object)this_)).mJpegSizeTag;
        if (this_ == null) {
            return 0;
        }
        return (int)this_.getValueAt(0);
    }

    /*
     * WARNING - void declaration
     */
    public void registerForTagValue(ExifTag tag) {
        if (tag.getOffset() >= this.mTiffStream.getReadByteCount()) {
            void var1_1;
            this.mCorrespondingEvent.put(var1_1.getOffset(), new ExifTagEvent((ExifTag)var1_1, true));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readFullTagValue(ExifTag tag) throws IOException {
        void var1_1;
        int n2 = tag.getDataType();
        if (n2 == 2 || n2 == 7 || n2 == 1) {
            n2 = var1_1.getComponentCount();
            if (((ExifParser)object).mCorrespondingEvent.size() > 0 && ((ExifParser)object).mCorrespondingEvent.firstEntry().getKey() < ((ExifParser)object).mTiffStream.getReadByteCount() + n2) {
                Object object = ((ExifParser)object).mCorrespondingEvent.firstEntry().getValue();
                if (object instanceof ImageEvent) {
                    Log.w((String)TAG, (String)("Thumbnail overlaps value for tag: \n" + var1_1.toString()));
                    Log.w((String)TAG, (String)("Invalid thumbnail offset: " + ((ExifParser)object).mCorrespondingEvent.pollFirstEntry().getKey()));
                } else {
                    if (object instanceof IfdEvent) {
                        Log.w((String)TAG, (String)("Ifd " + ((IfdEvent)object).ifd + " overlaps value for tag: \n" + var1_1.toString()));
                    } else if (object instanceof ExifTagEvent) {
                        Log.w((String)TAG, (String)("Tag value for tag: \n" + ((ExifTagEvent)object).tag.toString() + " overlaps value for tag: \n" + var1_1.toString()));
                    }
                    int n3 = ((ExifParser)object).mCorrespondingEvent.firstEntry().getKey() - ((ExifParser)object).mTiffStream.getReadByteCount();
                    Log.w((String)TAG, (String)("Invalid size of tag: \n" + var1_1.toString() + " setting count to: " + n3));
                    var1_1.forceSetComponentCount(n3);
                }
            }
        }
        switch (var1_1.getDataType()) {
            default: {
                break;
            }
            case 10: {
                int n4 = var1_1.getComponentCount();
                Rational[] rationalArray = new Rational[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    rationalArray[i2] = ((ExifParser)object).readRational();
                }
                var1_1.setValue(rationalArray);
                break;
            }
            case 9: {
                int n5 = var1_1.getComponentCount();
                int[] nArray = new int[n5];
                for (int i3 = 0; i3 < n5; ++i3) {
                    nArray[i3] = ((ExifParser)object).readLong();
                }
                var1_1.setValue(nArray);
                break;
            }
            case 5: {
                int n6 = var1_1.getComponentCount();
                Rational[] rationalArray = new Rational[n6];
                for (int i4 = 0; i4 < n6; ++i4) {
                    rationalArray[i4] = ((ExifParser)object).readUnsignedRational();
                }
                var1_1.setValue(rationalArray);
                break;
            }
            case 4: {
                int n7 = var1_1.getComponentCount();
                long[] lArray = new long[n7];
                for (int i5 = 0; i5 < n7; ++i5) {
                    long l2;
                    lArray[i5] = l2 = ((ExifParser)object).readUnsignedLong();
                }
                var1_1.setValue(lArray);
                break;
            }
            case 3: {
                int n8 = var1_1.getComponentCount();
                int[] nArray = new int[n8];
                for (int i6 = 0; i6 < n8; ++i6) {
                    nArray[i6] = ((ExifParser)object).readUnsignedShort();
                }
                var1_1.setValue(nArray);
                break;
            }
            case 2: {
                var1_1.setValue(((ExifParser)object).readString(var1_1.getComponentCount()));
                break;
            }
            case 1: 
            case 7: {
                ExifParser exifParser = object;
                byte[] byArray = new byte[var1_1.getComponentCount()];
                Object object = byArray;
                exifParser.read(byArray);
                var1_1.setValue((byte[])object);
            }
        }
    }

    public int getOffsetToExifEndFromSOF() {
        return this.mOffsetToApp1EndFromSOF;
    }

    public int getTiffStartPosition() {
        return this.mTiffStartPosition;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.mTiffStream.read((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] buffer) throws IOException {
        void var1_1;
        return this.mTiffStream.read((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String readString(int n2) throws IOException {
        void var1_1;
        return this.readString((int)var1_1, US_ASCII);
    }

    /*
     * WARNING - void declaration
     */
    public String readString(int n2, Charset charset) throws IOException {
        if (n2 > 0) {
            void var2_2;
            void var1_1;
            return this.mTiffStream.readString((int)var1_1, (Charset)var2_2);
        }
        return "";
    }

    public int readUnsignedShort() throws IOException {
        return this.mTiffStream.readShort() & 0xFFFF;
    }

    public long readUnsignedLong() throws IOException {
        return (long)this.readLong() & 0xFFFFFFFFL;
    }

    public Rational readUnsignedRational() throws IOException {
        ExifParser exifParser = this;
        long l2 = exifParser.readUnsignedLong();
        long l3 = exifParser.readUnsignedLong();
        return new Rational(l2, l3);
    }

    public int readLong() throws IOException {
        return this.mTiffStream.readInt();
    }

    public Rational readRational() throws IOException {
        ExifParser exifParser = this;
        int n2 = exifParser.readLong();
        int n3 = exifParser.readLong();
        long l2 = n2;
        long l3 = n3;
        return new Rational(l2, l3);
    }

    public ByteOrder getByteOrder() {
        return this.mTiffStream.getByteOrder();
    }

    public static class ExifTagEvent {
        public ExifTag tag;
        public boolean isRequested;

        /*
         * WARNING - void declaration
         */
        public ExifTagEvent(ExifTag tag, boolean isRequireByUser) {
            void var2_2;
            void var1_1;
            this.tag = var1_1;
            this.isRequested = var2_2;
        }
    }

    public static class IfdEvent {
        public int ifd;
        public boolean isRequested;

        /*
         * WARNING - void declaration
         */
        public IfdEvent(int ifd, boolean isInterestedIfd) {
            void var2_2;
            void var1_1;
            this.ifd = var1_1;
            this.isRequested = var2_2;
        }
    }

    public static class ImageEvent {
        public int stripIndex;
        public int type;

        /*
         * WARNING - void declaration
         */
        public ImageEvent(int type) {
            void var1_1;
            this.stripIndex = 0;
            this.type = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ImageEvent(int type, int stripIndex) {
            void var2_2;
            void var1_1;
            this.type = var1_1;
            this.stripIndex = var2_2;
        }
    }
}

