/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.chequescanner;

import android.graphics.Bitmap;
import io.scanbot.chequescanner.ChequeRecognizer;
import io.scanbot.chequescanner.model.Result;
import io.scanbot.sdk.chequescanner.ChequeScanner;
import java.io.IOException;
import net.doo.snap.blob.BlobManager;

public class DefaultChequeScanner
implements ChequeScanner {
    private final ChequeRecognizer chequeRecognizer;

    public DefaultChequeScanner(BlobManager blobManager) {
        String modelFilePath = null;
        try {
            modelFilePath = blobManager.getChequeDigitPredictionModelFile().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Cheque blob is not available.");
        }
        this.chequeRecognizer = new ChequeRecognizer(modelFilePath);
    }

    @Override
    public Result recognizeCheque(byte[] nv21, int width, int height, int orientation) {
        return this.chequeRecognizer.recognizeCheque(nv21, width, height, orientation);
    }

    @Override
    public Result recognizeChequeBGR(byte[] bgr, int width, int height, int orientation) {
        return this.chequeRecognizer.recognizeChequeBGR(bgr, width, height, orientation);
    }

    @Override
    public Result recognizeChequeJPEG(byte[] image, int width, int height, int orientation) {
        return this.chequeRecognizer.recognizeChequeJPEG(image, width, height, orientation);
    }

    @Override
    public Result recognizeChequeBitmap(Bitmap image, int orientation) {
        return this.chequeRecognizer.recognizeChequeBitmap(image, orientation);
    }
}

