/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.graphics.Rect;
import android.graphics.RectF;
import crl.android.pdfwriter.PDFWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.pdf.PdfUtils;
import org.apache.commons.io.IOUtils;

public class SimpleComposer
implements Composer {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;

    public SimpleComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
    }

    @Override
    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (document.getSize() > 0L) {
            throw new IOException("Document already exists");
        }
        PDFWriter pdfWriter = new PDFWriter();
        this.composePDF(pdfWriter, pages);
        this.writeDocumentToFile(document, pdfWriter);
    }

    private void composePDF(PDFWriter pdfWriter, Page[] pages) throws IOException {
        for (Page page : pages) {
            String optimizedPath = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            Rect bounds = BitmapUtils.getBitmapBounds(optimizedPath);
            int rotation = page.getRotationType().getDegrees();
            RectF convertedBounds = PdfUtils.calculatePageBounds(page.getPageSize(), bounds, rotation);
            int convertedWidth = (int)convertedBounds.width();
            int convertedHeight = (int)convertedBounds.height();
            pdfWriter.newPage(convertedWidth, convertedHeight);
            pdfWriter.addJPGImageKeepRatio(convertedWidth, convertedHeight, -rotation, optimizedPath);
        }
        pdfWriter.setDocumentInfo("/Creator (Scanbot for Android)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocumentToFile(Document document, PDFWriter pdfWriter) throws IOException {
        File pdf = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(pdf));
            pdfWriter.write((OutputStream)os);
            ((OutputStream)os).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

