/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BitmapUtils {
    public static Rect getBitmapBounds(String path) {
        Rect bounds = new Rect();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        bounds.set(0, 0, options.outWidth, options.outHeight);
        return bounds;
    }

    public static boolean isBitmapValid(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    public static Rect getContentBounds(Bitmap bitmap) throws NullPointerException {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap is null");
        }
        int minX = bitmap.getWidth();
        int minY = bitmap.getHeight();
        int maxX = 0;
        int maxY = 0;
        for (int y = 0; y < bitmap.getHeight(); ++y) {
            for (int x = 0; x < bitmap.getWidth(); ++x) {
                int pixel = bitmap.getPixel(x, y);
                if (pixel == 0) continue;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return new Rect(minX, minY, maxX, maxY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(Bitmap bitmap, Bitmap.CompressFormat format, int quality, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bitmap.compress(format, quality, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static Bitmap createPreview(Resources res, int imageRes, int targetWidth, int targetHeight) {
        if (imageRes <= 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)imageRes, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)imageRes, (BitmapFactory.Options)options);
    }

    public static Bitmap createPreview(byte[] image, int targetWidth, int targetHeight) {
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
    }

    public static Bitmap createPreview(Bitmap image, int targetWidth, int targetHeight) {
        if (image == null) {
            return null;
        }
        int inSampleSize = BitmapUtils.calculateInSampleSize(targetWidth, targetHeight, image.getWidth(), image.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)image, (int)(image.getWidth() / inSampleSize), (int)(image.getHeight() / inSampleSize), (boolean)false);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        return BitmapUtils.calculateInSampleSize(reqWidth, reqHeight, width, height);
    }

    private static int calculateInSampleSize(int reqWidth, int reqHeight, int width, int height) {
        boolean desiredLandscape;
        int srcWidth = width;
        int srcHeight = height;
        boolean imageLandscape = srcWidth > srcHeight;
        boolean bl = desiredLandscape = reqWidth > reqHeight;
        if (imageLandscape != desiredLandscape) {
            srcHeight = width;
            srcWidth = height;
        }
        int inSampleSize = 1;
        if (srcHeight > reqHeight || srcWidth > reqWidth) {
            int halfHeight = srcHeight / 2;
            int halfWidth = srcWidth / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap scaleIfNeeded(Bitmap image, int maxHeight, int maxWidth) {
        if (maxHeight < image.getHeight() || maxWidth < image.getWidth()) {
            float ratio = Math.min((float)maxWidth / (float)image.getWidth(), (float)maxHeight / (float)image.getHeight());
            int width = Math.round(ratio * (float)image.getWidth());
            int height = Math.round(ratio * (float)image.getHeight());
            return Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
        }
        return image;
    }
}

