/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.pdf;

import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.Locale;

public class PdfUtils {
    public static final float UNIT_SIZE_INCHES = 0.013888889f;
    public static final float A4_HEIGHT_INCHES = 11.692f;
    public static final float A4_WIDTH_INCHES = 8.27f;
    public static final float A4_HEIGHT_UNITS = 841.82404f;
    public static final float A4_WIDTH_UNITS = 595.44f;
    public static final float US_LETTER_HEIGHT_INCHES = 10.98f;
    public static final float US_LETTER_WIDTH_INCHES = 8.5f;
    public static final float US_LETTER_HEIGHT_UNITS = 790.55994f;
    public static final float US_LETTER_WIDTH_UNITS = 612.0f;

    public static RectF defaultPhysicalBounds() {
        return new RectF(0.0f, 0.0f, 11.692f, 11.692f);
    }

    public static RectF a4PhysicalBounds(RectF bounds) {
        boolean isPortrait;
        boolean bl = isPortrait = bounds.width() <= bounds.height();
        if (isPortrait) {
            return new RectF(0.0f, 0.0f, 8.27f, 11.692f);
        }
        return new RectF(0.0f, 0.0f, 11.692f, 8.27f);
    }

    public static RectF usLetterPhysicalBounds(RectF bounds) {
        boolean isPortrait;
        boolean bl = isPortrait = bounds.width() <= bounds.height();
        if (isPortrait) {
            return new RectF(0.0f, 0.0f, 8.5f, 10.98f);
        }
        return new RectF(0.0f, 0.0f, 10.98f, 8.5f);
    }

    public static RectF fitToPhysicalBounds(RectF bounds, RectF physicalBounds) {
        float scaleFactor = Math.min(physicalBounds.width() / (bounds.width() * 0.013888889f), physicalBounds.height() / (bounds.height() * 0.013888889f));
        return new RectF(0.0f, 0.0f, bounds.width() * scaleFactor, bounds.height() * scaleFactor);
    }

    @NonNull
    public static RectF calculatePageBounds(PDFPageSize pageSize, Rect bounds, int rotation) {
        int height;
        int width;
        Locale defaultLocale = Locale.getDefault();
        if (rotation == 90 || rotation == 270) {
            width = bounds.height();
            height = bounds.width();
        } else {
            width = bounds.width();
            height = bounds.height();
        }
        RectF rotatedRect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        switch (pageSize) {
            case A4: {
                return PdfUtils.calculateA4PageBounds(rotatedRect);
            }
            case FIXED_A4: {
                return PdfUtils.calculateFixedA4PageBounds(width, height);
            }
            case US_LETTER: {
                return PdfUtils.calculateUSLetterPageBounds(rotatedRect);
            }
            case FIXED_US_LETTER: {
                return PdfUtils.calculateFixedUSLetterPageBounds(width, height);
            }
            case AUTO_LOCALE: {
                if (defaultLocale == Locale.US) {
                    return PdfUtils.calculateUSLetterPageBounds(rotatedRect);
                }
                return PdfUtils.calculateA4PageBounds(rotatedRect);
            }
            case AUTO: {
                float usLetterRatio;
                float imageRatio = (float)width / (float)height;
                float a4Ratio = width <= height ? 0.7073212f : 1.4137849f;
                float f = usLetterRatio = width <= height ? 0.7741349f : 1.2917646f;
                if (Math.abs(imageRatio - a4Ratio) <= Math.abs(imageRatio - usLetterRatio)) {
                    return PdfUtils.calculateA4PageBounds(rotatedRect);
                }
                return PdfUtils.calculateUSLetterPageBounds(rotatedRect);
            }
            case FROM_IMAGE: {
                return new RectF(0.0f, 0.0f, (float)width, (float)height);
            }
        }
        return rotatedRect;
    }

    @NonNull
    private static RectF calculateFixedUSLetterPageBounds(int width, int height) {
        float usLetterPageWidth = width <= height ? 612.0f : 790.55994f;
        float usLetterPageHeight = width <= height ? 790.55994f : 612.0f;
        return new RectF(0.0f, 0.0f, usLetterPageWidth, usLetterPageHeight);
    }

    @NonNull
    private static RectF calculateFixedA4PageBounds(int width, int height) {
        float a4PageWidth = width <= height ? 595.44f : 841.82404f;
        float a4PageHeight = width <= height ? 841.82404f : 595.44f;
        return new RectF(0.0f, 0.0f, a4PageWidth, a4PageHeight);
    }

    @NonNull
    private static RectF calculateUSLetterPageBounds(RectF rotatedRect) {
        return PdfUtils.fitToPhysicalBounds(rotatedRect, PdfUtils.usLetterPhysicalBounds(rotatedRect));
    }

    @NonNull
    private static RectF calculateA4PageBounds(RectF rotatedRect) {
        return PdfUtils.fitToPhysicalBounds(rotatedRect, PdfUtils.a4PhysicalBounds(rotatedRect));
    }
}

