/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.pdf;

import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\u0007J\u001f\u0010\n\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0011\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0017\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0007J\u0017\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0007R\u0016\u0010\u001c\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u001bR\u0016\u0010\u001f\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001bR\u0016\u0010!\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u0016\u0010#\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001bR\u0016\u0010%\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010\u001bR\u0016\u0010&\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u001bR\u0016\u0010(\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010\u001bR\u0016\u0010*\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010\u001b\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/util/pdf/PdfUtils;", "", "Landroid/graphics/RectF;", "defaultPhysicalBounds", "()Landroid/graphics/RectF;", "bounds", "a4PhysicalBounds", "(Landroid/graphics/RectF;)Landroid/graphics/RectF;", "usLetterPhysicalBounds", "physicalBounds", "fitToPhysicalBounds", "(Landroid/graphics/RectF;Landroid/graphics/RectF;)Landroid/graphics/RectF;", "Lio/scanbot/sdk/process/PDFPageSize;", "pageSize", "Landroid/graphics/Rect;", "", "rotation", "calculatePageBounds", "(Lio/scanbot/sdk/process/PDFPageSize;Landroid/graphics/Rect;I)Landroid/graphics/RectF;", "width", "height", "b", "(II)Landroid/graphics/RectF;", "a", "rotatedRect", "", "g", "F", "US_LETTER_WIDTH_INCHES", "A4_HEIGHT_INCHES", "d", "A4_HEIGHT_UNITS", "e", "A4_WIDTH_UNITS", "i", "US_LETTER_WIDTH_UNITS", "h", "US_LETTER_HEIGHT_UNITS", "UNIT_SIZE_INCHES", "c", "A4_WIDTH_INCHES", "f", "US_LETTER_HEIGHT_INCHES", "<init>", "()V", "sdk-common_release"})
public final class PdfUtils {
    private static final float a = 0.013888889f;
    private static final float b = 11.692f;
    private static final float c = 8.27f;
    private static final float d = 841.82404f;
    private static final float e = 595.44f;
    private static final float f = 10.98f;
    private static final float g = 8.5f;
    private static final float h = 790.55994f;
    private static final float i = 612.0f;
    public static final PdfUtils INSTANCE = new PdfUtils();

    @JvmStatic
    @NotNull
    public static final RectF defaultPhysicalBounds() {
        return new RectF(0.0f, 0.0f, 11.692f, 11.692f);
    }

    @JvmStatic
    @NotNull
    public static final RectF a4PhysicalBounds(@NotNull RectF rectF) {
        RectF rectF2 = rectF;
        Intrinsics.checkNotNullParameter((Object)rectF2, (String)"bounds");
        if (rectF2.width() <= rectF.height()) {
            RectF rectF3;
            rectF = rectF3;
            rectF3 = new RectF(0.0f, 0.0f, 8.27f, 11.692f);
        } else {
            RectF rectF4;
            rectF = rectF4;
            rectF4 = new RectF(0.0f, 0.0f, 11.692f, 8.27f);
        }
        return rectF;
    }

    @JvmStatic
    @NotNull
    public static final RectF usLetterPhysicalBounds(@NotNull RectF rectF) {
        RectF rectF2 = rectF;
        Intrinsics.checkNotNullParameter((Object)rectF2, (String)"bounds");
        if (rectF2.width() <= rectF.height()) {
            RectF rectF3;
            rectF = rectF3;
            rectF3 = new RectF(0.0f, 0.0f, 8.5f, 10.98f);
        } else {
            RectF rectF4;
            rectF = rectF4;
            rectF4 = new RectF(0.0f, 0.0f, 10.98f, 8.5f);
        }
        return rectF;
    }

    @JvmStatic
    @NotNull
    public static final RectF fitToPhysicalBounds(@NotNull RectF rectF, @NotNull RectF rectF2) {
        RectF rectF3 = rectF2;
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)rectF3, (String)"physicalBounds");
        float f = Math.min(rectF3.width() / (rectF.width() * 0.013888889f), rectF2.height() / (rectF.height() * 0.013888889f));
        RectF rectF4 = rectF;
        float f2 = rectF4.width() * f;
        f = rectF4.height() * f;
        return new RectF(0.0f, 0.0f, f2, f);
    }

    @JvmStatic
    @NotNull
    public static final RectF calculatePageBounds(@Nullable PDFPageSize pDFPageSize, @NotNull Rect rect, int n) {
        RectF rectF;
        int n2;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"bounds");
        Locale locale = Locale.getDefault();
        if (n != 90 && n != 270) {
            Rect rect2 = rect;
            n2 = rect2.width();
            n = rect2.height();
        } else {
            Rect rect3 = rect;
            n2 = rect3.height();
            n = rect3.width();
        }
        RectF rectF2 = rectF;
        float f = n2;
        float f2 = n;
        rectF = new RectF(0.0f, 0.0f, f, f2);
        if (pDFPageSize != null) {
            switch (pDFPageSize.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    RectF rectF3;
                    rectF2 = rectF3;
                    rectF3 = new RectF(0.0f, 0.0f, f, f2);
                    break;
                }
                case 6: {
                    float f3 = f / f2;
                    float f4 = n2 <= n ? 0.7073212f : 1.4137849f;
                    float f5 = n2 <= n ? 0.7741349f : 1.2917646f;
                    if (Math.abs(f3 - f4) <= Math.abs(f3 - f5)) {
                        rectF2 = INSTANCE.a(rectF2);
                        break;
                    }
                    rectF2 = INSTANCE.b(rectF2);
                    break;
                }
                case 5: {
                    if (locale == Locale.US) {
                        rectF2 = INSTANCE.b(rectF2);
                        break;
                    }
                    rectF2 = INSTANCE.a(rectF2);
                    break;
                }
                case 4: {
                    rectF2 = INSTANCE.b(n2, n);
                    break;
                }
                case 3: {
                    rectF2 = INSTANCE.b(rectF2);
                    break;
                }
                case 2: {
                    rectF2 = INSTANCE.a(n2, n);
                    break;
                }
                case 1: {
                    rectF2 = INSTANCE.a(rectF2);
                }
            }
        }
        return rectF2;
    }

    private final RectF b(int n, int n2) {
        float f = n <= n2 ? 612.0f : 790.55994f;
        float f2 = n <= n2 ? 790.55994f : 612.0f;
        return new RectF(0.0f, 0.0f, f, f2);
    }

    private final RectF a(int n, int n2) {
        float f = n <= n2 ? 595.44f : 841.82404f;
        float f2 = n <= n2 ? 841.82404f : 595.44f;
        return new RectF(0.0f, 0.0f, f, f2);
    }

    private final RectF b(RectF rectF) {
        RectF rectF2 = rectF;
        return PdfUtils.fitToPhysicalBounds(rectF2, PdfUtils.usLetterPhysicalBounds(rectF2));
    }

    private final RectF a(RectF rectF) {
        RectF rectF2 = rectF;
        return PdfUtils.fitToPhysicalBounds(rectF2, PdfUtils.a4PhysicalBounds(rectF2));
    }

    private PdfUtils() {
    }
}

