/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.dcscanner;

import android.graphics.Bitmap;
import io.scanbot.dcscanner.DisabilityCertificateRecognizer;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.dcscanner.DCScanner;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/dcscanner/DefaultDCScanner;", "Lio/scanbot/sdk/dcscanner/DCScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "dcRecognizer", "Lio/scanbot/dcscanner/DisabilityCertificateRecognizer;", "detectAndRecognizeDCBitmap", "Lio/scanbot/dcscanner/model/DisabilityCertificateRecognizerResultInfo;", "image", "Landroid/graphics/Bitmap;", "orientation", "", "detectAndRecognizeDCJPEG", "", "width", "height", "recognizeDC", "nv21", "recognizeDCBGR", "bgr", "recognizeDCBitmap", "recognizeDCJPEG", "sdk-dc_release"})
public final class DefaultDCScanner
implements DCScanner {
    private final DisabilityCertificateRecognizer dcRecognizer;

    @Override
    @Nullable
    public DisabilityCertificateRecognizerResultInfo recognizeDC(@NotNull byte[] nv21, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        return this.dcRecognizer.recognizeDC(nv21, width, height, orientation);
    }

    @Override
    @Nullable
    public DisabilityCertificateRecognizerResultInfo recognizeDCBGR(@NotNull byte[] bgr, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)bgr, (String)"bgr");
        return this.dcRecognizer.recognizeDCBGR(bgr, width, height, orientation);
    }

    @Override
    @Nullable
    public DisabilityCertificateRecognizerResultInfo recognizeDCJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.dcRecognizer.recognizeDCJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public DisabilityCertificateRecognizerResultInfo recognizeDCBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.dcRecognizer.recognizeDCBitmap(image, orientation);
    }

    @Override
    @Nullable
    public DisabilityCertificateRecognizerResultInfo detectAndRecognizeDCJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.dcRecognizer.detectAndRecognizeDCJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public DisabilityCertificateRecognizerResultInfo detectAndRecognizeDCBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.dcRecognizer.detectAndRecognizeDCBitmap(image, orientation);
    }

    public DefaultDCScanner(@NotNull BlobManager blobManager) {
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        String dcTraineddataPath = null;
        String dcModelsFolderPath = null;
        try {
            dcTraineddataPath = blobManager.getOcrBlobsDirectory().getPath();
            dcModelsFolderPath = blobManager.getDcModelsFolderFile().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("DC blob is not available.");
        }
        String string = dcTraineddataPath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dcTraineddataPath");
        String string2 = dcModelsFolderPath;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dcModelsFolderPath");
        this.dcRecognizer = new DisabilityCertificateRecognizer(string, string2);
    }
}

