/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.contourdetector;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.docdetection.R;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0003;<=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fJ\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0016H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010,\u001a\u00020\u000e2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.H\u0004J\u000e\u00101\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u000204J\u001a\u00107\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\b2\b\u00108\u001a\u0004\u0018\u000109H\u0002J\u0016\u0010:\u001a\u00020\u001b2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "context", "Landroid/content/Context;", "contourDetector", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "(Landroid/content/Context;Lio/scanbot/sdk/core/contourdetector/ContourDetector;)V", "finderInnerThresholdPx", "", "finderOuterThresholdPx", "handlers", "", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "kotlin.jvm.PlatformType", "requiredPageAspectRatios", "", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "sapManager", "Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "checkInnerThreshold", "finderRect", "Landroid/graphics/Rect;", "polygonRect", "checkOuterThreshold", "detectOffCenter", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "detectionResult", "polygon", "Landroid/graphics/PointF;", "fixRequiredAspectRatios", "frameOrientation", "handleFrame", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$DetectedFrame;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "setAcceptedAngleScore", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setRectOfInterest", "visibleRect", "Landroid/graphics/RectF;", "setRequiredAspectRatios", "Companion", "DetectedFrame", "ResultHandler", "sdk-docdetection_release"})
public final class ContourDetectorFrameHandler
implements FrameHandler {
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    private boolean isEnabled;
    private List<PageAspectRatio> requiredPageAspectRatios;
    private final ContourDetector contourDetector;
    public static final Companion Companion = new Companion(null);

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.EdgeDetection).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError())));
            return false;
        }
        this.fixRequiredAspectRatios(previewFrame.frameOrientation);
        this.setRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
        Intrinsics.checkExpressionValueIsNotNull((Object)previewFrame.frame, (String)"previewFrame.frame");
        DetectionResult detectionResult = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
        List polygon = this.contourDetector.getPolygonF();
        detectionResult = this.detectOffCenter(previewFrame, detectionResult, polygon);
        DetectedFrame detectedFrame = new DetectedFrame(detectionResult, polygon, previewFrame.frameOrientation, previewFrame.width, previewFrame.height, this.contourDetector.getDetectionScore(), previewFrame.finderRect, this.requiredPageAspectRatios);
        return this.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)detectedFrame)));
    }

    private final DetectionResult detectOffCenter(FrameHandler.Frame previewFrame, DetectionResult detectionResult, List<? extends PointF> polygon) {
        DetectionResult detectionResult2 = detectionResult;
        if (previewFrame.finderRect != null) {
            Rect rect = previewFrame.finderRect;
            Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"previewFrame.finderRect");
            if (!(rect.isEmpty() || detectionResult2 != DetectionResult.OK && detectionResult2 != DetectionResult.OK_BUT_BAD_ASPECT_RATIO && detectionResult2 != DetectionResult.OK_BUT_TOO_SMALL && detectionResult2 != DetectionResult.OK_BUT_BAD_ANGLES)) {
                List rotatedPolygon = PolygonHelper.Companion.rotatePolygon(polygon, (float)previewFrame.frameOrientation);
                boolean frameNotRotated = previewFrame.frameOrientation % 180 == 0;
                int frameWidth = frameNotRotated ? previewFrame.width : previewFrame.height;
                int frameHeight = frameNotRotated ? previewFrame.height : previewFrame.width;
                Rect polygonRect = new Rect((int)(((PointF)rotatedPolygon.get((int)0)).x * (float)frameWidth), (int)(((PointF)rotatedPolygon.get((int)0)).y * (float)frameHeight), (int)(((PointF)rotatedPolygon.get((int)2)).x * (float)frameWidth), (int)(((PointF)rotatedPolygon.get((int)2)).y * (float)frameHeight));
                Rect rect2 = previewFrame.finderRect;
                Intrinsics.checkExpressionValueIsNotNull((Object)rect2, (String)"previewFrame.finderRect");
                if (this.checkOuterThreshold(rect2, polygonRect)) {
                    detectionResult2 = DetectionResult.OK_OFF_CENTER;
                } else {
                    List<PageAspectRatio> list = this.requiredPageAspectRatios;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!list.isEmpty()) {
                        Rect rect3 = previewFrame.finderRect;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rect3, (String)"previewFrame.finderRect");
                        if (this.checkInnerThreshold(rect3, polygonRect)) {
                            detectionResult2 = DetectionResult.OK_BUT_TOO_SMALL;
                        }
                    }
                }
            }
        }
        return detectionResult2;
    }

    private final boolean checkInnerThreshold(Rect finderRect, Rect polygonRect) {
        return polygonRect.left - finderRect.left > this.finderInnerThresholdPx || polygonRect.top - finderRect.top > this.finderInnerThresholdPx || finderRect.bottom - polygonRect.bottom > this.finderInnerThresholdPx || finderRect.right - polygonRect.right > this.finderInnerThresholdPx;
    }

    private final boolean checkOuterThreshold(Rect finderRect, Rect polygonRect) {
        return finderRect.left - polygonRect.left > this.finderOuterThresholdPx || finderRect.top - polygonRect.top > this.finderOuterThresholdPx || polygonRect.bottom - finderRect.bottom > this.finderOuterThresholdPx || polygonRect.right - finderRect.right > this.finderOuterThresholdPx;
    }

    private final void setRectOfInterest(int frameOrientation, RectF visibleRect) {
        if (visibleRect != null) {
            RectF rotatedVisibleRect = visibleRect;
            Matrix matrix = new Matrix();
            matrix.setRotate((float)frameOrientation, 0.5f, 0.5f);
            matrix.mapRect(rotatedVisibleRect);
            this.contourDetector.setRectOfInterest(rotatedVisibleRect);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fixRequiredAspectRatios(int frameOrientation) {
        if (this.requiredPageAspectRatios != null) {
            List<PageAspectRatio> list = this.requiredPageAspectRatios;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (!list.isEmpty()) {
                List fixedAspectRatios = new ArrayList();
                List<PageAspectRatio> list2 = this.requiredPageAspectRatios;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                for (PageAspectRatio pageAspectRatio : list2) {
                    void width;
                    double d = pageAspectRatio.component1();
                    double height = pageAspectRatio.component2();
                    boolean frameNotRotated = frameOrientation % 180 == 0;
                    PageAspectRatio fixedAspectRatio = frameNotRotated ? new PageAspectRatio((double)width, height) : new PageAspectRatio(height, (double)width);
                    fixedAspectRatios.add(fixedAspectRatio);
                }
                this.contourDetector.setRequiredAspectRatios(fixedAspectRatios);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.handlers.remove(handler);
        }
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        boolean bl = !(acceptedAngleScore < 0.0) && !(acceptedAngleScore > (double)100);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid acceptedAngleScore value.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.contourDetector.setAcceptedAngleScore(acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        boolean bl = !(acceptedSizeScore < 0.0) && !(acceptedSizeScore > (double)100);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid acceptedSizeScore value.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.contourDetector.setAcceptedSizeScore(acceptedSizeScore);
    }

    public final void setRequiredAspectRatios(@Nullable List<PageAspectRatio> requiredPageAspectRatios) {
        this.requiredPageAspectRatios = requiredPageAspectRatios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean notifyHandlers(@NotNull FrameHandlerResult<DetectedFrame, SdkLicenseError> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        boolean handled = false;
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    public ContourDetectorFrameHandler(@NotNull Context context, @NotNull ContourDetector contourDetector) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)contourDetector, (String)"contourDetector");
        this.contourDetector = contourDetector;
        this.handlers = new LinkedHashSet();
        SapManager sapManager = SapSingleton.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
        this.logger = LoggerProvider.getLogger();
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
        this.isEnabled = true;
    }

    @JvmStatic
    @NotNull
    public static final ContourDetectorFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull ContourDetector detector) {
        return Companion.attach(cameraView, detector);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$DetectedFrame;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-docdetection_release"})
    public static interface ResultHandler
    extends BaseResultHandler<DetectedFrame, SdkLicenseError> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bBY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$DetectedFrame;", "", "detectionResult", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "polygon", "", "Landroid/graphics/PointF;", "frameOrientation", "", "frameWidth", "frameHeight", "(Lio/scanbot/sdk/core/contourdetector/DetectionResult;Ljava/util/List;III)V", "detectionScore", "", "finderRect", "Landroid/graphics/Rect;", "requiredPageAspectRatios", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "(Lio/scanbot/sdk/core/contourdetector/DetectionResult;Ljava/util/List;IIIDLandroid/graphics/Rect;Ljava/util/List;)V", "sdk-docdetection_release"})
    public static final class DetectedFrame {
        @JvmField
        @NotNull
        public final DetectionResult detectionResult;
        @JvmField
        @NotNull
        public final List<PointF> polygon;
        @JvmField
        public final int frameOrientation;
        @JvmField
        public final int frameWidth;
        @JvmField
        public final int frameHeight;
        @JvmField
        public final double detectionScore;
        @JvmField
        @Nullable
        public final Rect finderRect;
        @JvmField
        @Nullable
        public final List<PageAspectRatio> requiredPageAspectRatios;

        @Deprecated(message="please use {@link DetectedFrame#DetectedFrame(DetectionResult, List, int, int, int, double, Rect, List)}")
        public DetectedFrame(@NotNull DetectionResult detectionResult, @Nullable List<? extends PointF> polygon, int frameOrientation, int frameWidth, int frameHeight) {
            Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            List<? extends PointF> list = Collections.unmodifiableList(polygon);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(polygon)");
            this.polygon = list;
            this.detectionScore = 0.0;
            this.finderRect = null;
            this.requiredPageAspectRatios = null;
        }

        public DetectedFrame(@NotNull DetectionResult detectionResult, @Nullable List<? extends PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, @Nullable Rect finderRect, @Nullable List<PageAspectRatio> requiredPageAspectRatios) {
            Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            List<? extends PointF> list = Collections.unmodifiableList(polygon);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(polygon)");
            this.polygon = list;
            this.detectionScore = detectionScore;
            this.finderRect = finderRect;
            this.requiredPageAspectRatios = requiredPageAspectRatios;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "detector", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "sdk-docdetection_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ContourDetectorFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull ContourDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            Context context = ((View)cameraView).getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"(cameraView as View).context");
            ContourDetectorFrameHandler frameHandler = new ContourDetectorFrameHandler(context, detector);
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

