/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.ui.camera.AdaptiveFinderOverlayViewKt;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.doo.snap.camera.CameraPreviewMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002JD\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "contourDetectorFrameHandler", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "finderAnimation", "Landroid/animation/AnimatorSet;", "animatePaddingChanges", "", "paddingLeftRight", "", "paddingTopBottom", "handleDetectionResult", "requiredAspectRatios", "", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "detectionResult", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "frameWidth", "frameHeight", "frameOrientation", "polygon", "Landroid/graphics/PointF;", "sdk-docdetection_release"})
public class AdaptiveFinderOverlayView
extends FinderOverlayView {
    private AnimatorSet finderAnimation = new AnimatorSet();
    @NotNull
    private final ContourDetectorFrameHandler.ResultHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler.ResultHandler(this){
        final /* synthetic */ AdaptiveFinderOverlayView this$0;

        public boolean handle(@NotNull FrameHandlerResult<ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> result) {
            block1: {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                FrameHandlerResult<ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> frameHandlerResult = result;
                if (!(frameHandlerResult instanceof FrameHandlerResult.Success)) break block1;
                Object object = ((FrameHandlerResult.Success)result).getValue();
                boolean bl = false;
                boolean bl2 = false;
                ContourDetectorFrameHandler.DetectedFrame it = (ContourDetectorFrameHandler.DetectedFrame)object;
                boolean bl3 = false;
                AdaptiveFinderOverlayView adaptiveFinderOverlayView = this.this$0;
                List list = it.requiredPageAspectRatios;
                if (list == null || (list = AdaptiveFinderOverlayViewKt.toFinderAspectRatios(list)) == null) {
                    AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
                    boolean bl4 = false;
                    List list2 = CollectionsKt.emptyList();
                    adaptiveFinderOverlayView = adaptiveFinderOverlayView2;
                    list = list2;
                }
                adaptiveFinderOverlayView.handleDetectionResult(list, it.detectionResult, it.frameWidth, it.frameHeight, it.frameOrientation, it.polygon);
            }
            return false;
        }
        {
            this.this$0 = $outer;
        }
    };

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.contourDetectorFrameHandler;
    }

    protected final void handleDetectionResult(@NotNull List<FinderAspectRatio> requiredAspectRatios, @NotNull DetectionResult detectionResult, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        List currentRequiredAspectRatios;
        Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
        Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
        Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return;
        }
        Collection collection = requiredAspectRatios;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.setRequiredAspectRatios(requiredAspectRatios);
        }
        if ((currentRequiredAspectRatios = this.getRequiredAspectRatios()) == null || currentRequiredAspectRatios.isEmpty() || this.finderAnimation.isRunning()) {
            return;
        }
        if (polygon.size() > 0 && (detectionResult == DetectionResult.OK || detectionResult == DetectionResult.OK_BUT_BAD_ANGLES || detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO || detectionResult == DetectionResult.OK_BUT_TOO_SMALL || detectionResult == DetectionResult.OK_OFF_CENTER)) {
            double d;
            FinderAspectRatio targetPageSize;
            Object v0;
            int scaledFrameWidth = 0;
            int scaledFrameHeight = 0;
            if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
                int rotatedFrameWidth = frameOrientation % 180 == 0 ? frameWidth : frameHeight;
                int rotatedFrameHeight = frameOrientation % 180 == 0 ? frameHeight : frameWidth;
                double frameAspectRatio = (double)rotatedFrameWidth / (double)rotatedFrameHeight;
                double cameraViewAspectRatio = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                scaledFrameWidth = cameraViewAspectRatio < frameAspectRatio ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * frameAspectRatio);
                scaledFrameHeight = cameraViewAspectRatio < frameAspectRatio ? (int)((double)this.getMeasuredWidth() / frameAspectRatio) : this.getMeasuredHeight();
            } else {
                scaledFrameWidth = this.getMeasuredWidth();
                scaledFrameHeight = this.getMeasuredHeight();
            }
            int finderWidth = scaledFrameWidth - 2 * this.getMinFinderPadding();
            int finderHeight = scaledFrameHeight - 2 * this.getMinFinderPadding();
            double finderAspectRatio = (double)finderWidth / (double)finderHeight;
            float approximatePolygonAspectRatio = PolygonHelper.Companion.approximatePolygonAspectRatio(polygon, frameWidth, frameHeight, frameOrientation);
            Iterable $this$minBy$iv = currentRequiredAspectRatios;
            boolean $i$f$minBy = false;
            FinderAspectRatio iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    FinderAspectRatio it = (FinderAspectRatio)minElem$iv;
                    boolean bl2 = false;
                    double d2 = (double)approximatePolygonAspectRatio - it.getWidth() / it.getHeight();
                    boolean bl3 = false;
                    double minValue$iv = Math.abs(d2);
                    do {
                        Object e$iv = iterator$iv.next();
                        FinderAspectRatio it2 = (FinderAspectRatio)e$iv;
                        $i$a$-minBy-AdaptiveFinderOverlayView$handleDetectionResult$targetPageSize$1 = false;
                        double d3 = (double)approximatePolygonAspectRatio - it2.getWidth() / it2.getHeight();
                        boolean bl4 = false;
                        double v$iv = Math.abs(d3);
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            FinderAspectRatio finderAspectRatio2 = targetPageSize = (FinderAspectRatio)v0;
            if (finderAspectRatio2 != null) {
                iterator$iv = finderAspectRatio2;
                boolean minElem$iv = false;
                boolean minValue$iv = false;
                FinderAspectRatio it = iterator$iv;
                boolean bl5 = false;
                d = it.getWidth() / it.getHeight();
            } else {
                d = finderAspectRatio;
            }
            double targetAspectRatio = d;
            Ref.IntRef paddingTopBottom = new Ref.IntRef();
            Ref.IntRef paddingLeftRight = new Ref.IntRef();
            if (targetAspectRatio < finderAspectRatio) {
                double targetWidth = (double)finderHeight * targetAspectRatio;
                paddingTopBottom.element = this.getMinFinderPadding() + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight.element = (int)(((double)scaledFrameWidth - targetWidth) / (double)2) + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            } else {
                double targetHeight = (double)finderWidth / targetAspectRatio;
                paddingTopBottom.element = (int)(((double)scaledFrameHeight - targetHeight) / (double)2) + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight.element = this.getMinFinderPadding() + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            }
            this.post(new Runnable(this, paddingLeftRight, paddingTopBottom){
                final /* synthetic */ AdaptiveFinderOverlayView this$0;
                final /* synthetic */ Ref.IntRef $paddingLeftRight;
                final /* synthetic */ Ref.IntRef $paddingTopBottom;

                public final void run() {
                    AdaptiveFinderOverlayView.access$animatePaddingChanges(this.this$0, this.$paddingLeftRight.element, this.$paddingTopBottom.element);
                }
                {
                    this.this$0 = adaptiveFinderOverlayView;
                    this.$paddingLeftRight = intRef;
                    this.$paddingTopBottom = intRef2;
                }
            });
        }
    }

    private final void animatePaddingChanges(int paddingLeftRight, int paddingTopBottom) {
        if (this.getPaddingRight() == paddingLeftRight && this.getPaddingLeft() == paddingLeftRight && this.getPaddingTop() == paddingTopBottom && this.getPaddingBottom() == paddingTopBottom) {
            return;
        }
        ValueAnimator animatorPaddingRight = ValueAnimator.ofInt((int[])new int[]{this.getPaddingRight(), paddingLeftRight});
        animatorPaddingRight.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ AdaptiveFinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = this.this$0.getPaddingLeft();
                int n2 = this.this$0.getPaddingTop();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding(n, n2, (Integer)object, this.this$0.getPaddingBottom());
            }
            {
                this.this$0 = adaptiveFinderOverlayView;
            }
        });
        ValueAnimator animatorPaddingLeft = ValueAnimator.ofInt((int[])new int[]{this.getPaddingLeft(), paddingLeftRight});
        animatorPaddingLeft.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ AdaptiveFinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding((Integer)object, this.this$0.getPaddingTop(), this.this$0.getPaddingRight(), this.this$0.getPaddingBottom());
            }
            {
                this.this$0 = adaptiveFinderOverlayView;
            }
        });
        ValueAnimator animatorPaddingTop = ValueAnimator.ofInt((int[])new int[]{this.getPaddingTop(), paddingTopBottom});
        animatorPaddingTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ AdaptiveFinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = this.this$0.getPaddingLeft();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding(n, (Integer)object, this.this$0.getPaddingRight(), this.this$0.getPaddingBottom());
            }
            {
                this.this$0 = adaptiveFinderOverlayView;
            }
        });
        ValueAnimator animatorPaddingBottom = ValueAnimator.ofInt((int[])new int[]{this.getPaddingBottom(), paddingTopBottom});
        animatorPaddingBottom.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ AdaptiveFinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = this.this$0.getPaddingLeft();
                int n2 = this.this$0.getPaddingTop();
                int n3 = this.this$0.getPaddingRight();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding(n, n2, n3, (Integer)object);
                Object object2 = valueAnimator.getAnimatedValue();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.adjustDescriptionPosition((Integer)object2);
                this.this$0.invalidate();
            }
            {
                this.this$0 = adaptiveFinderOverlayView;
            }
        });
        this.finderAnimation.end();
        this.finderAnimation.cancel();
        AnimatorSet animatorSet = this.finderAnimation = new AnimatorSet();
        boolean bl = false;
        boolean bl2 = false;
        AnimatorSet $this$apply = animatorSet;
        boolean bl3 = false;
        $this$apply.playTogether(new Animator[]{(Animator)animatorPaddingRight, (Animator)animatorPaddingLeft, (Animator)animatorPaddingTop, (Animator)animatorPaddingBottom});
        $this$apply.setDuration(200L);
        $this$apply.start();
    }

    public AdaptiveFinderOverlayView(@Nullable Context context, @Nullable AttributeSet attr) {
        super(context, attr);
    }

    public static final /* synthetic */ void access$animatePaddingChanges(AdaptiveFinderOverlayView $this, int paddingLeftRight, int paddingTopBottom) {
        $this.animatePaddingChanges(paddingLeftRight, paddingTopBottom);
    }
}

