/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.LayoutTransition;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import androidx.core.graphics.Insets;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.ui.camera.AdaptiveFinderOverlayViewKt;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JD\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0013H\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "contourDetectorFrameHandler", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "finderAnimation", "Landroid/animation/AnimatorSet;", "animatePaddingChanges", "", "insets", "Landroidx/core/graphics/Insets;", "handleDetectionResult", "requiredAspectRatios", "", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "detectionStatus", "Lio/scanbot/sdk/core/contourdetector/DetectionStatus;", "frameWidth", "", "frameHeight", "frameOrientation", "polygon", "Landroid/graphics/PointF;", "sdk-docdetection_release"})
public class AdaptiveFinderOverlayView
extends FinderOverlayView {
    @NotNull
    private AnimatorSet a;
    @NotNull
    private final ContourDetectorFrameHandler.ResultHandler b;

    /*
     * WARNING - void declaration
     */
    public AdaptiveFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        void var2_2;
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        adaptiveFinderOverlayView.a = new AnimatorSet();
        LayoutTransition layoutTransition = new LayoutTransition();
        layoutTransition.enableTransitionType(4);
        adaptiveFinderOverlayView.setLayoutTransition(layoutTransition);
        adaptiveFinderOverlayView.b = arg_0 -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView, arg_0);
    }

    private final void a(Insets insets) {
        ValueAnimator valueAnimator;
        if (this.getOverlayRightPadding() == valueAnimator.right && this.getOverlayLeftPadding() == valueAnimator.left && this.getOverlayTopPadding() == valueAnimator.top && this.getOverlayBottomPadding() == valueAnimator.bottom) {
            return;
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayRightPadding(), valueAnimator.right});
        valueAnimator2.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.a(this, arg_0));
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayLeftPadding(), valueAnimator.left});
        valueAnimator3.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.b(this, arg_0));
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayTopPadding(), valueAnimator.top});
        valueAnimator4.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.c(this, arg_0));
        valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getOverlayBottomPadding(), valueAnimator.bottom});
        valueAnimator.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.d(this, arg_0));
        adaptiveFinderOverlayView.a.end();
        adaptiveFinderOverlayView.a.cancel();
        this.a = new AnimatorSet();
        this.a.playTogether(new Animator[]{valueAnimator2, valueAnimator3, valueAnimator4, valueAnimator});
        this.a.setDuration(200L);
        this.a.start();
    }

    private static final boolean a(AdaptiveFinderOverlayView this$0, FrameHandlerResult result) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        FrameHandlerResult frameHandlerResult = result;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)frameHandlerResult, (String)"result");
        if (frameHandlerResult instanceof FrameHandlerResult.Success) {
            ContourDetectorFrameHandler.DetectedFrame detectedFrame;
            detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
            List<FinderAspectRatio> list = detectedFrame.requiredPageAspectRatios;
            if (list == null || (list = AdaptiveFinderOverlayViewKt.toFinderAspectRatios(list)) == null) {
                list = CollectionsKt.emptyList();
            }
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            ContourDetectorFrameHandler.DetectedFrame detectedFrame2 = detectedFrame;
            adaptiveFinderOverlayView = detectedFrame2.detectionStatus;
            int n = detectedFrame2.frameWidth;
            int n2 = detectedFrame2.frameHeight;
            int n3 = detectedFrame2.frameOrientation;
            List<PointF> list2 = detectedFrame2.polygon;
            adaptiveFinderOverlayView2.handleDetectionResult(list, (DetectionStatus)adaptiveFinderOverlayView, n, n2, n3, list2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void a(AdaptiveFinderOverlayView this$0, Insets $calculatedInset) {
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$calculatedInset");
        this$0.a((Insets)var1_1);
    }

    private static final void a(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayRightPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    private static final void b(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayLeftPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    private static final void c(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayTopPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    private static final void d(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            adaptiveFinderOverlayView2.setOverlayBottomPadding((Integer)object);
            adaptiveFinderOverlayView2.initPaintAndRect();
            adaptiveFinderOverlayView2.invalidate();
            adaptiveFinderOverlayView2.resizeContentViews();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void handleDetectionResult(@NotNull List<FinderAspectRatio> requiredAspectRatios, @NotNull DetectionStatus detectionStatus, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        void var3_15;
        void var5_22;
        void var4_19;
        void var3_6;
        FinderAspectRatio finderAspectRatio;
        void var2_4;
        List list;
        Intrinsics.checkNotNullParameter((Object)list, (String)"requiredAspectRatios");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"detectionStatus");
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return;
        }
        if (list.isEmpty() ^ true) {
            this.setRequiredAspectRatiosInternal(list);
        }
        if ((list = this.getRequiredAspectRatios()) == null) return;
        if (list.isEmpty()) return;
        if (this.a.isRunning()) {
            return;
        }
        if (!(finderAspectRatio.isEmpty() ^ true)) return;
        if (var2_4 != DetectionStatus.OK && var2_4 != DetectionStatus.OK_BUT_BAD_ANGLES && var2_4 != DetectionStatus.OK_BUT_BAD_ASPECT_RATIO && var2_4 != DetectionStatus.OK_BUT_TOO_SMALL) {
            if (var2_4 != DetectionStatus.OK_OFF_CENTER) return;
        }
        Pair pair = this.calculatePreviewFrameSize();
        int n = ((Number)pair.component1()).intValue();
        int n2 = ((Number)pair.component2()).intValue();
        int n3 = n2;
        int n4 = n;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        n3 = (adaptiveFinderOverlayView.getMeasuredHeight() - n3) / 2;
        n = (adaptiveFinderOverlayView.getMeasuredWidth() - n) / 2;
        Pair pair2 = adaptiveFinderOverlayView.calculateTotalPaddings(n, n3);
        int n5 = ((Number)pair2.component2()).intValue();
        int n6 = n4 - ((Number)pair2.component1()).intValue();
        n5 = n2 - n5;
        double d = (double)n6 / (double)n5;
        float f = PolygonHelper.Companion.approximatePolygonAspectRatio((List)finderAspectRatio, (int)var3_6, (int)var4_19, (int)var5_22);
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            Object var3_8 = null;
        } else {
            Iterator iterator2 = iterator;
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                Object t2 = t;
            } else {
                FinderAspectRatio finderAspectRatio2 = (FinderAspectRatio)t;
                double d2 = f;
                double d3 = Math.abs(d2 - finderAspectRatio2.getWidth() / finderAspectRatio2.getHeight());
                while (true) {
                    void var3_14;
                    Object t3;
                    double d4;
                    if (Double.compare(d3, d4 = Math.abs(d2 - (finderAspectRatio = (FinderAspectRatio)(t3 = iterator.next())).getWidth() / finderAspectRatio.getHeight())) <= 0) {
                        void var5_24;
                        void var3_13 = var5_24;
                        d4 = d3;
                    }
                    if (!iterator.hasNext()) break;
                    void var5_26 = var3_14;
                    d3 = d4;
                }
            }
        }
        FinderAspectRatio finderAspectRatio3 = (FinderAspectRatio)var3_15;
        if (finderAspectRatio3 != null) {
            d = finderAspectRatio3.getWidth() / finderAspectRatio3.getHeight();
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = this;
        Pair pair3 = adaptiveFinderOverlayView2.calculateTargetSize(d, n5, n6);
        int n7 = ((Number)pair3.component1()).intValue();
        int n8 = ((Number)pair3.component2()).intValue();
        n8 = (n5 - n8) / 2;
        int n9 = adaptiveFinderOverlayView2.getFinderInsets().top + n8 + Math.max(this.getSafeAreaInsets().top, n3);
        n3 = adaptiveFinderOverlayView2.getFinderInsets().bottom + n8 + Math.max(this.getSafeAreaInsets().bottom, n3);
        int n10 = (n6 - n7) / 2;
        int n11 = adaptiveFinderOverlayView2.getFinderInsets().left + n10 + Math.max(this.getSafeAreaInsets().left, n);
        int n12 = this.getFinderInsets().right + n10 + Math.max(this.getSafeAreaInsets().right, n);
        Insets.of((int)n11, (int)n9, (int)n12, (int)n3);
        Insets insets = Insets.of((int)n11, (int)n9, (int)n12, (int)n3);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"of(paddingLeft, paddingT\u2026dingRight, paddingBottom)");
        adaptiveFinderOverlayView2.post(() -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView2, insets));
    }
}

