/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import android.graphics.Rect;
import android.graphics.RectF;
import crl.android.pdfwriter.PDFWriter;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.PageEntity;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.pdf.PdfUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageStoreStrategy", "Lio/scanbot/sdk/persistence/PageStoreStrategy;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageStoreStrategy;)V", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/entity/PageEntity;", "composePDF", "pdfWriter", "Lcrl/android/pdfwriter/PDFWriter;", "writeDocumentToFile", "sdk-docprocessing_release"})
public final class SimpleComposer
implements Composer {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;

    @Override
    public void composeDocument(@NotNull Document document, @NotNull List<PageEntity> pages) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        if (document.size > 0L) {
            throw (Throwable)new IOException("Document already exists");
        }
        PDFWriter pdfWriter = new PDFWriter();
        this.composePDF(pdfWriter, pages);
        this.writeDocumentToFile(document, pdfWriter);
    }

    private final void composePDF(PDFWriter pdfWriter, List<PageEntity> pages) throws IOException {
        for (PageEntity page : pages) {
            File file = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.OPTIMIZED);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pageStoreStrategy.getIma\u2026tity.ImageType.OPTIMIZED)");
            String optimizedPath = file.getPath();
            Rect bounds = BitmapUtils.getBitmapBounds((String)optimizedPath);
            int rotation = page.rotationType.getDegrees();
            RectF convertedBounds = PdfUtils.calculatePageBounds((PDFPageSize)page.pageSize, (Rect)bounds, (int)rotation);
            int convertedWidth = (int)convertedBounds.width();
            int convertedHeight = (int)convertedBounds.height();
            pdfWriter.newPage(convertedWidth, convertedHeight);
            pdfWriter.addJPGImageKeepRatio(convertedWidth, convertedHeight, -rotation, optimizedPath);
        }
        pdfWriter.setDocumentInfo("/Creator (Scanbot for Android)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDocumentToFile(Document document, PDFWriter pdfWriter) throws IOException {
        File pdf = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(pdf));
            pdfWriter.write(os);
            os.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public SimpleComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageStoreStrategy pageStoreStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)pageStoreStrategy, (String)"pageStoreStrategy");
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
    }
}

