/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import android.content.res.Resources;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.DocumentProcessor;
import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.util.bitmap.BitmapLruCache;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessorProvider
implements Provider<DocumentProcessor> {
    private final SapManager sapManager;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final Resources resources;
    private final BitmapLruCache bitmapLruCache;
    private final ComposerFactory composerFactory;
    private final ProcessorMonitor<Document> documentProcessorMonitor;
    private final Cleaner cleaner;

    @Inject
    public DocumentProcessorProvider(SapManager sapManager, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, ProcessorMonitor<Document> documentProcessorMonitor, Cleaner cleaner) {
        this.sapManager = sapManager;
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.resources = resources;
        this.bitmapLruCache = bitmapLruCache;
        this.composerFactory = composerFactory;
        this.documentProcessorMonitor = documentProcessorMonitor;
        this.cleaner = cleaner;
    }

    public DocumentProcessor get() {
        if (!this.sapManager.checkLicenseStatus(SdkFeature.NoSdkFeature).booleanValue()) {
            return new DocumentProcessor(this.documentStoreStrategy, this.pageStoreStrategy, this.resources, this.bitmapLruCache, this.composerFactory, this.documentProcessorMonitor, this.cleaner){

                @Override
                public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
                    return null;
                }
            };
        }
        return new DocumentProcessor(this.documentStoreStrategy, this.pageStoreStrategy, this.resources, this.bitmapLruCache, this.composerFactory, this.documentProcessorMonitor, this.cleaner);
    }
}

