/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.JpegComposer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class BaseComposerFactory
implements ComposerFactory {
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    @Inject
    public BaseComposerFactory(SimpleComposer simpleComposer, JpegComposer jpegComposer) {
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }

    @Override
    @NotNull
    public Composer composerForDocument(Document document) {
        if (document.getName().endsWith(".jpg")) {
            return this.buildJpegOrDummyComposer(document);
        }
        return this.buildSimpleOrDummyComposer(document);
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.simpleComposer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.jpegComposer;
    }
}

