/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.apache.commons.io.FileUtils;

public class JpegComposer
implements Composer {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final Logger logger = LoggerProvider.getLogger();

    @Inject
    public JpegComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
    }

    @Override
    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (pages.length != 1) {
            throw new IllegalArgumentException("Composer can only take 1 page");
        }
        this.processJpeg(document, pages[0]);
    }

    private void processJpeg(Document document, Page page) throws IOException {
        File optimized = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
        File image = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        FileUtils.copyFile((File)optimized, (File)image);
        int rotation = page.getRotationType().getDegrees();
        if (rotation != 0 && rotation != 360) {
            try {
                Bitmap imageBitmap = BitmapFactory.decodeFile((String)image.getPath());
                if (imageBitmap == null) {
                    throw new IOException("Can't decode file into bitmap or path doesn't exist");
                }
                int width = imageBitmap.getWidth();
                int height = imageBitmap.getHeight();
                Matrix matrix = new Matrix();
                matrix.setRotate((float)rotation, (float)(width / 2), (float)(height / 2));
                Bitmap rotated = Bitmap.createBitmap((Bitmap)imageBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                imageBitmap.recycle();
                BitmapUtils.compress((Bitmap)rotated, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90, (File)image);
                rotated.recycle();
            }
            catch (IOException | OutOfMemoryError e) {
                this.logger.logException(e);
            }
        }
    }
}

