/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import java.io.File;
import java.io.IOException;

public class DocumentProcessorMonitor
implements ProcessorMonitor<Document> {
    private final DocumentStoreStrategy documentStoreStrategy;

    public DocumentProcessorMonitor(DocumentStoreStrategy documentStoreStrategy) {
        this.documentStoreStrategy = documentStoreStrategy;
    }

    @Override
    public void onProcessed(Document document) throws IOException {
        String docId = document.getId();
        String name = document.getName();
        File documentFile = this.documentStoreStrategy.getDocumentFile(docId, name);
        File thumbnailFile = this.documentStoreStrategy.getThumbnailFile(docId);
        document.setSize(documentFile.length());
        document.setThumbnailUri(thumbnailFile.getPath());
    }
}

