/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.PageEntity;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageStoreStrategy", "Lio/scanbot/sdk/persistence/PageStoreStrategy;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageStoreStrategy;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/entity/PageEntity;", "processJpeg", "page", "sdk-docprocessing_release"})
public final class JpegComposer
implements Composer {
    private final Logger logger;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;

    @Override
    public void composeDocument(@NotNull Document document, @NotNull List<PageEntity> pages) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        boolean bl = pages.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Composer can only take 1 page";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.processJpeg(document, pages.get(0));
    }

    private final void processJpeg(Document document, PageEntity page) throws IOException {
        File file = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.OPTIMIZED);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pageStoreStrategy.getIma\u2026tity.ImageType.OPTIMIZED)");
        File optimized = file;
        File image = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
        FileUtils.copyFile((File)optimized, (File)image);
        int rotation = page.rotationType.getDegrees();
        if (rotation != 0 && rotation != 360) {
            try {
                File file2 = image;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"image");
                Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getPath());
                if (bitmap == null) {
                    throw (Throwable)new IOException("Can't decode file into bitmap or path doesn't exist");
                }
                Bitmap imageBitmap = bitmap;
                int width = imageBitmap.getWidth();
                int height = imageBitmap.getHeight();
                Matrix matrix = new Matrix();
                boolean bl = false;
                boolean bl2 = false;
                Matrix $this$apply = matrix;
                boolean bl3 = false;
                $this$apply.setRotate((float)rotation, (float)width / (float)2, (float)height / (float)2);
                Matrix matrix2 = matrix;
                Bitmap rotated = Bitmap.createBitmap((Bitmap)imageBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix2, (boolean)true);
                imageBitmap.recycle();
                Bitmap bitmap2 = rotated;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"rotated");
                BitmapUtils.compress((Bitmap)bitmap2, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90, (File)image);
                rotated.recycle();
            }
            catch (OutOfMemoryError e) {
                this.logger.logException((Throwable)e);
            }
            catch (IOException e) {
                this.logger.logException((Throwable)e);
            }
        }
    }

    public JpegComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageStoreStrategy pageStoreStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)pageStoreStrategy, (String)"pageStoreStrategy");
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.logger = LoggerProvider.getLogger();
    }
}

