/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.DocumentProcessor;
import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.docprocessing.R;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.PageEntity;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.util.bitmap.BitmapLruCache;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/docprocessing/DefaultDocumentProcessor;", "Lio/scanbot/sdk/docprocessing/DocumentProcessor;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "bitmapLruCache", "Lio/scanbot/sdk/util/bitmap/BitmapLruCache;", "composerFactory", "Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;", "documentProcessorMonitor", "Lio/scanbot/sdk/docprocessing/ProcessorMonitor;", "Lio/scanbot/sdk/entity/Document;", "cleaner", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "resources", "Landroid/content/res/Resources;", "pageStoreStrategy", "Lio/scanbot/sdk/persistence/PageStoreStrategy;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/util/bitmap/BitmapLruCache;Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;Lio/scanbot/sdk/docprocessing/ProcessorMonitor;Lio/scanbot/sdk/persistence/cleanup/Cleaner;Landroid/content/res/Resources;Lio/scanbot/sdk/persistence/PageStoreStrategy;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "thumbnailGenerator", "Lio/scanbot/sdk/docprocessing/DefaultDocumentProcessor$ThumbnailGenerator;", "performProcessing", "", "document", "pages", "", "Lio/scanbot/sdk/entity/PageEntity;", "processDocument", "Lio/scanbot/sdk/docprocessing/DocumentProcessingResult;", "documentDraft", "Lio/scanbot/sdk/entity/DocumentDraft;", "ThumbnailGenerator", "sdk-docprocessing_release"})
public final class DefaultDocumentProcessor
implements DocumentProcessor {
    private final ThumbnailGenerator thumbnailGenerator;
    private final Logger logger;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final BitmapLruCache bitmapLruCache;
    private final ComposerFactory composerFactory;
    private final ProcessorMonitor<Document> documentProcessorMonitor;
    private final Cleaner cleaner;

    @Override
    @Nullable
    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)documentDraft, (String)"documentDraft");
        Document document = documentDraft.getDocument();
        List pages = documentDraft.getPages();
        this.performProcessing(document, pages);
        this.documentProcessorMonitor.onProcessed(document);
        this.bitmapLruCache.evictAll();
        this.cleaner.cleanUpPages(pages);
        File file = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"documentStoreStrategy.ge\u2026cument.id, document.name)");
        return new DocumentProcessingResult(document, pages, file);
    }

    /*
     * WARNING - void declaration
     */
    private final void performProcessing(Document document, List<PageEntity> pages) throws IOException {
        this.documentStoreStrategy.ensureDocumentDirectory(document.id);
        if (document.size < 0L) {
            int n = 0;
            int n2 = ((Collection)pages).size();
            while (n < n2) {
                void i;
                PageEntity page = pages.get((int)i);
                if (i == false) {
                    this.thumbnailGenerator.generateThumbnail(document, page);
                }
                ++i;
            }
        }
        Composer composer = this.composerFactory.composerForDocument(document);
        this.logger.d("Processing", '(' + document.name + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document, pages);
    }

    public DefaultDocumentProcessor(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BitmapLruCache bitmapLruCache, @NotNull ComposerFactory composerFactory, @NotNull ProcessorMonitor<Document> documentProcessorMonitor, @NotNull Cleaner cleaner, @NotNull Resources resources, @NotNull PageStoreStrategy pageStoreStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)bitmapLruCache, (String)"bitmapLruCache");
        Intrinsics.checkParameterIsNotNull((Object)composerFactory, (String)"composerFactory");
        Intrinsics.checkParameterIsNotNull(documentProcessorMonitor, (String)"documentProcessorMonitor");
        Intrinsics.checkParameterIsNotNull((Object)cleaner, (String)"cleaner");
        Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)pageStoreStrategy, (String)"pageStoreStrategy");
        this.documentStoreStrategy = documentStoreStrategy;
        this.bitmapLruCache = bitmapLruCache;
        this.composerFactory = composerFactory;
        this.documentProcessorMonitor = documentProcessorMonitor;
        this.cleaner = cleaner;
        this.thumbnailGenerator = new ThumbnailGenerator(resources, this.documentStoreStrategy, pageStoreStrategy);
        this.logger = LoggerProvider.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/docprocessing/DefaultDocumentProcessor$ThumbnailGenerator;", "", "resources", "Landroid/content/res/Resources;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageStoreStrategy", "Lio/scanbot/sdk/persistence/PageStoreStrategy;", "(Landroid/content/res/Resources;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageStoreStrategy;)V", "generateThumbnail", "", "document", "Lio/scanbot/sdk/entity/Document;", "page", "Lio/scanbot/sdk/entity/PageEntity;", "saveRotatedAndScaledBitmap", "rotation", "", "maxDimension", "original", "Landroid/graphics/Bitmap;", "file", "Ljava/io/File;", "sdk-docprocessing_release"})
    private static final class ThumbnailGenerator {
        private final Resources resources;
        private final DocumentStoreStrategy documentStoreStrategy;
        private final PageStoreStrategy pageStoreStrategy;

        public final void generateThumbnail(@NotNull Document document, @NotNull PageEntity page) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
            int thumbnailSize = (int)this.resources.getDimension(R.dimen.document_thumbnail_size);
            BitmapFactory.Options options = new BitmapFactory.Options();
            boolean bl = false;
            int n = 0;
            BitmapFactory.Options $this$apply22 = options;
            int $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22 = 0;
            $this$apply22.inJustDecodeBounds = true;
            BitmapFactory.Options options2 = options;
            File file = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.OPTIMIZED);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pageStoreStrategy.getIma\u2026tity.ImageType.OPTIMIZED)");
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pageStoreStrategy.getIma\u2026ImageType.OPTIMIZED).path");
            String imageFilePath = string;
            BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options2);
            n = options2.outHeight;
            int $this$apply22 = options2.outWidth;
            $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22 = 0;
            int maxSize = Math.max(n, $this$apply22);
            $this$apply22 = maxSize / thumbnailSize;
            $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22 = 1;
            boolean bl2 = false;
            int scaleFactor = Math.max($this$apply22, $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22);
            BitmapFactory.Options $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22 = new BitmapFactory.Options();
            bl2 = false;
            boolean bl3 = false;
            BitmapFactory.Options $this$apply = $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22;
            boolean bl4 = false;
            $this$apply.inSampleSize = scaleFactor;
            BitmapFactory.Options downscaledOptions = $i$a$-apply-DefaultDocumentProcessor$ThumbnailGenerator$generateThumbnail$options$22;
            Bitmap optimized = BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)downscaledOptions);
            if (BitmapUtils.isBitmapValid((Bitmap)optimized)) {
                int n2 = page.rotationType.getDegrees();
                Bitmap bitmap = optimized;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"optimized");
                File file2 = this.documentStoreStrategy.getThumbnailFile(document.id);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"documentStoreStrategy.ge\u2026humbnailFile(document.id)");
                this.saveRotatedAndScaledBitmap(n2, thumbnailSize, bitmap, file2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void saveRotatedAndScaledBitmap(int rotation, int maxDimension, Bitmap original, File file) throws FileNotFoundException {
            int n = original.getWidth();
            int n2 = original.getHeight();
            float f = maxDimension;
            boolean bl = false;
            int n3 = Math.max(n, n2);
            float scale = f / (float)n3;
            Matrix matrix = new Matrix();
            bl = false;
            boolean bl2 = false;
            Matrix $this$apply = matrix;
            boolean bl3 = false;
            $this$apply.preRotate((float)rotation, (float)original.getWidth() / (float)2, (float)original.getHeight() / (float)2);
            $this$apply.postScale(scale, scale);
            Matrix matrix2 = matrix;
            Bitmap thumbnail = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)original.getWidth(), (int)original.getHeight(), (Matrix)matrix2, (boolean)true);
            FileOutputStream stream = new FileOutputStream(file);
            try {
                thumbnail.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)stream);
            }
        }

        public ThumbnailGenerator(@NotNull Resources resources, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageStoreStrategy pageStoreStrategy) {
            Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
            Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
            Intrinsics.checkParameterIsNotNull((Object)pageStoreStrategy, (String)"pageStoreStrategy");
            this.resources = resources;
            this.documentStoreStrategy = documentStoreStrategy;
            this.pageStoreStrategy = pageStoreStrategy;
        }
    }
}

