/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "composerConfig", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "processJpeg", "page", "sdk-docprocessing_release"})
public final class JpegComposer
implements Composer {
    private final Logger logger;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageFileStorage pageFileStorage;

    @Override
    public void composeDocument(@NotNull Document document, @NotNull List<Page> pages, @NotNull ComposerConfig composerConfig) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)composerConfig, (String)"composerConfig");
        boolean bl = pages.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Composer can only take 1 page";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.processJpeg(document, pages.get(0));
    }

    private final void processJpeg(Document document, Page page) throws IOException {
        File documentFile = new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath());
        File originalFile = new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
        File optimized = documentFile.exists() ? documentFile : originalFile;
        File image = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
        FileUtils.copyFile((File)optimized, (File)image);
    }

    public JpegComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageFileStorage = pageFileStorage;
        this.logger = LoggerProvider.getLogger();
    }
}

