/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.JpegComposer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/docprocessing/compose/BaseComposerFactory;", "Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "jpegComposer", "Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "(Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/docprocessing/compose/JpegComposer;)V", "buildJpegOrDummyComposer", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "document", "Lio/scanbot/sdk/entity/Document;", "buildSimpleOrDummyComposer", "composerForDocument", "sdk-docprocessing_release"})
public final class BaseComposerFactory
implements ComposerFactory {
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    @Override
    @NotNull
    public Composer composerForDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (StringsKt.endsWith$default((String)document.name, (String)".jpg", (boolean)false, (int)2, null)) {
            return this.buildJpegOrDummyComposer(document);
        }
        return this.buildSimpleOrDummyComposer(document);
    }

    private final Composer buildSimpleOrDummyComposer(Document document) {
        if (document.size > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.simpleComposer;
    }

    private final Composer buildJpegOrDummyComposer(Document document) {
        if (document.size > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.jpegComposer;
    }

    public BaseComposerFactory(@NotNull SimpleComposer simpleComposer, @NotNull JpegComposer jpegComposer) {
        Intrinsics.checkNotNullParameter((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)jpegComposer, (String)"jpegComposer");
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }
}

