/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.generictext;

import android.graphics.Rect;
import io.scanbot.generictext.NativeGenericTextRecognizer;
import io.scanbot.generictext.NativeGenericTextRecognizerConfig;
import io.scanbot.generictext.NativeGenericTextValidationCallback;
import io.scanbot.generictext.NativeTextRecognitionResult;
import io.scanbot.generictext.NativeTextWordBox;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.generictext.DefaultGenericTextRecognizer;
import io.scanbot.sdk.generictext.GenericTextRecognitionResult;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.generictext.GenericTextWordBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u001c\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u001b2\b\u0010,\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010-\u001a\u00020*H\u0002R0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\n\"\u0004\b\u001f\u0010\f\u00a8\u0006."}, d2={"Lio/scanbot/sdk/generictext/DefaultGenericTextRecognizer;", "Lio/scanbot/sdk/generictext/GenericTextRecognizer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "value", "", "", "allowedSymbols", "getAllowedSymbols", "()Ljava/util/Set;", "setAllowedSymbols", "(Ljava/util/Set;)V", "callbackValidator", "Lio/scanbot/sdk/generictext/GenericTextRecognizer$GenericTextValidationCallback;", "", "maximumNumberOfAccumulatedFrames", "getMaximumNumberOfAccumulatedFrames", "()I", "setMaximumNumberOfAccumulatedFrames", "(I)V", "minimumNumberOfRequiredFramesWithEqualRecognitionResult", "getMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "setMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "nativeGenericTextRecognizer", "Lio/scanbot/generictext/NativeGenericTextRecognizer;", "simpleValidator", "", "Lio/scanbot/sdk/entity/Language;", "supportedLanguages", "getSupportedLanguages", "setSupportedLanguages", "scanNv21", "Lio/scanbot/sdk/generictext/GenericTextRecognitionResult;", "nv21", "", "width", "height", "orientation", "finderRect", "Landroid/graphics/Rect;", "setValidator", "", "validator", "callback", "updateConfig", "sdk-generictext_release"})
public final class DefaultGenericTextRecognizer
implements GenericTextRecognizer {
    private NativeGenericTextRecognizer nativeGenericTextRecognizer;
    private int minimumNumberOfRequiredFramesWithEqualRecognitionResult;
    private int maximumNumberOfAccumulatedFrames;
    @NotNull
    private Set<? extends Language> supportedLanguages;
    @NotNull
    private Set<Character> allowedSymbols;
    private String simpleValidator;
    private GenericTextRecognizer.GenericTextValidationCallback callbackValidator;

    @Override
    public int getMinimumNumberOfRequiredFramesWithEqualRecognitionResult() {
        return this.minimumNumberOfRequiredFramesWithEqualRecognitionResult;
    }

    @Override
    public void setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(int value) {
        this.minimumNumberOfRequiredFramesWithEqualRecognitionResult = value;
        this.updateConfig();
    }

    @Override
    public int getMaximumNumberOfAccumulatedFrames() {
        return this.maximumNumberOfAccumulatedFrames;
    }

    @Override
    public void setMaximumNumberOfAccumulatedFrames(int value) {
        this.maximumNumberOfAccumulatedFrames = value;
        this.updateConfig();
    }

    @Override
    @NotNull
    public Set<Language> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @Override
    public void setSupportedLanguages(@NotNull Set<? extends Language> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.supportedLanguages = value;
        this.updateConfig();
    }

    @Override
    @NotNull
    public Set<Character> getAllowedSymbols() {
        return this.allowedSymbols;
    }

    @Override
    public void setAllowedSymbols(@NotNull Set<Character> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.allowedSymbols = value;
        this.updateConfig();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public GenericTextRecognitionResult scanNv21(@NotNull byte[] nv21, int width, int height, int orientation, @Nullable Rect finderRect) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        NativeTextRecognitionResult result = this.nativeGenericTextRecognizer.scanNv21(nv21, width, height, orientation, finderRect);
        Rect rect = finderRect;
        if (rect == null) {
            rect = new Rect(0, 0, width, height);
        }
        Rect finder = rect;
        NativeTextRecognitionResult nativeTextRecognitionResult = result;
        if (nativeTextRecognitionResult != null) {
            Collection<GenericTextWordBox> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            NativeTextRecognitionResult nativeTextRecognitionResult2 = nativeTextRecognitionResult;
            boolean bl = false;
            boolean bl2 = false;
            NativeTextRecognitionResult it = nativeTextRecognitionResult2;
            boolean bl3 = false;
            Iterable iterable = result.getListOfWords();
            double d = result.getConfidenceValue();
            String string = result.getRawString();
            boolean $i$f$map = false;
            void var20_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                NativeTextWordBox nativeTextWordBox = (NativeTextWordBox)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                Rect rawRect = it2.getRect();
                Rect resultRect = new Rect(rawRect.left + finder.left, rawRect.top + finder.top, rawRect.right + finder.left, rawRect.bottom + finder.top);
                GenericTextWordBox genericTextWordBox = new GenericTextWordBox(it2.getText(), it2.getConfidenceValue(), resultRect);
                collection.add(genericTextWordBox);
            }
            collection = (List)destination$iv$iv;
            boolean bl5 = result.getValidationSuccessful();
            List list = collection;
            double d2 = d;
            String string2 = string;
            return new GenericTextRecognitionResult(string2, d2, list, bl5);
        }
        return null;
    }

    @Override
    public void setValidator(@Nullable String validator, @Nullable GenericTextRecognizer.GenericTextValidationCallback callback) {
        this.simpleValidator = validator;
        this.callbackValidator = callback;
        this.updateConfig();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConfig() {
        NativeGenericTextValidationCallback nativeGenericTextValidationCallback;
        GenericTextRecognizer.GenericTextValidationCallback genericTextValidationCallback;
        int n = this.getMinimumNumberOfRequiredFramesWithEqualRecognitionResult();
        int n2 = this.getMaximumNumberOfAccumulatedFrames();
        String string = CollectionsKt.joinToString$default((Iterable)this.getAllowedSymbols(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String string2 = this.simpleValidator;
        String string3 = CollectionsKt.joinToString$default((Iterable)this.getSupportedLanguages(), (CharSequence)"+", null, null, (int)0, null, (Function1)updateConfig.config.1.INSTANCE, (int)30, null);
        GenericTextRecognizer.GenericTextValidationCallback genericTextValidationCallback2 = this.callbackValidator;
        if (genericTextValidationCallback2 != null) {
            void it;
            genericTextValidationCallback = genericTextValidationCallback2;
            boolean bl = false;
            boolean bl2 = false;
            GenericTextRecognizer.GenericTextValidationCallback genericTextValidationCallback3 = genericTextValidationCallback;
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            int n3 = n2;
            int n4 = n;
            boolean bl3 = false;
            NativeGenericTextValidationCallback nativeGenericTextValidationCallback2 = new NativeGenericTextValidationCallback((GenericTextRecognizer.GenericTextValidationCallback)it){
                final /* synthetic */ GenericTextRecognizer.GenericTextValidationCallback $it;

                public final boolean validate(@NotNull String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                    return this.$it.validate(string);
                }
                {
                    this.$it = genericTextValidationCallback;
                }
            };
            n = n4;
            n2 = n3;
            string = string6;
            string2 = string5;
            string3 = string4;
            nativeGenericTextValidationCallback = nativeGenericTextValidationCallback2;
        } else {
            nativeGenericTextValidationCallback = null;
        }
        genericTextValidationCallback = nativeGenericTextValidationCallback;
        String string7 = string3;
        String string8 = string2;
        GenericTextRecognizer.GenericTextValidationCallback genericTextValidationCallback4 = genericTextValidationCallback;
        String string9 = string8;
        String string10 = string7;
        String string11 = string;
        int n5 = n2;
        int n6 = n;
        NativeGenericTextRecognizerConfig config2 = new NativeGenericTextRecognizerConfig(n6, n5, string11, string10, string9, (NativeGenericTextValidationCallback)genericTextValidationCallback4);
        this.nativeGenericTextRecognizer.setConfiguration(config2);
    }

    public DefaultGenericTextRecognizer(@NotNull BlobManager blobManager) {
        String tessDataPath;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        this.minimumNumberOfRequiredFramesWithEqualRecognitionResult = 2;
        this.maximumNumberOfAccumulatedFrames = 4;
        this.supportedLanguages = SetsKt.setOf((Object)Language.ENG);
        boolean bl = false;
        this.allowedSymbols = SetsKt.emptySet();
        try {
            String string3 = blobManager.getGenericTextRecognizerModelsFolderFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"blobManager.genericTextR\u2026izerModelsFolderFile.path");
            string2 = string3;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Generic text recognizer trained data is not available.");
        }
        String modelsFolderPath = string2;
        try {
            string = blobManager.getOcrBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("OCR trained data is not available.");
        }
        String string4 = tessDataPath = string;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tessDataPath");
        this.nativeGenericTextRecognizer = new NativeGenericTextRecognizer(modelsFolderPath, string4);
    }
}

