/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.generictext.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.generic_text.R;
import io.scanbot.sdk.generictext.GenericTextWordBox;
import io.scanbot.sdk.ui.BasePolygonView;
import io.scanbot.sdk.ui.camera.UiZoomDelegate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 42\u00020\u00012\u00020\u00022\u00020\u0003:\u00014B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\u000e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u000fJ\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u000bH\u0016J(\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0002J\u0014\u00102\u001a\u00020$2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/scanbot/sdk/generictext/ui/WordboxPreviewView;", "Landroid/view/View;", "Lio/scanbot/sdk/ui/BasePolygonView;", "Lio/scanbot/sdk/ui/camera/UiZoomDelegate;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cornerRadius", "", "drawRect", "Landroid/graphics/RectF;", "frameHeight", "", "getFrameHeight", "()I", "setFrameHeight", "(I)V", "frameOrientation", "getFrameOrientation", "setFrameOrientation", "frameWidth", "getFrameWidth", "setFrameWidth", "resultRectF", "strokePaint", "Landroid/graphics/Paint;", "wordboxes", "", "Lio/scanbot/sdk/generictext/GenericTextWordBox;", "calculateAlpha", "confidence", "", "initView", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setColor", "strokeColor", "setUiZoomLevel", "zoomLevel", "toRelativeRectF", "resultRect", "Landroid/graphics/Rect;", "width", "height", "orientation", "updateCharacters", "list", "Companion", "sdk-generictext_release"})
public final class WordboxPreviewView
extends View
implements BasePolygonView,
UiZoomDelegate {
    private List<GenericTextWordBox> wordboxes;
    private Paint strokePaint;
    private final RectF drawRect;
    private final RectF resultRectF;
    private float cornerRadius;
    private int frameWidth;
    private int frameHeight;
    private int frameOrientation;
    private static final int CONFIDENCE_MAX_ALPHA = 50;
    private static final int CONFIDENCE_DIVIDER = 10000;
    private static final List<Integer> PORTRAIT_ORIENTATION;
    public static final Companion Companion;

    public final int getFrameWidth() {
        return this.frameWidth;
    }

    public final void setFrameWidth(int n) {
        this.frameWidth = n;
    }

    public final int getFrameHeight() {
        return this.frameHeight;
    }

    public final void setFrameHeight(int n) {
        this.frameHeight = n;
    }

    public final int getFrameOrientation() {
        return this.frameOrientation;
    }

    public final void setFrameOrientation(int n) {
        this.frameOrientation = n;
    }

    private final void initView() {
        this.cornerRadius = this.getResources().getDimension(R.dimen.wordbox_rounded_corner_radius);
        this.strokePaint.setColor(-16711681);
        this.strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.strokePaint.setAntiAlias(true);
    }

    public final void setColor(int strokeColor) {
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
    }

    public final void updateCharacters(@NotNull List<GenericTextWordBox> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.wordboxes = list;
        this.invalidate();
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas it = canvas3;
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.wordboxes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GenericTextWordBox it2 = (GenericTextWordBox)element$iv;
                boolean bl4 = false;
                Rect rect = it2.getBoundingRect();
                RectF rectF = this.toRelativeRectF(rect, this.frameWidth, this.frameHeight, this.frameOrientation);
                this.strokePaint.setAlpha(this.calculateAlpha(it2.getConfidenceValue()));
                this.drawRect.left = rectF.left * (float)this.getWidth();
                this.drawRect.top = rectF.top * (float)this.getHeight();
                this.drawRect.right = rectF.right * (float)this.getWidth();
                this.drawRect.bottom = rectF.bottom * (float)this.getHeight();
                canvas.drawRoundRect(this.drawRect, this.cornerRadius, this.cornerRadius, this.strokePaint);
            }
        }
    }

    private final int calculateAlpha(double confidence) {
        return (int)(confidence * confidence / (double)10000 * (double)50);
    }

    private final RectF toRelativeRectF(Rect resultRect, int width, int height, int orientation) {
        int corWidth = PORTRAIT_ORIENTATION.contains(orientation) ? width : height;
        int corHeight = PORTRAIT_ORIENTATION.contains(orientation) ? height : width;
        this.resultRectF.left = (float)resultRect.left / (float)corWidth;
        this.resultRectF.top = (float)resultRect.top / (float)corHeight;
        this.resultRectF.right = (float)resultRect.right / (float)corWidth;
        this.resultRectF.bottom = (float)resultRect.bottom / (float)corHeight;
        return this.resultRectF;
    }

    public void setUiZoomLevel(float zoomLevel) {
        this.setScaleX(zoomLevel);
        this.setScaleY(zoomLevel);
    }

    public WordboxPreviewView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.wordboxes = CollectionsKt.emptyList();
        this.strokePaint = (Paint)new TextPaint();
        this.drawRect = new RectF();
        this.resultRectF = new RectF();
        this.initView();
    }

    public WordboxPreviewView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.wordboxes = CollectionsKt.emptyList();
        this.strokePaint = (Paint)new TextPaint();
        this.drawRect = new RectF();
        this.resultRectF = new RectF();
        this.initView();
    }

    static {
        Companion = new Companion(null);
        PORTRAIT_ORIENTATION = CollectionsKt.listOf((Object[])new Integer[]{0, 180});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/generictext/ui/WordboxPreviewView$Companion;", "", "()V", "CONFIDENCE_DIVIDER", "", "CONFIDENCE_MAX_ALPHA", "PORTRAIT_ORIENTATION", "", "sdk-generictext_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

