/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.ui.camera.BaseFinderOverlayView;
import io.scanbot.sdk.utils.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002JD\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eH\u0004J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u0014\u0010\u001f\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Lio/scanbot/sdk/ui/camera/BaseFinderOverlayView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "contourDetectorFrameHandler", "Lnet/doo/snap/camera/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lnet/doo/snap/camera/ContourDetectorFrameHandler$ResultHandler;", "finderAnimation", "Landroid/animation/AnimatorSet;", "requiredPageAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "animatePaddingChanges", "", "paddingLeftRight", "", "paddingTopBottom", "handleDetectionResult", "requiredAspectRatios", "detectionResult", "Lnet/doo/snap/lib/detector/DetectionResult;", "frameWidth", "frameHeight", "frameOrientation", "polygon", "Landroid/graphics/PointF;", "setInitialFinderViewSize", "setRequiredAspectRatios", "sdk-imageprocessing_release"})
public class FinderOverlayView
extends BaseFinderOverlayView {
    private AnimatorSet finderAnimation = new AnimatorSet();
    private List<? extends PageAspectRatio> requiredPageAspectRatios;
    @NotNull
    private final ContourDetectorFrameHandler.ResultHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler.ResultHandler(this){
        final /* synthetic */ FinderOverlayView this$0;

        public final boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> result) {
            block0: {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> frameHandlerResult = result;
                if (!(frameHandlerResult instanceof FrameHandlerResult.Success)) break block0;
                Object object = ((FrameHandlerResult.Success)result).getValue();
                boolean bl = false;
                boolean bl2 = false;
                ContourDetectorFrameHandler.DetectedFrame it = (ContourDetectorFrameHandler.DetectedFrame)object;
                boolean bl3 = false;
                List<PageAspectRatio> list = it.requiredPageAspectRatios;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.requiredPageAspectRatios");
                DetectionResult detectionResult = it.detectionResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult, (String)"it.detectionResult");
                int n = it.frameWidth;
                int n2 = it.frameHeight;
                int n3 = it.frameOrientation;
                List<PointF> list2 = it.polygon;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.polygon");
                this.this$0.handleDetectionResult(list, detectionResult, n, n2, n3, list2);
            }
            return false;
        }
        {
            this.this$0 = finderOverlayView;
        }
    };

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.contourDetectorFrameHandler;
    }

    public final void setRequiredAspectRatios(@NotNull List<? extends PageAspectRatio> requiredAspectRatios) {
        Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
        this.requiredPageAspectRatios = requiredAspectRatios;
        this.post(new Runnable(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void run() {
                this.this$0.setInitialFinderViewSize();
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
    }

    public void setInitialFinderViewSize() {
        int paddingTopBottom = 0;
        int paddingLeftRight = 0;
        int scaledFrameWidth = 0;
        int scaledFrameHeight = 0;
        if (this.getFixedFinderWidthInPx() <= 0 || this.getFixedFinderHeightInPx() <= 0) {
            double finderAspectRatio;
            if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
                double frameAspectRatio = this.getInitialPreviewWidth() == 0 || this.getInitialPreviewHeight() == 0 ? (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() : (double)this.getInitialPreviewWidth() / (double)this.getInitialPreviewHeight();
                double cameraViewAspectRatio = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                scaledFrameWidth = cameraViewAspectRatio < frameAspectRatio ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * frameAspectRatio);
                scaledFrameHeight = cameraViewAspectRatio < frameAspectRatio ? (int)((double)this.getMeasuredWidth() / frameAspectRatio) : this.getMeasuredHeight();
            } else {
                scaledFrameWidth = this.getMeasuredWidth();
                scaledFrameHeight = this.getMeasuredHeight();
            }
            int finderWidth = scaledFrameWidth - 2 * this.getMinFinderPadding();
            int finderHeight = scaledFrameHeight - 2 * this.getMinFinderPadding();
            double targetAspectRatio = finderAspectRatio = (double)finderWidth / (double)finderHeight;
            if (this.requiredPageAspectRatios != null) {
                List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty()) {
                    List<? extends PageAspectRatio> list2 = this.requiredPageAspectRatios;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PageAspectRatio requiredAspectRatio = list2.get(0);
                    targetAspectRatio = requiredAspectRatio.width / requiredAspectRatio.height;
                }
            }
            if (targetAspectRatio < finderAspectRatio) {
                double targetWidth = (double)finderHeight * targetAspectRatio;
                paddingTopBottom = this.getMinFinderPadding() + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight = (int)(((double)scaledFrameWidth - targetWidth) / (double)2) + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            } else {
                double targetHeight = (double)finderWidth / targetAspectRatio;
                paddingTopBottom = (int)(((double)scaledFrameHeight - targetHeight) / (double)2) + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight = this.getMinFinderPadding() + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            }
        } else {
            paddingTopBottom = (this.getMeasuredHeight() - this.getFixedFinderHeightInPx()) / 2;
            paddingLeftRight = (this.getMeasuredWidth() - this.getFixedFinderWidthInPx()) / 2;
        }
        this.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        this.adjustDescriptionPosition(paddingTopBottom);
        this.invalidate();
    }

    protected final void handleDetectionResult(@NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull DetectionResult detectionResult, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        block21: {
            block20: {
                Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
                Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
                Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
                if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
                    return;
                }
                if (!requiredAspectRatios.isEmpty()) {
                    this.requiredPageAspectRatios = requiredAspectRatios;
                }
                if (this.requiredPageAspectRatios == null) break block20;
                List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty() && !this.finderAnimation.isRunning()) break block21;
            }
            return;
        }
        if (polygon.size() > 0 && (detectionResult == DetectionResult.OK || detectionResult == DetectionResult.OK_BUT_BAD_ANGLES || detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO || detectionResult == DetectionResult.OK_BUT_TOO_SMALL || detectionResult == DetectionResult.OK_OFF_CENTER)) {
            double d;
            PageAspectRatio targetPageSize;
            PageAspectRatio pageAspectRatio;
            Iterator iterator$iv;
            int scaledFrameWidth = 0;
            int scaledFrameHeight = 0;
            if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
                int rotatedFrameWidth = frameOrientation % 180 == 0 ? frameWidth : frameHeight;
                int rotatedFrameHeight = frameOrientation % 180 == 0 ? frameHeight : frameWidth;
                double frameAspectRatio = (double)rotatedFrameWidth / (double)rotatedFrameHeight;
                double cameraViewAspectRatio = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                scaledFrameWidth = cameraViewAspectRatio < frameAspectRatio ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * frameAspectRatio);
                scaledFrameHeight = cameraViewAspectRatio < frameAspectRatio ? (int)((double)this.getMeasuredWidth() / frameAspectRatio) : this.getMeasuredHeight();
            } else {
                scaledFrameWidth = this.getMeasuredWidth();
                scaledFrameHeight = this.getMeasuredHeight();
            }
            int finderWidth = scaledFrameWidth - 2 * this.getMinFinderPadding();
            int finderHeight = scaledFrameHeight - 2 * this.getMinFinderPadding();
            double finderAspectRatio = (double)finderWidth / (double)finderHeight;
            float approximatePolygonAspectRatio = PolygonHelper.Companion.approximatePolygonAspectRatio(polygon, frameWidth, frameHeight, frameOrientation);
            List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
            if (list != null) {
                Object v2;
                Iterable $this$minBy$iv = list;
                boolean $i$f$minBy = false;
                iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = minElem$iv;
                    } else {
                        PageAspectRatio it = (PageAspectRatio)minElem$iv;
                        boolean bl = false;
                        double d2 = (double)approximatePolygonAspectRatio - it.width / it.height;
                        boolean bl2 = false;
                        double minValue$iv = Math.abs(d2);
                        do {
                            Object e$iv = iterator$iv.next();
                            PageAspectRatio it2 = (PageAspectRatio)e$iv;
                            $i$a$-minBy-FinderOverlayView$handleDetectionResult$targetPageSize$1 = false;
                            double d3 = (double)approximatePolygonAspectRatio - it2.width / it2.height;
                            boolean bl3 = false;
                            double v$iv = Math.abs(d3);
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = minElem$iv;
                    }
                }
                pageAspectRatio = v2;
            } else {
                pageAspectRatio = null;
            }
            PageAspectRatio pageAspectRatio2 = targetPageSize = pageAspectRatio;
            if (pageAspectRatio2 != null) {
                iterator$iv = pageAspectRatio2;
                boolean minElem$iv = false;
                boolean minValue$iv = false;
                Iterator it = iterator$iv;
                boolean bl = false;
                d = ((PageAspectRatio)it).width / ((PageAspectRatio)it).height;
            } else {
                d = finderAspectRatio;
            }
            double targetAspectRatio = d;
            Ref.IntRef paddingTopBottom = new Ref.IntRef();
            Ref.IntRef paddingLeftRight = new Ref.IntRef();
            if (targetAspectRatio < finderAspectRatio) {
                double targetWidth = (double)finderHeight * targetAspectRatio;
                paddingTopBottom.element = this.getMinFinderPadding() + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight.element = (int)(((double)scaledFrameWidth - targetWidth) / (double)2) + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            } else {
                double targetHeight = (double)finderWidth / targetAspectRatio;
                paddingTopBottom.element = (int)(((double)scaledFrameHeight - targetHeight) / (double)2) + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight.element = this.getMinFinderPadding() + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            }
            this.post(new Runnable(this, paddingLeftRight, paddingTopBottom){
                final /* synthetic */ FinderOverlayView this$0;
                final /* synthetic */ Ref.IntRef $paddingLeftRight;
                final /* synthetic */ Ref.IntRef $paddingTopBottom;

                public final void run() {
                    FinderOverlayView.access$animatePaddingChanges(this.this$0, this.$paddingLeftRight.element, this.$paddingTopBottom.element);
                }
                {
                    this.this$0 = finderOverlayView;
                    this.$paddingLeftRight = intRef;
                    this.$paddingTopBottom = intRef2;
                }
            });
        }
    }

    private final void animatePaddingChanges(int paddingLeftRight, int paddingTopBottom) {
        if (this.getPaddingRight() == paddingLeftRight && this.getPaddingLeft() == paddingLeftRight && this.getPaddingTop() == paddingTopBottom && this.getPaddingBottom() == paddingTopBottom) {
            return;
        }
        ValueAnimator animatorPaddingRight = ValueAnimator.ofInt((int[])new int[]{this.getPaddingRight(), paddingLeftRight});
        animatorPaddingRight.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = this.this$0.getPaddingLeft();
                int n2 = this.this$0.getPaddingTop();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding(n, n2, (Integer)object, this.this$0.getPaddingBottom());
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
        ValueAnimator animatorPaddingLeft = ValueAnimator.ofInt((int[])new int[]{this.getPaddingLeft(), paddingLeftRight});
        animatorPaddingLeft.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding((Integer)object, this.this$0.getPaddingTop(), this.this$0.getPaddingRight(), this.this$0.getPaddingBottom());
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
        ValueAnimator animatorPaddingTop = ValueAnimator.ofInt((int[])new int[]{this.getPaddingTop(), paddingTopBottom});
        animatorPaddingTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = this.this$0.getPaddingLeft();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding(n, (Integer)object, this.this$0.getPaddingRight(), this.this$0.getPaddingBottom());
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
        ValueAnimator animatorPaddingBottom = ValueAnimator.ofInt((int[])new int[]{this.getPaddingBottom(), paddingTopBottom});
        animatorPaddingBottom.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = this.this$0.getPaddingLeft();
                int n2 = this.this$0.getPaddingTop();
                int n3 = this.this$0.getPaddingRight();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.setPadding(n, n2, n3, (Integer)object);
                Object object2 = valueAnimator.getAnimatedValue();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.this$0.adjustDescriptionPosition((Integer)object2);
                this.this$0.invalidate();
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
        this.finderAnimation.end();
        this.finderAnimation.cancel();
        AnimatorSet animatorSet = this.finderAnimation = new AnimatorSet();
        boolean bl = false;
        boolean bl2 = false;
        AnimatorSet $this$apply = animatorSet;
        boolean bl3 = false;
        $this$apply.playTogether(new Animator[]{(Animator)animatorPaddingRight, (Animator)animatorPaddingLeft, (Animator)animatorPaddingTop, (Animator)animatorPaddingBottom});
        $this$apply.setDuration(200L);
        $this$apply.start();
    }

    public FinderOverlayView(@Nullable Context context, @Nullable AttributeSet attr) {
        super(context, attr);
    }

    public static final /* synthetic */ void access$animatePaddingChanges(FinderOverlayView $this, int paddingLeftRight, int paddingTopBottom) {
        $this.animatePaddingChanges(paddingLeftRight, paddingTopBottom);
    }
}

