/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.mrzscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.mrzscanner.MRZScanner;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "context", "Landroid/content/Context;", "mrzScanner", "Lio/scanbot/sdk/mrzscanner/MRZScanner;", "(Landroid/content/Context;Lio/scanbot/sdk/mrzscanner/MRZScanner;)V", "(Lio/scanbot/sdk/mrzscanner/MRZScanner;)V", "handlers", "", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$ResultHandler;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "sapManager", "Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "Companion", "MrzScannerResultHandler", "ResultHandler", "sdk-mrz_release"})
public final class MRZScannerFrameHandler
implements FrameHandler {
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private boolean isEnabled;
    private final MRZScanner mrzScanner;
    public static final Companion Companion = new Companion(null);

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        boolean bl;
        Rect recognitionResult;
        Rect it;
        boolean bl2;
        boolean bl3;
        Rect rect;
        Rect rect2;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
                this.logger.logMethod();
                if (!this.isEnabled) {
                    return false;
                }
                if (!this.sapManager.checkLicenseStatus(SdkFeature.MRZRecognition).booleanValue()) {
                    this.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError())));
                    return false;
                }
                rect2 = previewFrame.getFinderRect();
                if (rect2 == null) break block7;
                rect = rect2;
                bl3 = false;
                bl2 = false;
                it = rect;
                boolean bl4 = false;
                MRZRecognitionResult mRZRecognitionResult = this.mrzScanner.recognizeMRZWithFinderOverlay(previewFrame.getFrame(), previewFrame.getWidth(), previewFrame.getHeight(), previewFrame.getFrameOrientation(), it, false);
                rect2 = mRZRecognitionResult;
                if (mRZRecognitionResult != null) break block8;
            }
            rect2 = this.mrzScanner.recognizeMRZ(previewFrame.getFrame(), previewFrame.getWidth(), previewFrame.getHeight(), previewFrame.getFrameOrientation());
        }
        Rect rect3 = recognitionResult = rect2;
        if (rect3 != null) {
            rect = rect3;
            bl3 = false;
            bl2 = false;
            it = rect;
            boolean bl5 = false;
            bl = this.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)recognitionResult)));
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notifyHandlers(FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> result) {
        boolean handled = false;
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    public MRZScannerFrameHandler(@NotNull MRZScanner mrzScanner) {
        Intrinsics.checkParameterIsNotNull((Object)mrzScanner, (String)"mrzScanner");
        this.mrzScanner = mrzScanner;
        this.handlers = new LinkedHashSet();
        this.sapManager = SapSingleton.getInstance();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
    }

    @Deprecated(message="Context not needed anymore, use other constructor without it", replaceWith=@ReplaceWith(imports={}, expression="MRZScannerFrameHandler(mrzScanner)"))
    public MRZScannerFrameHandler(@NotNull Context context, @NotNull MRZScanner mrzScanner) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)mrzScanner, (String)"mrzScanner");
        this(mrzScanner);
    }

    @JvmStatic
    @NotNull
    public static final MRZScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull MRZScanner mrzScanner) {
        return Companion.attach(cameraView, mrzScanner);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-mrz_release"})
    public static interface ResultHandler
    extends BaseResultHandler<MRZRecognitionResult, SdkLicenseError> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$MrzScannerResultHandler;", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$ResultHandler;", "()V", "sdk-mrz_release"})
    public static abstract class MrzScannerResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "mrzScanner", "Lio/scanbot/sdk/mrzscanner/MRZScanner;", "sdk-mrz_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MRZScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull MRZScanner mrzScanner) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)mrzScanner, (String)"mrzScanner");
            MRZScannerFrameHandler frameHandler = new MRZScannerFrameHandler(mrzScanner);
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

