/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.multipleobjectsscanner.model.Polygon;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.multipleobjects.MultipleObjectsFrameHandler;
import io.scanbot.sdk.multipleobjects.R;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.util.snap.PolygonHelper;

public class MultiplePolygonsView
extends View {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    private List<float[]> listOfPoints = new ArrayList<float[]>();
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    public MultipleObjectsFrameHandler.ResultHandler multipleObjectDetectorHandler = new MultipleObjectsFrameHandler.ResultHandler(){

        public boolean handle(FrameHandlerResult<? extends MultipleObjectsFrameHandler.DetectedData, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                final MultipleObjectsFrameHandler.DetectedData detectedData = (MultipleObjectsFrameHandler.DetectedData)((FrameHandlerResult.Success)result).getValue();
                if (detectedData.getDetectedPolygons().isEmpty() && MultiplePolygonsView.this.listOfPoints.isEmpty()) {
                    return false;
                }
                if (MultiplePolygonsView.this.polygonUpdating.get()) {
                    return false;
                }
                MultiplePolygonsView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        MultiplePolygonsView.this.polygonUpdating.set(true);
                        MultiplePolygonsView.this.updatePolygon(detectedData.getDetectedPolygons());
                    }
                });
            }
            return false;
        }
    };
    private ObjectAnimator polygonAlphaAnimator;
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);

    public MultiplePolygonsView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public MultiplePolygonsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.strokePaint = new Paint();
        this.strokePaint.setColor(-1);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaint = new Paint();
        this.fillPaint.setColor(-16711936);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaintOK = new Paint();
        this.strokePaintOK.setColor(-1);
        this.strokePaintOK.setStyle(Paint.Style.STROKE);
        this.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        this.strokePaintOK.setAntiAlias(true);
        this.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaintOK = new Paint();
        this.fillPaintOK.setColor(-16711936);
        this.fillPaintOK.setStyle(Paint.Style.FILL);
        this.polygonHelper = new PolygonHelper();
        this.path = new Path();
        if (attrs != null) {
            this.loadAttributes(context, attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(Context context, AttributeSet attrs) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.PolygonView);
        try {
            int fillColor = attributes.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            this.useFill = fillColor != 0;
            this.fillPaint.setColor(fillColor);
            int strokeColor = attributes.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
            this.strokePaint.setColor(strokeColor);
            int fillColorOK = attributes.getColor(R.styleable.PolygonView_polygonFillColorOK, fillColor);
            this.useFillOK = fillColorOK != 0;
            this.fillPaintOK.setColor(fillColorOK);
            int strokeColorOK = attributes.getColor(R.styleable.PolygonView_polygonStrokeColorOK, strokeColor);
            this.strokePaintOK.setColor(strokeColorOK);
            float strokeWidth = attributes.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.strokePaint.setStrokeWidth(strokeWidth);
            this.strokePaintOK.setStrokeWidth(strokeWidth);
        }
        finally {
            attributes.recycle();
        }
    }

    public void setFillColor(int fillColor) {
        this.useFill = fillColor != 0;
        this.fillPaint.setColor(fillColor);
        this.invalidate();
    }

    public void setFillColorOK(int fillColorOK) {
        this.useFillOK = fillColorOK != 0;
        this.fillPaintOK.setColor(fillColorOK);
        this.invalidate();
    }

    public void setStrokeColor(int strokeColor) {
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
    }

    public void setStrokeColorOK(int strokeColorOK) {
        this.strokePaintOK.setColor(strokeColorOK);
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.strokePaintOK.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.polygonHelper.setLayout(0, 0, w, h);
    }

    protected void updatePolygon(List<Polygon> polygons) {
        if (polygons.isEmpty() && !this.listOfPoints.isEmpty()) {
            this.listOfPoints.clear();
            if (this.polygonAlphaAnimator != null) {
                this.polygonAlphaAnimator.cancel();
                this.polygonAlphaAnimator = null;
            }
            this.animatePolygonFadeOut();
        } else {
            this.strokePaint.setAlpha(255);
            this.listOfPoints.clear();
            for (Polygon polygon : polygons) {
                float[] points = new float[16];
                this.polygonHelper.polygonToLinePoints(polygon.getPolygonF(), points);
                this.listOfPoints.add(points);
                if (!this.useFill && !this.useFillOK) continue;
                this.updatePath();
            }
        }
        this.polygonUpdating.set(false);
        this.invalidate();
    }

    private void animatePolygonFadeOut() {
        this.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)this.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        this.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                MultiplePolygonsView.this.invalidate();
            }
        });
        this.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public void onAnimationEnd(Animator animation) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        this.polygonAlphaAnimator.setDuration(250L);
        this.polygonAlphaAnimator.start();
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean drawFill;
        super.dispatchDraw(canvas);
        Paint currentFillPaint = this.lastResult == DetectionResult.OK ? this.fillPaintOK : this.fillPaint;
        Paint currentStrokePaint = this.lastResult == DetectionResult.OK ? this.strokePaintOK : this.strokePaint;
        boolean bl = drawFill = this.lastResult == DetectionResult.OK ? this.useFillOK : this.useFill;
        if (!this.listOfPoints.isEmpty()) {
            if (drawFill) {
                canvas.drawPath(this.path, currentFillPaint);
            }
            for (float[] points : this.listOfPoints) {
                canvas.drawLines(points, currentStrokePaint);
            }
        }
    }

    private void updatePath() {
        this.path.rewind();
        for (float[] points : this.listOfPoints) {
            this.path.moveTo(points[0], points[1]);
            for (int i = 2; i < points.length; i += 2) {
                this.path.lineTo(points[i], points[i + 1]);
            }
        }
    }
}

