/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.multipleobjects;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.multipleobjectsscanner.model.Polygon;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.multipleobjects.MultipleObjectsFrameHandler;
import io.scanbot.sdk.multipleobjects.R;
import io.scanbot.sdk.ui.BasePolygonView;
import io.scanbot.sdk.util.view.PolygonHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiplePolygonsView
extends View
implements BasePolygonView {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    private List<float[]> listOfPoints = new ArrayList<float[]>();
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    public MultipleObjectsFrameHandler.ResultHandler multipleObjectDetectorHandler = new MultipleObjectsFrameHandler.ResultHandler(){

        public boolean handle(FrameHandlerResult<? extends MultipleObjectsFrameHandler.DetectedData, ? extends SdkLicenseError> object) {
            if (object instanceof FrameHandlerResult.Success) {
                if ((object = (MultipleObjectsFrameHandler.DetectedData)((FrameHandlerResult.Success)object).getValue()).getDetectedPolygons().isEmpty() && MultiplePolygonsView.this.listOfPoints.isEmpty()) {
                    return false;
                }
                if (MultiplePolygonsView.this.polygonUpdating.get()) {
                    return false;
                }
                MultiplePolygonsView.this.post(new Runnable((MultipleObjectsFrameHandler.DetectedData)object){
                    public final /* synthetic */ MultipleObjectsFrameHandler.DetectedData a;
                    {
                        this.a = detectedData;
                    }

                    @Override
                    public void run() {
                        a a2 = this;
                        a2.MultiplePolygonsView.this.polygonUpdating.set(true);
                        a2.MultiplePolygonsView.this.updatePolygon(this.a.getDetectedPolygons());
                    }
                });
            }
            return false;
        }
    };
    private ObjectAnimator polygonAlphaAnimator;
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    public AtomicBoolean polygonUpdating = new AtomicBoolean(false);

    public MultiplePolygonsView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public MultiplePolygonsView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context, attributeSet);
    }

    private void initView(Context context, AttributeSet attributeSet) {
        MultiplePolygonsView multiplePolygonsView = this;
        this.strokePaint = new Paint();
        this.strokePaint.setColor(-1);
        multiplePolygonsView.strokePaint.setStyle(Paint.Style.STROKE);
        multiplePolygonsView.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        multiplePolygonsView.strokePaint.setAntiAlias(true);
        multiplePolygonsView.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaint = new Paint();
        this.fillPaint.setColor(-16711936);
        multiplePolygonsView.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaintOK = new Paint();
        this.strokePaintOK.setColor(-1);
        multiplePolygonsView.strokePaintOK.setStyle(Paint.Style.STROKE);
        multiplePolygonsView.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        multiplePolygonsView.strokePaintOK.setAntiAlias(true);
        multiplePolygonsView.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaintOK = new Paint();
        this.fillPaintOK.setColor(-16711936);
        multiplePolygonsView.fillPaintOK.setStyle(Paint.Style.FILL);
        multiplePolygonsView.polygonHelper = new PolygonHelper();
        multiplePolygonsView.path = new Path();
        if (attributeSet != null) {
            this.loadAttributes(context, attributeSet);
        }
    }

    private void loadAttributes(Context context, AttributeSet attributeSet) {
        int n;
        int n2;
        context = context.obtainStyledAttributes(attributeSet, R.styleable.PolygonView);
        try {
            n2 = context.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            n = n2 != 0 ? 1 : 0;
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        Context context2 = context;
        MultiplePolygonsView multiplePolygonsView = this;
        this.useFill = n;
        this.fillPaint.setColor(n2);
        n = context.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
        multiplePolygonsView.strokePaint.setColor(n);
        n2 = context2.getColor(R.styleable.PolygonView_polygonFillColorOK, n2);
        boolean bl = n2 != 0;
        Context context3 = context;
        MultiplePolygonsView multiplePolygonsView2 = this;
        MultiplePolygonsView multiplePolygonsView3 = multiplePolygonsView2;
        MultiplePolygonsView multiplePolygonsView4 = multiplePolygonsView2;
        Context context4 = context;
        MultiplePolygonsView multiplePolygonsView5 = this;
        this.useFillOK = bl;
        this.fillPaintOK.setColor(n2);
        n2 = context.getColor(R.styleable.PolygonView_polygonStrokeColorOK, n);
        multiplePolygonsView5.strokePaintOK.setColor(n2);
        float f = context4.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        multiplePolygonsView3.strokePaint.setStrokeWidth(f);
        multiplePolygonsView4.strokePaintOK.setStrokeWidth(f);
        context3.recycle();
    }

    private void animatePolygonFadeOut() {
        MultiplePolygonsView multiplePolygonsView = this;
        this.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)multiplePolygonsView.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        this.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                MultiplePolygonsView.this.invalidate();
            }
        });
        multiplePolygonsView.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animator) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animator);
            }

            public void onAnimationEnd(Animator animator) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animator);
            }
        });
        multiplePolygonsView.polygonAlphaAnimator.setDuration(250L);
        multiplePolygonsView.polygonAlphaAnimator.start();
    }

    private void updatePath() {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.path.rewind();
        for (float[] fArray : multiplePolygonsView.listOfPoints) {
            float f = fArray[0];
            this.path.moveTo(f, fArray[1]);
            for (int i = 2; i < fArray.length; i += 2) {
                float f2 = fArray[i];
                this.path.lineTo(f2, fArray[i + 1]);
            }
        }
    }

    public void setFillColor(int n) {
        boolean bl = n != 0;
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.useFill = bl;
        multiplePolygonsView.fillPaint.setColor(n);
        multiplePolygonsView.invalidate();
    }

    public void setFillColorOK(int n) {
        boolean bl = n != 0;
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.useFillOK = bl;
        multiplePolygonsView.fillPaintOK.setColor(n);
        multiplePolygonsView.invalidate();
    }

    public void setStrokeColor(int n) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaint.setColor(n);
        multiplePolygonsView.invalidate();
    }

    public void setStrokeColorOK(int n) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaintOK.setColor(n);
        multiplePolygonsView.invalidate();
    }

    public void setStrokeWidth(float f) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaint.setStrokeWidth(f);
        multiplePolygonsView.strokePaintOK.setStrokeWidth(f);
        multiplePolygonsView.invalidate();
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        MultiplePolygonsView multiplePolygonsView = this;
        super.onSizeChanged(n, n2, n3, n4);
        multiplePolygonsView.polygonHelper.setLayout(0, 0, n, n2);
    }

    public void updatePolygon(List<Polygon> object) {
        if (object.isEmpty() && !this.listOfPoints.isEmpty()) {
            MultiplePolygonsView multiplePolygonsView = this;
            multiplePolygonsView.listOfPoints.clear();
            object = multiplePolygonsView.polygonAlphaAnimator;
            if (object != null) {
                object.cancel();
                this.polygonAlphaAnimator = null;
            }
            this.animatePolygonFadeOut();
        } else {
            MultiplePolygonsView multiplePolygonsView = this;
            multiplePolygonsView.strokePaint.setAlpha(255);
            multiplePolygonsView.listOfPoints.clear();
            object = object.iterator();
            while (object.hasNext()) {
                MultiplePolygonsView multiplePolygonsView2 = this;
                Polygon polygon = (Polygon)object.next();
                float[] fArray = new float[16];
                multiplePolygonsView2.polygonHelper.polygonToLinePoints(polygon.getPolygonF(), fArray);
                multiplePolygonsView2.listOfPoints.add(fArray);
                if (!multiplePolygonsView2.useFill && !this.useFillOK) continue;
                this.updatePath();
            }
        }
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.polygonUpdating.set(false);
        multiplePolygonsView.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        MultiplePolygonsView multiplePolygonsView = iterator;
        super.dispatchDraw(canvas);
        DetectionResult detectionResult = multiplePolygonsView.lastResult;
        DetectionResult detectionResult2 = DetectionResult.OK;
        Paint paint = detectionResult == detectionResult2 ? ((MultiplePolygonsView)((Object)iterator)).fillPaintOK : ((MultiplePolygonsView)((Object)iterator)).fillPaint;
        Paint paint2 = detectionResult == detectionResult2 ? ((MultiplePolygonsView)((Object)iterator)).strokePaintOK : ((MultiplePolygonsView)((Object)iterator)).strokePaint;
        boolean bl = detectionResult == detectionResult2 ? ((MultiplePolygonsView)((Object)iterator)).useFillOK : ((MultiplePolygonsView)((Object)iterator)).useFill;
        if (!((MultiplePolygonsView)((Object)iterator)).listOfPoints.isEmpty()) {
            if (bl) {
                canvas.drawPath(((MultiplePolygonsView)((Object)iterator)).path, paint);
            }
            Iterator<float[]> iterator = ((MultiplePolygonsView)((Object)iterator)).listOfPoints.iterator();
            while (iterator.hasNext()) {
                canvas.drawLines((float[])iterator.next(), paint2);
            }
        }
    }
}

