/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import io.scanbot.sap.SapManager;
import java.util.List;
import java.util.Set;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.OcrSettings;
import net.doo.snap.intelligence.SandwichingPdfOcrPerformer;
import net.doo.snap.intelligence.SimpleOcrPerformer;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.TextRecognition;
import net.doo.snap.process.TextRecognizer;
import net.doo.snap.process.compose.SimpleComposer;

public class TextRecognizerFactory
implements TextRecognition {
    private final SapManager sapManager;
    private final OcrPdfRenderer pdfRenderer;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SimpleComposer simpleComposer;
    private final BlobStoreStrategy blobStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final OcrSettings ocrSettings;
    private final OcrPdfRenderer.BitmapBinarizer bitmapBinarizer;

    public TextRecognizerFactory(SapManager sapManager, OcrPdfRenderer pdfRenderer, DocumentStoreStrategy documentStoreStrategy, SimpleComposer simpleComposer, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, OcrSettings ocrSettings, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        this.sapManager = sapManager;
        this.pdfRenderer = pdfRenderer;
        this.documentStoreStrategy = documentStoreStrategy;
        this.simpleComposer = simpleComposer;
        this.blobStoreStrategy = blobStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.ocrSettings = ocrSettings;
        this.bitmapBinarizer = bitmapBinarizer;
    }

    @Override
    public TextRecognizer withPDF(Document document, List<Page> pages, Set<Language> languages) {
        return new TextRecognizer(new SandwichingPdfOcrPerformer(this.sapManager, this.pdfRenderer, languages, this.documentStoreStrategy, this.simpleComposer, this.ocrSettings, document, pages));
    }

    @Override
    public TextRecognizer withoutPDF(List<Page> pages, Set<Language> languages) {
        return new TextRecognizer(new SimpleOcrPerformer(this.sapManager, languages, this.blobStoreStrategy, this.pageStoreStrategy, this.ocrSettings, this.bitmapBinarizer, pages));
    }
}

