/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.textorientation;

import android.graphics.Bitmap;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.textorientation.TextOrientationScanner;
import io.scanbot.textorientation.TextOrientationRecognizer;
import io.scanbot.textorientation.model.TextOrientation;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/textorientation/DefaultTextOrientationScanner;", "Lio/scanbot/sdk/textorientation/TextOrientationScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "textOrientationRecognizer", "Lio/scanbot/textorientation/TextOrientationRecognizer;", "recognizeBitmap", "Lio/scanbot/textorientation/model/TextOrientation;", "bitmap", "Landroid/graphics/Bitmap;", "requestedConfidence", "", "recognizeJPEG", "jpeg", "", "width", "", "height", "sdk-ocr_release"})
public final class DefaultTextOrientationScanner
implements TextOrientationScanner {
    private final TextOrientationRecognizer textOrientationRecognizer;

    @Override
    @NotNull
    public TextOrientation recognizeBitmap(@NotNull Bitmap bitmap, float requestedConfidence) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        TextOrientation textOrientation = this.textOrientationRecognizer.recognizeBitmap(bitmap, requestedConfidence);
        Intrinsics.checkExpressionValueIsNotNull((Object)textOrientation, (String)"textOrientationRecognize\u2026map, requestedConfidence)");
        return textOrientation;
    }

    @Override
    @NotNull
    public TextOrientation recognizeJPEG(@NotNull byte[] jpeg, int width, int height, float requestedConfidence) {
        Intrinsics.checkParameterIsNotNull((Object)jpeg, (String)"jpeg");
        TextOrientation textOrientation = this.textOrientationRecognizer.recognizeJPEG(jpeg, width, height, requestedConfidence);
        Intrinsics.checkExpressionValueIsNotNull((Object)textOrientation, (String)"textOrientationRecognize\u2026ght, requestedConfidence)");
        return textOrientation;
    }

    @Inject
    public DefaultTextOrientationScanner(@NotNull BlobManager blobManager) {
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        String traineddataPath = null;
        try {
            File file = blobManager.getOCRBlobsDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
            traineddataPath = file.getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("OCR blob is not available.");
        }
        this.textOrientationRecognizer = new TextOrientationRecognizer(traineddataPath);
    }
}

