/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFactory;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J$\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J,\u0010!\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\"\u001a\u00020#2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J,\u0010$\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00142\u0006\u0010\"\u001a\u00020#2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "textRecognition", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "pageFactory", "Lio/scanbot/sdk/persistence/PageFactory;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageStoreStrategy", "Lio/scanbot/sdk/persistence/PageStoreStrategy;", "(Lio/scanbot/sdk/ocr/process/TextRecognition;Lio/scanbot/sdk/persistence/PageFactory;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/persistence/PageStoreStrategy;)V", "checkMissingLangs", "", "languages", "", "Lio/scanbot/sdk/entity/Language;", "cleanUpPagesTempFiles", "pages", "", "Lio/scanbot/sdk/entity/Page;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lio/scanbot/sdk/entity/Document;", "recognizeTextFromPages", "Lio/scanbot/sdk/ocr/process/OcrResult;", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUris", "sdk-ocr_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    private final TextRecognition textRecognition;
    private final PageFactory pageFactory;
    private final BlobManager blobManager;
    private final PageFileStorage pageFileStorage;
    private final PageStoreStrategy pageStoreStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable $this$map$iv = imageFileUris;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Uri uri = (Uri)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            io.scanbot.sdk.entity.Page page = this.pageFactory.buildPage(UriKt.toFile((Uri)it));
            collection.add(page);
        }
        List newPages = (List)destination$iv$iv;
        try {
            OcrResult ocrResult = this.textRecognition.withoutPDF(newPages, languages).recognize();
            return ocrResult;
        }
        finally {
            this.cleanUpPagesTempFiles(newPages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable $this$map$iv = pages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void newPage;
            io.scanbot.sdk.entity.Page oldPage;
            Page page = (Page)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            io.scanbot.sdk.entity.Page page2 = oldPage = this.pageFactory.buildPage(newPage.getPageId(), new File(this.pageFileStorage.getImageURI(newPage.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(newPage.getFilter());
            io.scanbot.sdk.entity.Page page3 = oldPage;
            collection.add(page3);
        }
        List newPages = (List)destination$iv$iv;
        try {
            OcrResult ocrResult = this.textRecognition.withoutPDF(newPages, languages).recognize();
            return ocrResult;
        }
        finally {
            this.cleanUpPagesTempFiles(newPages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable $this$map$iv = imageFileUris;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            io.scanbot.sdk.entity.Page oldPage;
            Uri uri = (Uri)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            io.scanbot.sdk.entity.Page page = oldPage = this.pageFactory.buildPage(UriKt.toFile((Uri)it));
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"oldPage");
            page.setPageSize(pageSize);
            io.scanbot.sdk.entity.Page page2 = oldPage;
            collection.add(page2);
        }
        List newPages = (List)destination$iv$iv;
        try {
            OcrResult ocrResult = this.textRecognition.withPDF(this.getPendingDocument(), newPages, languages).recognize();
            return ocrResult;
        }
        finally {
            this.cleanUpPagesTempFiles(newPages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable $this$map$iv = pages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void newPage;
            io.scanbot.sdk.entity.Page oldPage;
            Page page = (Page)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            io.scanbot.sdk.entity.Page page2 = oldPage = this.pageFactory.buildPage(newPage.getPageId(), new File(this.pageFileStorage.getImageURI(newPage.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(newPage.getFilter());
            oldPage.setPolygon(newPage.getPolygon());
            oldPage.setPageSize(pageSize);
            io.scanbot.sdk.entity.Page page3 = oldPage;
            collection.add(page3);
        }
        List newPages = (List)destination$iv$iv;
        try {
            OcrResult ocrResult = this.textRecognition.withPDF(this.getPendingDocument(), newPages, languages).recognize();
            return ocrResult;
        }
        finally {
            this.cleanUpPagesTempFiles(newPages);
        }
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        File file = this.blobManager.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        Set set = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }

    private final Document getPendingDocument() {
        Document document = new Document();
        boolean bl = false;
        boolean bl2 = false;
        Document $this$apply = document;
        boolean bl3 = false;
        $this$apply.setId(UUID.randomUUID().toString());
        $this$apply.setName($this$apply.getId() + ".pdf");
        $this$apply.setOcrStatus(OcrStatus.PENDING);
        return document;
    }

    private final void checkMissingLangs(Set<? extends Language> languages) {
        Set set = SetsKt.minus(languages, (Iterable)this.getInstalledLanguages());
        boolean bl = false;
        boolean bl2 = false;
        Set missingLangs = set;
        boolean bl3 = false;
        Collection collection = missingLangs;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new LanguageNotFoundException(missingLangs + " Provided set of languages was not presented on device");
        }
    }

    private final void cleanUpPagesTempFiles(List<? extends io.scanbot.sdk.entity.Page> pages) {
        Iterable $this$forEach$iv = pages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            io.scanbot.sdk.entity.Page page = (io.scanbot.sdk.entity.Page)element$iv;
            boolean bl = false;
            this.pageStoreStrategy.erasePage(page.getId());
        }
    }

    @Inject
    public ScanbotOpticalCharacterRecognizer(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage, @NotNull PageStoreStrategy pageStoreStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStoreStrategy, (String)"pageStoreStrategy");
        this.textRecognition = textRecognition;
        this.pageFactory = pageFactory;
        this.blobManager = blobManager;
        this.pageFileStorage = pageFileStorage;
        this.pageStoreStrategy = pageStoreStrategy;
    }
}

