/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J.\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J.\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J.\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u001a\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "sapManager", "Lio/scanbot/sap/SapManager;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "kotlin.jvm.PlatformType", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/entity/Page;", "(Lio/scanbot/sdk/entity/Document;[Lio/scanbot/sdk/entity/Page;)V", "createPDF", "", "", "availableLanguages", "", "Lio/scanbot/sdk/entity/Language;", "ocrWithDefaultLanguage", "performOCR", "saveMetaData", "detectedText", "trackDocument", "trackDuration", "ocrStartedMillis", "", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    private final Logger logger;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final BlobManager blobManager;
    private final OcrPdfRenderer pdfRenderer;
    private final SimpleComposer simpleComposer;
    private final SapManager sapManager;
    private final OcrSettings ocrSettings;

    public void composeDocument(@NotNull Document document, Page ... pages) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)pages, (String)"pages");
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            long ocrStartedMillis = SystemClock.elapsedRealtime();
            Set set = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
            Set availableLanguages = set;
            if (availableLanguages.isEmpty()) {
                this.logger.d("OCR", "OCR languages blobs are not available - abort OCR");
                throw (Throwable)new IOException("OCR languages blobs are not available");
            }
            String detectedText = this.createPDF(document, ArraysKt.toList((Object[])pages), availableLanguages);
            this.saveMetaData(document, detectedText);
            this.trackDuration(document, ocrStartedMillis);
        }
        catch (IOException e) {
            this.simpleComposer.composeDocument(document, Arrays.copyOf(pages, pages.length));
        }
    }

    private final String createPDF(Document document, List<? extends Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        return this.performOCR(document, pages, availableLanguages);
    }

    private final String performOCR(Document document, List<? extends Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages);
        return this.ocrWithDefaultLanguage(document, pages, availableLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String ocrWithDefaultLanguage(Document document, List<? extends Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        void $this$toTypedArray$iv;
        Object detectedText = null;
        Object object = pages;
        Document document2 = document;
        OcrPdfRenderer ocrPdfRenderer = this.pdfRenderer;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Page[] pageArray = thisCollection$iv.toArray(new Page[0]);
        if (pageArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Page[] pageArray2 = pageArray;
        OcrPdfRenderer.RenderIterator renderIterator = ocrPdfRenderer.startRender(document2, pageArray2, (Collection<? extends Language>)availableLanguages, this.ocrSettings);
        try {
            while (renderIterator.renderNextPage()) {
                this.logger.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            object = renderIterator.getDetectedText();
        }
        finally {
            renderIterator.recycle();
        }
        detectedText = object;
        return detectedText;
    }

    private final void saveMetaData(Document document, String detectedText) {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(detectedText);
        this.trackDocument(document);
    }

    private final void trackDuration(Document document, long ocrStartedMillis) {
        if (document.getLanguage() == null) {
            return;
        }
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private final void trackDocument(Document document) {
        if (document.getLanguage() != null) {
            Language language = document.getLanguage();
            this.logger.d("OCR", "Document language assigned: " + (language != null ? language.getOcrBlobLanguageTag() : null));
        }
    }

    public OcrComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pdfRenderer, (String)"pdfRenderer");
        Intrinsics.checkParameterIsNotNull((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkParameterIsNotNull((Object)sapManager, (String)"sapManager");
        Intrinsics.checkParameterIsNotNull((Object)ocrSettings, (String)"ocrSettings");
        this.documentStoreStrategy = documentStoreStrategy;
        this.blobManager = blobManager;
        this.pdfRenderer = pdfRenderer;
        this.simpleComposer = simpleComposer;
        this.sapManager = sapManager;
        this.ocrSettings = ocrSettings;
        this.logger = LoggerProvider.getLogger();
    }
}

