/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.entity.PageEntity;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J,\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J,\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/ocr/intelligence/SandwichingPdfOcrPerformer;", "Lio/scanbot/sdk/ocr/process/OcrPerformer;", "sapManager", "Lio/scanbot/sap/SapManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "config", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/entity/PageEntity;", "(Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Ljava/util/Set;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/entity/Document;Ljava/util/List;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "ocrSettings", "createPDF", "Lio/scanbot/sdk/ocr/process/OcrResult;", "availableLanguages", "ocrWithAvailableLanguages", "performOCR", "recognize", "saveMetaData", "", "detectedText", "", "trackDocument", "trackDuration", "ocrStartedMillis", "", "sdk-ocr_release"})
public final class SandwichingPdfOcrPerformer
implements OcrPerformer {
    private final Logger logger;
    private final OcrSettings ocrSettings;
    private final SapManager sapManager;
    private final OcrPdfRenderer pdfRenderer;
    private final Set<Language> languages;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SimpleComposer simpleComposer;
    private final Document document;
    private final List<PageEntity> pages;

    @Override
    @NotNull
    public OcrResult recognize() throws IOException {
        OcrResult ocrResult = new OcrResult(null, null, CollectionsKt.emptyList());
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return ocrResult;
        }
        long ocrStartedMillis = SystemClock.elapsedRealtime();
        try {
            if (this.languages == null || this.languages.isEmpty()) {
                this.logger.d("OCR", "OCR languages blobs are not available - abort OCR");
                throw (Throwable)new IOException("OCR languages blobs are not available");
            }
            ocrResult = this.createPDF(this.document, this.pages, this.languages);
            StringBuilder recognizedText = new StringBuilder();
            Iterable $this$forEach$iv = ocrResult.ocrPages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OcrResult.OCRPage $dstr$text = (OcrResult.OCRPage)element$iv;
                boolean bl = false;
                String text = $dstr$text.component1();
                recognizedText.append(text);
            }
            String string = recognizedText.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"recognizedText.toString()");
            this.saveMetaData(this.document, string);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
            this.simpleComposer.composeDocument(this.document, this.pages);
        }
        this.trackDuration(ocrStartedMillis);
        return ocrResult;
    }

    private final void saveMetaData(Document document, String detectedText) {
        document.ocrStatus = OcrStatus.DONE;
        document.ocrText = detectedText;
        this.trackDocument(document);
    }

    private final void trackDocument(Document document) {
        if (document.language != null) {
            Language language = document.language;
            this.logger.d("OCR", "Document language assigned: " + (language != null ? language.getOcrBlobLanguageTag() : null));
        }
    }

    private final OcrResult createPDF(Document document, List<PageEntity> pages, Set<? extends Language> availableLanguages) throws IOException {
        return this.performOCR(document, pages, availableLanguages);
    }

    private final OcrResult performOCR(Document document, List<PageEntity> pages, Set<? extends Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages);
        return this.ocrWithAvailableLanguages(document, pages, availableLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final OcrResult ocrWithAvailableLanguages(Document document, List<PageEntity> pages, Set<? extends Language> availableLanguages) throws IOException {
        void $this$toTypedArray$iv;
        Object object = pages;
        Document document2 = document;
        OcrPdfRenderer ocrPdfRenderer = this.pdfRenderer;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        PageEntity[] pageEntityArray = thisCollection$iv.toArray(new PageEntity[0]);
        if (pageEntityArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PageEntity[] pageEntityArray2 = pageEntityArray;
        OcrPdfRenderer.RenderIterator renderIterator = ocrPdfRenderer.startRender(document2, pageEntityArray2, (Collection<? extends Language>)availableLanguages, this.ocrSettings);
        try {
            List ocrPages = new ArrayList(pages.size());
            while (renderIterator.renderNextPage()) {
                this.logger.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
                ocrPages.add(new OcrResult.OCRPage(renderIterator.getDetectedText(), renderIterator.getDetectedParagraphs(), renderIterator.getDetectedLines(), renderIterator.getDetectedWords()));
            }
            File documentFile = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
            object = new OcrResult(document, documentFile, ocrPages);
        }
        finally {
            renderIterator.recycle();
        }
        return object;
    }

    private final void trackDuration(long ocrStartedMillis) {
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    public SandwichingPdfOcrPerformer(@NotNull SapManager sapManager, @NotNull OcrPdfRenderer pdfRenderer, @Nullable Set<? extends Language> languages, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SimpleComposer simpleComposer, @NotNull OcrSettings config, @NotNull Document document, @NotNull List<PageEntity> pages) {
        Intrinsics.checkParameterIsNotNull((Object)sapManager, (String)"sapManager");
        Intrinsics.checkParameterIsNotNull((Object)pdfRenderer, (String)"pdfRenderer");
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        this.sapManager = sapManager;
        this.pdfRenderer = pdfRenderer;
        this.languages = languages;
        this.documentStoreStrategy = documentStoreStrategy;
        this.simpleComposer = simpleComposer;
        this.document = document;
        this.pages = pages;
        this.logger = LoggerProvider.getLogger();
        this.ocrSettings = config;
    }
}

