/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J$\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010 \u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "context", "Landroid/content/Context;", "textRecognition", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Landroid/content/Context;Lio/scanbot/sdk/ocr/process/TextRecognition;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "checkMissingLangs", "", "languages", "", "Lio/scanbot/sdk/entity/Language;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lio/scanbot/sdk/entity/Document;", "recognizeTextFromPages", "Lio/scanbot/sdk/ocr/process/OcrResult;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUris", "sdk-ocr_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    private final Context context;
    private final TextRecognition textRecognition;
    private final BlobManager blobManager;
    private final PageFileStorage pageFileStorage;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable $this$map$iv = imageFileUris;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uri;
            Bitmap bitmap;
            Uri uri2 = (Uri)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeFile((String)FileChooserUtils.getPath((Context)this.context, (Uri)uri));
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
            String pageId = this.pageFileStorage.add(bitmap2);
            Page page = new Page(pageId, null, null, 6, null);
            collection.add(page);
        }
        List pages = (List)destination$iv$iv;
        return this.textRecognition.withoutPDF(pages, languages).recognize();
    }

    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        return this.textRecognition.withoutPDF(pages, languages).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable $this$map$iv = imageFileUris;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uri;
            Bitmap bitmap;
            Uri uri2 = (Uri)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeFile((String)FileChooserUtils.getPath((Context)this.context, (Uri)uri));
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
            String pageId = this.pageFileStorage.add(bitmap2);
            Page page = new Page(pageId, null, null, 6, null);
            collection.add(page);
        }
        List pages = (List)destination$iv$iv;
        return this.textRecognition.withPDF(this.getPendingDocument(), pages, languages).recognize();
    }

    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        return this.textRecognition.withPDF(this.getPendingDocument(), pages, languages).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.blobManager.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
    }

    private final Document getPendingDocument() {
        Document document = new Document();
        boolean bl = false;
        boolean bl2 = false;
        Document $this$apply = document;
        boolean bl3 = false;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        $this$apply.id = string;
        $this$apply.name = $this$apply.id + ".pdf";
        $this$apply.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    private final void checkMissingLangs(Set<? extends Language> languages) {
        Set set = SetsKt.minus(languages, (Iterable)this.getInstalledLanguages());
        boolean bl = false;
        boolean bl2 = false;
        Set missingLangs = set;
        boolean bl3 = false;
        Collection collection = missingLangs;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new LanguageNotFoundException(missingLangs + " Provided set of languages was not presented on device");
        }
    }

    public ScanbotOpticalCharacterRecognizer(@NotNull Context context, @NotNull TextRecognition textRecognition, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.context = context;
        this.textRecognition = textRecognition;
        this.blobManager = blobManager;
        this.pageFileStorage = pageFileStorage;
    }
}

