/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import io.scanbot.sap.SapManager;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.SandwichingPdfOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.SimpleOcrPerformer;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.ocr.process.TextRecognizer;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J$\u0010\u001d\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/scanbot/sdk/ocr/intelligence/TextRecognizerFactory;", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "sapManager", "Lio/scanbot/sap/SapManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "(Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;)V", "withPDF", "Lio/scanbot/sdk/ocr/process/TextRecognizer;", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "withoutPDF", "sdk-ocr_release"})
public final class TextRecognizerFactory
implements TextRecognition {
    private final SapManager sapManager;
    private final OcrPdfRenderer pdfRenderer;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SimpleComposer simpleComposer;
    private final BlobStoreStrategy blobStoreStrategy;
    private final PageFileStorage pageFileStorage;
    private final OcrSettings ocrSettings;
    private final OcrPdfRenderer.BitmapBinarizer bitmapBinarizer;

    @NotNull
    public TextRecognizer withPDF(@NotNull Document document, @NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        return new TextRecognizer(new SandwichingPdfOcrPerformer(this.sapManager, this.pdfRenderer, languages, this.documentStoreStrategy, this.simpleComposer, this.ocrSettings, document, pages));
    }

    @NotNull
    public TextRecognizer withoutPDF(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        return new TextRecognizer(new SimpleOcrPerformer(this.sapManager, languages, this.blobStoreStrategy, this.pageFileStorage, this.ocrSettings, this.bitmapBinarizer, pages));
    }

    public TextRecognizerFactory(@NotNull SapManager sapManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SimpleComposer simpleComposer, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        Intrinsics.checkParameterIsNotNull((Object)sapManager, (String)"sapManager");
        Intrinsics.checkParameterIsNotNull((Object)pdfRenderer, (String)"pdfRenderer");
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkParameterIsNotNull((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)ocrSettings, (String)"ocrSettings");
        Intrinsics.checkParameterIsNotNull((Object)bitmapBinarizer, (String)"bitmapBinarizer");
        this.sapManager = sapManager;
        this.pdfRenderer = pdfRenderer;
        this.documentStoreStrategy = documentStoreStrategy;
        this.simpleComposer = simpleComposer;
        this.blobStoreStrategy = blobStoreStrategy;
        this.pageFileStorage = pageFileStorage;
        this.ocrSettings = ocrSettings;
        this.bitmapBinarizer = bitmapBinarizer;
    }
}

