/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.OcrResultBlock;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0010H\u0002J$\u0010%\u001a\u00020&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0011H\u0002J$\u0010*\u001a\u00020&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010,\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/scanbot/sdk/ocr/intelligence/SimpleOcrPerformer;", "Lio/scanbot/sdk/ocr/process/OcrPerformer;", "sapManager", "Lio/scanbot/sap/SapManager;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "(Lio/scanbot/sap/SapManager;Ljava/util/Set;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;Ljava/util/List;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "extractBlock", "Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "resultIterator", "Lcom/googlecode/tesseract/android/ResultIterator;", "pageIteratorLevel", "", "thresholdedImage", "Lcom/googlecode/leptonica/android/Pix;", "blockType", "Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;", "getBlocks", "tessBaseAPI", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "initTessApi", "languageCodes", "", "ocrWithAvailableLanguages", "Lio/scanbot/sdk/ocr/process/OcrResult;", "pageToFile", "Ljava/io/File;", "page", "performTessOCR", "availableLanguages", "recognize", "trackDuration", "", "ocrStartedMillis", "", "sdk-ocr_release"})
public final class SimpleOcrPerformer
implements OcrPerformer {
    private final Logger logger;
    private final SapManager sapManager;
    private final Set<Language> languages;
    private final BlobStoreStrategy blobStoreStrategy;
    private final PageFileStorage pageFileStorage;
    private final OcrSettings ocrSettings;
    private final OcrPdfRenderer.BitmapBinarizer bitmapBinarizer;
    private final List<Page> pages;

    @Override
    @NotNull
    public OcrResult recognize() {
        OcrResult ocrResult = new OcrResult(null, null, CollectionsKt.emptyList());
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return ocrResult;
        }
        long ocrStartedMillis = SystemClock.elapsedRealtime();
        try {
            ocrResult = this.performTessOCR(this.pages, this.languages);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        this.trackDuration(ocrStartedMillis);
        return ocrResult;
    }

    private final void trackDuration(long ocrStartedMillis) {
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private final OcrResult performTessOCR(List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages);
        return this.ocrWithAvailableLanguages(pages, availableLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OcrResult ocrWithAvailableLanguages(List<Page> pages, Set<? extends Language> languages) throws IOException {
        TessBaseAPI tessBaseAPI = this.initTessApi(Language.Companion.languageCodes((Collection)languages));
        List ocrPages = new ArrayList(pages.size());
        try {
            for (Page page : pages) {
                File pageFile = this.pageToFile(page);
                if (!pageFile.exists()) continue;
                if (this.ocrSettings.getBinarizeImage()) {
                    Bitmap bitmap = BitmapFactory.decodeFile((String)pageFile.getAbsolutePath());
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeFile(pageFile.absolutePath)");
                    tessBaseAPI.setImage(this.bitmapBinarizer.binarizeBitmap(bitmap, true));
                } else {
                    tessBaseAPI.setImage(pageFile);
                }
                String string = tessBaseAPI.getUTF8Text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tessBaseAPI.utF8Text");
                ocrPages.add(new OcrResult.OCRPage(string, this.getBlocks(tessBaseAPI, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH), this.getBlocks(tessBaseAPI, 2, OcrResultBlock.OcrResultBlockType.LINE), this.getBlocks(tessBaseAPI, 3, OcrResultBlock.OcrResultBlockType.WORD)));
            }
        }
        finally {
            tessBaseAPI.end();
        }
        return new OcrResult(new Document(), null, ocrPages);
    }

    private final List<OcrResultBlock> getBlocks(TessBaseAPI tessBaseAPI, int pageIteratorLevel, OcrResultBlock.OcrResultBlockType blockType) {
        List blocks = new ArrayList();
        Pix thresholdedImage = tessBaseAPI.getThresholdedImage();
        ResultIterator resultIterator = tessBaseAPI.getResultIterator();
        resultIterator.begin();
        ResultIterator resultIterator2 = resultIterator;
        Intrinsics.checkNotNullExpressionValue((Object)resultIterator2, (String)"resultIterator");
        blocks.add(this.extractBlock(resultIterator2, pageIteratorLevel, thresholdedImage, blockType));
        while (resultIterator.next(pageIteratorLevel)) {
            blocks.add(this.extractBlock(resultIterator, pageIteratorLevel, thresholdedImage, blockType));
        }
        return blocks;
    }

    private final OcrResultBlock extractBlock(ResultIterator resultIterator, int pageIteratorLevel, Pix thresholdedImage, OcrResultBlock.OcrResultBlockType blockType) {
        String text = resultIterator.getUTF8Text(pageIteratorLevel);
        int[] boundingBoxArray = resultIterator.getBoundingBox(pageIteratorLevel);
        Rect boundingBoxWithImageSize = new Rect();
        RectF boundingBox = new RectF();
        if (boundingBoxArray.length == 4) {
            boundingBoxWithImageSize = new Rect(boundingBoxArray[0], boundingBoxArray[1], boundingBoxArray[2], boundingBoxArray[3]);
            if (thresholdedImage != null) {
                boundingBox = new RectF((float)boundingBoxArray[0] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[1] / (float)thresholdedImage.getHeight(), (float)boundingBoxArray[2] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[3] / (float)thresholdedImage.getHeight());
            }
        }
        String string = text;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        return new OcrResultBlock(string, boundingBox, boundingBoxWithImageSize, resultIterator.confidence(pageIteratorLevel), blockType);
    }

    private final File pageToFile(Page page) throws IOException {
        File document = new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath());
        File original = new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
        return document.exists() ? document : original;
    }

    private final TessBaseAPI initTessApi(List<String> languageCodes) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.blobStoreStrategy.getOcrDataDirectory().toString(), TextUtils.join((CharSequence)"+", (Iterable)languageCodes));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    public SimpleOcrPerformer(@NotNull SapManager sapManager, @NotNull Set<? extends Language> languages, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer, @NotNull List<Page> pages) {
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)bitmapBinarizer, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        this.sapManager = sapManager;
        this.languages = languages;
        this.blobStoreStrategy = blobStoreStrategy;
        this.pageFileStorage = pageFileStorage;
        this.ocrSettings = ocrSettings;
        this.bitmapBinarizer = bitmapBinarizer;
        this.pages = pages;
        this.logger = LoggerProvider.getLogger();
    }
}

