/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import com.googlecode.tesseract.android.TessPdfRenderer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrResultBlock;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ7\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "", "context", "Landroid/content/Context;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;)V", "startRender", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/entity/Document;[Lio/scanbot/sdk/persistence/Page;Ljava/util/Collection;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "BitmapBinarizer", "Companion", "RenderIterator", "RenderIteratorImpl", "sdk-ocr_release"})
public final class OcrPdfRenderer {
    private final Context context;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageFileStorage pageFileStorage;
    private final BlobStoreStrategy blobStoreStrategy;
    private final BitmapBinarizer bitmapBinarizer;
    @NotNull
    public static final String ROTATED_TEMP_FILE_SUFFIX = "_rotated";
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final RenderIterator startRender(@NotNull Document document, @NotNull Page[] pages, @NotNull Collection<? extends Language> languages, @NotNull OcrSettings ocrSettings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)pages, (String)"pages");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        return new RenderIteratorImpl(document, pages, languages, ocrSettings);
    }

    public OcrPdfRenderer(@NotNull Context context, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull BitmapBinarizer bitmapBinarizer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)bitmapBinarizer, (String)"bitmapBinarizer");
        this.context = context;
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageFileStorage = pageFileStorage;
        this.blobStoreStrategy = blobStoreStrategy;
        this.bitmapBinarizer = bitmapBinarizer;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0017\u001a\u00020\u0018H&J\b\u0010\u0019\u001a\u00020\u001aH&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "", "detectedLines", "", "Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "getDetectedLines", "()Ljava/util/List;", "detectedParagraphs", "getDetectedParagraphs", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "detectedWords", "getDetectedWords", "lastProcessedPage", "Lio/scanbot/sdk/persistence/Page;", "getLastProcessedPage", "()Lio/scanbot/sdk/persistence/Page;", "lastProcessedPosition", "", "getLastProcessedPosition", "()I", "recycle", "", "renderNextPage", "", "sdk-ocr_release"})
    public static interface RenderIterator {
        public boolean renderNextPage() throws IOException;

        @NotNull
        public String getDetectedText();

        @NotNull
        public List<OcrResultBlock> getDetectedParagraphs();

        @NotNull
        public List<OcrResultBlock> getDetectedLines();

        @NotNull
        public List<OcrResultBlock> getDetectedWords();

        @Nullable
        public Page getLastProcessedPage();

        public int getLastProcessedPosition();

        public void recycle();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "", "binarizeBitmap", "Landroid/graphics/Bitmap;", "bitmap", "recycle", "", "sdk-ocr_release"})
    public static interface BitmapBinarizer {
        @NotNull
        public Bitmap binarizeBitmap(@NotNull Bitmap var1, boolean var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ*\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;H\u0002J&\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010/\u001a\u0002002\u0006\u00107\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020;H\u0002J\u0016\u0010=\u001a\u0002002\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010H\u0002J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020@H\u0002J,\u0010D\u001a\u00020@2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010E\u001a\u00020\u00062\n\u0010\u0016\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0018\u0010F\u001a\u00020.2\u0006\u0010E\u001a\u00020\u00062\u0006\u0010G\u001a\u00020HH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0016\u0010#\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIteratorImpl;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/entity/Document;[Lio/scanbot/sdk/persistence/Page;Ljava/util/Collection;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "currentPosition", "", "detectedLines", "", "Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "getDetectedLines", "()Ljava/util/List;", "detectedParagraphs", "getDetectedParagraphs", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "detectedTextBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDetectedTextBuilder", "()Ljava/lang/StringBuilder;", "setDetectedTextBuilder", "(Ljava/lang/StringBuilder;)V", "detectedWords", "getDetectedWords", "lastProcessedPage", "getLastProcessedPage", "()Lio/scanbot/sdk/persistence/Page;", "lastProcessedPosition", "getLastProcessedPosition", "()I", "lines", "", "[Lio/scanbot/sdk/persistence/Page;", "paragraphs", "tempRotatedFiles", "Ljava/io/File;", "tessBaseAPI", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "tessPdfRenderer", "Lcom/googlecode/tesseract/android/TessPdfRenderer;", "words", "extractBlock", "resultIterator", "Lcom/googlecode/tesseract/android/ResultIterator;", "pageIteratorLevel", "thresholdedImage", "Lcom/googlecode/leptonica/android/Pix;", "blockType", "Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;", "getBlocks", "initTessApi", "languageCodes", "recycle", "", "renderNextPage", "", "resetDataHolders", "savePage", "page", "writeRotatedBitmapTempFile", "bitmap", "Landroid/graphics/Bitmap;", "sdk-ocr_release"})
    private final class RenderIteratorImpl
    implements RenderIterator {
        private final TessBaseAPI tessBaseAPI;
        private final TessPdfRenderer tessPdfRenderer;
        private List<OcrResultBlock> paragraphs;
        private List<OcrResultBlock> lines;
        private List<OcrResultBlock> words;
        private final List<File> tempRotatedFiles;
        private int currentPosition;
        @NotNull
        private StringBuilder detectedTextBuilder;
        private final Page[] pages;
        private final OcrSettings ocrSettings;

        @NotNull
        public final StringBuilder getDetectedTextBuilder() {
            return this.detectedTextBuilder;
        }

        public final void setDetectedTextBuilder(@NotNull StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
            this.detectedTextBuilder = stringBuilder;
        }

        @Override
        @NotNull
        public String getDetectedText() {
            String string = this.detectedTextBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"detectedTextBuilder.toString()");
            return string;
        }

        private final TessBaseAPI initTessApi(List<String> languageCodes) throws IOException {
            TessBaseAPI tessBaseAPI = new TessBaseAPI();
            tessBaseAPI.init(OcrPdfRenderer.this.blobStoreStrategy.getOcrDataDirectory().toString(), TextUtils.join((CharSequence)"+", (Iterable)languageCodes));
            tessBaseAPI.setPageSegMode(1);
            return tessBaseAPI;
        }

        @Override
        public boolean renderNextPage() throws IOException {
            this.resetDataHolders();
            if (this.currentPosition == 0) {
                this.tessBaseAPI.beginDocument(this.tessPdfRenderer);
            }
            if (this.currentPosition >= this.pages.length) {
                return false;
            }
            Page page = this.pages[this.currentPosition];
            this.savePage(this.tessBaseAPI, this.tessPdfRenderer, page, this.detectedTextBuilder);
            if (this.currentPosition == this.pages.length - 1) {
                this.tessBaseAPI.endDocument(this.tessPdfRenderer);
            }
            int n = this.currentPosition;
            this.currentPosition = n + 1;
            return true;
        }

        private final void resetDataHolders() {
            this.detectedTextBuilder = new StringBuilder();
            this.paragraphs = new ArrayList();
            this.lines = new ArrayList();
            this.words = new ArrayList();
        }

        private final void savePage(TessBaseAPI tessBaseAPI, TessPdfRenderer tessPdfRenderer, Page page, StringBuilder detectedText) throws IOException {
            File imageFile;
            File document = new File(OcrPdfRenderer.this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath());
            File original = new File(OcrPdfRenderer.this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
            File file = imageFile = document.exists() ? document : original;
            if (!imageFile.exists()) {
                return;
            }
            Bitmap bitmap = BitmapFactory.decodeFile((String)imageFile.getPath());
            Pix pix = null;
            if (this.ocrSettings.getBinarizeImage()) {
                BitmapBinarizer bitmapBinarizer = OcrPdfRenderer.this.bitmapBinarizer;
                Bitmap bitmap2 = bitmap;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
                Bitmap bitmapBinarized = bitmapBinarizer.binarizeBitmap(bitmap2, false);
                Pix pix2 = ReadFile.readBitmap(bitmapBinarized);
                Intrinsics.checkNotNullExpressionValue((Object)pix2, (String)"ReadFile.readBitmap(bitmapBinarized)");
                pix = pix2;
                bitmapBinarized.recycle();
            } else {
                Pix pix3 = ReadFile.readBitmap(bitmap);
                Intrinsics.checkNotNullExpressionValue((Object)pix3, (String)"ReadFile.readBitmap(bitmap)");
                pix = pix3;
            }
            Bitmap bitmap3 = bitmap;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"bitmap");
            File rotatedPageFile = this.writeRotatedBitmapTempFile(page, bitmap3);
            tessBaseAPI.addPageToDocument(pix, rotatedPageFile.getPath(), tessPdfRenderer);
            detectedText.append(tessBaseAPI.getUTF8Text());
            this.paragraphs.addAll((Collection<OcrResultBlock>)this.getBlocks(tessBaseAPI, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH));
            this.lines.addAll((Collection<OcrResultBlock>)this.getBlocks(tessBaseAPI, 2, OcrResultBlock.OcrResultBlockType.LINE));
            this.words.addAll((Collection<OcrResultBlock>)this.getBlocks(tessBaseAPI, 3, OcrResultBlock.OcrResultBlockType.WORD));
            pix.recycle();
            bitmap.recycle();
        }

        private final List<OcrResultBlock> getBlocks(TessBaseAPI tessBaseAPI, int pageIteratorLevel, OcrResultBlock.OcrResultBlockType blockType) {
            List blocks = new ArrayList();
            Pix thresholdedImage = tessBaseAPI.getThresholdedImage();
            ResultIterator resultIterator = tessBaseAPI.getResultIterator();
            resultIterator.begin();
            ResultIterator resultIterator2 = resultIterator;
            Intrinsics.checkNotNullExpressionValue((Object)resultIterator2, (String)"resultIterator");
            blocks.add(this.extractBlock(resultIterator2, pageIteratorLevel, thresholdedImage, blockType));
            while (resultIterator.next(pageIteratorLevel)) {
                blocks.add(this.extractBlock(resultIterator, pageIteratorLevel, thresholdedImage, blockType));
            }
            return blocks;
        }

        private final OcrResultBlock extractBlock(ResultIterator resultIterator, int pageIteratorLevel, Pix thresholdedImage, OcrResultBlock.OcrResultBlockType blockType) {
            String string;
            String text = resultIterator.getUTF8Text(pageIteratorLevel);
            int[] boundingBoxArray = resultIterator.getBoundingBox(pageIteratorLevel);
            Rect boundingBoxWithImageSize = new Rect();
            RectF boundingBox = new RectF();
            if (boundingBoxArray.length == 4) {
                boundingBoxWithImageSize = new Rect(boundingBoxArray[0], boundingBoxArray[1], boundingBoxArray[2], boundingBoxArray[3]);
                if (thresholdedImage != null) {
                    boundingBox = new RectF((float)boundingBoxArray[0] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[1] / (float)thresholdedImage.getHeight(), (float)boundingBoxArray[2] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[3] / (float)thresholdedImage.getHeight());
                }
            }
            if ((string = text) == null) {
                string = "";
            }
            return new OcrResultBlock(string, boundingBox, boundingBoxWithImageSize, resultIterator.confidence(pageIteratorLevel), blockType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final File writeRotatedBitmapTempFile(Page page, Bitmap bitmap) throws IOException {
            File rotatedPageFile = File.createTempFile("scanbot_", page.getPageId() + OcrPdfRenderer.ROTATED_TEMP_FILE_SUFFIX, OcrPdfRenderer.this.context.getExternalCacheDir());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(rotatedPageFile);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fos);
            }
            File file = rotatedPageFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rotatedPageFile");
            this.tempRotatedFiles.add(file);
            return rotatedPageFile;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedParagraphs() {
            return this.paragraphs;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedLines() {
            return this.lines;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedWords() {
            return this.words;
        }

        @Override
        @Nullable
        public Page getLastProcessedPage() {
            return this.currentPosition < this.pages.length ? this.pages[this.currentPosition] : null;
        }

        @Override
        public int getLastProcessedPosition() {
            return this.currentPosition - 1;
        }

        @Override
        public void recycle() {
            for (File tempFile : this.tempRotatedFiles) {
                FileUtils.deleteQuietly((File)tempFile);
            }
            this.tempRotatedFiles.clear();
            this.tessBaseAPI.end();
            this.tessPdfRenderer.recycle();
        }

        public RenderIteratorImpl(@NotNull Document document, @NotNull Page[] pages, @NotNull Collection<? extends Language> languages, OcrSettings ocrSettings) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)pages, (String)"pages");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
            this.pages = pages;
            this.ocrSettings = ocrSettings;
            this.paragraphs = new ArrayList();
            this.lines = new ArrayList();
            this.words = new ArrayList();
            this.tempRotatedFiles = new ArrayList();
            this.detectedTextBuilder = new StringBuilder();
            OcrPdfRenderer.this.documentStoreStrategy.getDocumentDir(document.id).mkdirs();
            File documentFile = OcrPdfRenderer.this.documentStoreStrategy.getDocumentFile(document.id, document.name);
            this.tessBaseAPI = this.initTessApi(Language.Companion.languageCodes(languages));
            File file = documentFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"documentFile");
            this.tessPdfRenderer = new TessPdfRenderer(this.tessBaseAPI, FilenameUtils.removeExtension((String)file.getPath()));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$Companion;", "", "()V", "ROTATED_TEMP_FILE_SUFFIX", "", "sdk-ocr_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

