/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J.\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J.\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J.\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001a\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "sapManager", "Lio/scanbot/sap/SapManager;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "config", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "createPDF", "", "availableLanguages", "", "Lio/scanbot/sdk/entity/Language;", "ocrWithDefaultLanguage", "performOCR", "saveMetaData", "detectedText", "trackDocument", "trackDuration", "ocrStartedMillis", "", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    private final Logger logger;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final BlobManager blobManager;
    private final OcrPdfRenderer pdfRenderer;
    private final SimpleComposer simpleComposer;
    private final SapManager sapManager;
    private final OcrSettings ocrSettings;

    public void composeDocument(@NotNull Document document, @NotNull List<Page> pages, @NotNull ComposerConfig config) throws IOException {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            long ocrStartedMillis = SystemClock.elapsedRealtime();
            Set availableLanguages = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            if (availableLanguages.isEmpty()) {
                this.logger.d("OCR", "OCR languages blobs are not available - abort OCR");
                throw (Throwable)new IOException("OCR languages blobs are not available");
            }
            String detectedText = this.createPDF(document, CollectionsKt.toList((Iterable)pages), availableLanguages);
            this.saveMetaData(document, detectedText);
            this.trackDuration(document, ocrStartedMillis);
        }
        catch (IOException e) {
            Composer.DefaultImpls.composeDocument$default((Composer)((Composer)this.simpleComposer), (Document)document, pages, null, (int)4, null);
        }
    }

    private final String createPDF(Document document, List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        return this.performOCR(document, pages, availableLanguages);
    }

    private final String performOCR(Document document, List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages);
        return this.ocrWithDefaultLanguage(document, pages, availableLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String ocrWithDefaultLanguage(Document document, List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        String string;
        String detectedText = null;
        Collection $this$toTypedArray$iv = pages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Page[] pageArray = thisCollection$iv.toArray(new Page[0]);
        if (pageArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pageArray, (Collection<? extends Language>)availableLanguages, this.ocrSettings);
        try {
            while (renderIterator.renderNextPage()) {
                this.logger.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            string = renderIterator.getDetectedText();
        }
        finally {
            renderIterator.recycle();
        }
        detectedText = string;
        return detectedText;
    }

    private final void saveMetaData(Document document, String detectedText) {
        document.ocrStatus = OcrStatus.DONE;
        document.ocrText = detectedText;
        this.trackDocument(document);
    }

    private final void trackDuration(Document document, long ocrStartedMillis) {
        if (document.language == null) {
            return;
        }
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private final void trackDocument(Document document) {
        if (document.language != null) {
            Language language = document.language;
            this.logger.d("OCR", "Document language assigned: " + (language != null ? language.getOcrBlobLanguageTag() : null));
        }
    }

    public OcrComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)pdfRenderer, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        this.documentStoreStrategy = documentStoreStrategy;
        this.blobManager = blobManager;
        this.pdfRenderer = pdfRenderer;
        this.simpleComposer = simpleComposer;
        this.sapManager = sapManager;
        this.ocrSettings = ocrSettings;
        this.logger = LoggerProvider.getLogger();
    }
}

