/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.OcrResultBlock;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010(\u001a\u00020&\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u00104\u001a\u000201\u0012\u0006\u00108\u001a\u000205\u0012\u0006\u0010?\u001a\u00020<\u0012\u0006\u0010,\u001a\u00020)\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b@\u0010AJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u000e\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0005\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u0005\u0010\u000fJ-\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0018J1\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u001dJ\u0017\u0010\u0005\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0005\u0010 J\u001d\u0010\u0005\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u0007H\u0002\u00a2\u0006\u0004\b\u0005\u0010#J\u000f\u0010$\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b$\u0010%R\u0016\u0010(\u001a\u00020&8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010'R\u0016\u0010,\u001a\u00020)8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00104\u001a\u0002018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00108\u001a\u0002058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u0010;\u001a\u0002098\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010:R\u0016\u0010?\u001a\u00020<8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>\u00a8\u0006B"}, d2={"Lio/scanbot/sdk/ocr/intelligence/SimpleOcrPerformer;", "Lio/scanbot/sdk/ocr/process/OcrPerformer;", "", "ocrStartedMillis", "", "a", "(J)V", "", "Lio/scanbot/sdk/persistence/Page;", "pages", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "Lio/scanbot/sdk/ocr/process/OcrResult;", "b", "(Ljava/util/List;Ljava/util/Set;)Lio/scanbot/sdk/ocr/process/OcrResult;", "languages", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "tessBaseAPI", "", "pageIteratorLevel", "Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;", "blockType", "Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "(Lcom/googlecode/tesseract/android/TessBaseAPI;ILio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;)Ljava/util/List;", "Lcom/googlecode/tesseract/android/ResultIterator;", "resultIterator", "Lcom/googlecode/leptonica/android/Pix;", "thresholdedImage", "(Lcom/googlecode/tesseract/android/ResultIterator;ILcom/googlecode/leptonica/android/Pix;Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;)Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "page", "Ljava/io/File;", "(Lio/scanbot/sdk/persistence/Page;)Ljava/io/File;", "", "languageCodes", "(Ljava/util/List;)Lcom/googlecode/tesseract/android/TessBaseAPI;", "recognize", "()Lio/scanbot/sdk/ocr/process/OcrResult;", "Lio/scanbot/sap/SapManager;", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "g", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "bitmapBinarizer", "h", "Ljava/util/List;", "c", "Ljava/util/Set;", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "d", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/PageFileStorage;", "e", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "f", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "<init>", "(Lio/scanbot/sap/SapManager;Ljava/util/Set;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;Ljava/util/List;)V", "sdk-ocr_release"})
public final class SimpleOcrPerformer
implements OcrPerformer {
    private final Logger a;
    private final SapManager b;
    private final Set<Language> c;
    private final BlobStoreStrategy d;
    private final PageFileStorage e;
    private final OcrSettings f;
    private final OcrPdfRenderer.BitmapBinarizer g;
    private final List<Page> h;

    private final void a(long l) {
        long l2 = SystemClock.elapsedRealtime() - l;
        this.a.d("OCR", "Ocr total: " + (float)l2 / 1000.0f + " sec");
    }

    private final OcrResult b(List<Page> list, Set<? extends Language> set) throws IOException {
        this.a.d("OCR", "Starting OCR with languages: " + set);
        return this.a(list, set);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final OcrResult a(List<Page> iterator, Set<? extends Language> object) throws IOException {
        Document document;
        ArrayList<OcrResult.OCRPage> arrayList;
        object = simpleOcrPerformer.a(Language.Companion.languageCodes((Collection)object));
        ArrayList<OcrResult.OCRPage> arrayList2 = arrayList;
        arrayList = new ArrayList<OcrResult.OCRPage>(iterator.size());
        try {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                OcrResult.OCRPage oCRPage;
                Object object2 = simpleOcrPerformer.a((Page)iterator.next());
                if (!((File)object2).exists()) continue;
                if (simpleOcrPerformer.f.getBinarizeImage()) {
                    Bitmap bitmap = BitmapFactory.decodeFile((String)((File)object2).getAbsolutePath());
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeFile(pageFile.absolutePath)");
                    ((TessBaseAPI)object).setImage(simpleOcrPerformer.g.binarizeBitmap(bitmap, true));
                } else {
                    ((TessBaseAPI)object).setImage((File)object2);
                }
                Object object3 = object;
                object2 = ((TessBaseAPI)object3).getUTF8Text();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"tessBaseAPI.utF8Text");
                List<OcrResultBlock> list = simpleOcrPerformer.a((TessBaseAPI)object3, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH);
                List<OcrResultBlock> list2 = simpleOcrPerformer.a((TessBaseAPI)object, 2, OcrResultBlock.OcrResultBlockType.LINE);
                List<OcrResultBlock> list3 = simpleOcrPerformer.a((TessBaseAPI)object, 3, OcrResultBlock.OcrResultBlockType.WORD);
                oCRPage((String)object2, list, list2, list3);
                arrayList2.add(oCRPage);
            }
        }
        catch (Throwable throwable) {
            ((TessBaseAPI)object).end();
            throw throwable;
        }
        {
            continue;
        }
        ((TessBaseAPI)object).end();
        SimpleOcrPerformer simpleOcrPerformer = document;
        document = new Document();
        return new OcrResult((Document)simpleOcrPerformer, null, arrayList2);
    }

    private final List<OcrResultBlock> a(TessBaseAPI object, int n, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        ArrayList<OcrResultBlock> arrayList;
        ArrayList<OcrResultBlock> arrayList2 = arrayList;
        TessBaseAPI tessBaseAPI = object;
        arrayList2();
        object = tessBaseAPI.getThresholdedImage();
        ResultIterator resultIterator = tessBaseAPI.getResultIterator();
        resultIterator.begin();
        Intrinsics.checkNotNullExpressionValue((Object)resultIterator, (String)"resultIterator");
        arrayList.add(this.a(resultIterator, n, (Pix)object, ocrResultBlockType));
        while (resultIterator.next(n)) {
            arrayList2.add(this.a(resultIterator, n, (Pix)object, ocrResultBlockType));
        }
        return arrayList2;
    }

    private final OcrResultBlock a(ResultIterator resultIterator, int n, Pix pix, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        RectF rectF;
        Rect rect;
        String string = resultIterator.getUTF8Text(n);
        int[] nArray = resultIterator.getBoundingBox(n);
        Rect rect2 = rect;
        rect = new Rect();
        RectF rectF2 = rectF;
        rectF = new RectF();
        if (nArray.length == 4) {
            Rect rect3;
            rect2 = rect3;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            rect3 = new Rect(n2, n3, n4, n5);
            if (pix != null) {
                RectF rectF3;
                rectF2 = rectF3;
                float f = (float)nArray[0] / (float)pix.getWidth();
                float f2 = (float)nArray[1] / (float)pix.getHeight();
                float f3 = (float)nArray[2] / (float)pix.getWidth();
                float f4 = (float)nArray[3] / (float)pix.getHeight();
                rectF3 = new RectF(f, f2, f3, f4);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        float f = resultIterator.confidence(n);
        return new OcrResultBlock(string, rectF2, rect2, f, ocrResultBlockType);
    }

    private final File a(Page page) throws IOException {
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(this.e.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
        if (new File(this.e.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()).exists()) {
            file4 = file3;
        }
        return file4;
    }

    private final TessBaseAPI a(List<String> list) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.d.getOcrDataDirectory().toString(), TextUtils.join((CharSequence)"+", list));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    public SimpleOcrPerformer(@NotNull SapManager sapManager, @NotNull Set<? extends Language> set, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer, @NotNull List<Page> list) {
        SimpleOcrPerformer simpleOcrPerformer = this;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        Intrinsics.checkNotNullParameter(set, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)bitmapBinarizer, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter(list, (String)"pages");
        this.b = sapManager;
        this.c = set;
        this.d = blobStoreStrategy;
        this.e = pageFileStorage;
        this.f = ocrSettings;
        this.g = bitmapBinarizer;
        simpleOcrPerformer.h = list;
        simpleOcrPerformer.a = LoggerProvider.getLogger();
    }

    @Override
    @NotNull
    public OcrResult recognize() {
        OcrResult ocrResult;
        OcrResult ocrResult2 = ocrResult;
        List list = CollectionsKt.emptyList();
        ocrResult = new OcrResult(null, null, list);
        if (!this.b.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return ocrResult2;
        }
        SimpleOcrPerformer simpleOcrPerformer = this;
        long l = SystemClock.elapsedRealtime();
        List<Page> list2 = simpleOcrPerformer.h;
        try {
            ocrResult2 = simpleOcrPerformer.b(list2, simpleOcrPerformer.c);
        }
        catch (IOException iOException) {
            this.a.logException((Throwable)iOException);
        }
        this.a(l);
        return ocrResult2;
    }
}

