/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.Size;

public class Box {
    private static final String TAG;
    public static final int INDEX_X = 0;
    public static final int INDEX_Y = 1;
    public static final int INDEX_W = 2;
    public static final int INDEX_H = 3;
    private final long mNativeBox;
    private boolean mRecycled = false;

    public Box(long l) {
        this.mNativeBox = l;
        this.mRecycled = false;
    }

    public Box(int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            long l = Box.nativeCreate(n, n2, n3, n4);
            if (l != 0L) {
                Box box = this;
                box.mNativeBox = l;
                box.mRecycled = false;
                return;
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalArgumentException("All box dimensions must be non-negative");
    }

    private static native long nativeCreate(int var0, int var1, int var2, int var3);

    private static native int nativeGetX(long var0);

    private static native int nativeGetY(long var0);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetGeometry(long var0, int[] var2);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
        TAG = Box.class.getSimpleName();
    }

    public long getNativeBox() {
        if (!this.mRecycled) {
            return this.mNativeBox;
        }
        throw new IllegalStateException();
    }

    public int getX() {
        if (!this.mRecycled) {
            return Box.nativeGetX(this.mNativeBox);
        }
        throw new IllegalStateException();
    }

    public int getY() {
        if (!this.mRecycled) {
            return Box.nativeGetY(this.mNativeBox);
        }
        throw new IllegalStateException();
    }

    public int getWidth() {
        if (!this.mRecycled) {
            return Box.nativeGetWidth(this.mNativeBox);
        }
        throw new IllegalStateException();
    }

    public int getHeight() {
        if (!this.mRecycled) {
            return Box.nativeGetHeight(this.mNativeBox);
        }
        throw new IllegalStateException();
    }

    public Rect getRect() {
        int[] nArray = ((Box)object).getGeometry();
        Object object = nArray;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n + object[2];
        int n4 = n2 + object[3];
        return new Rect(n, n2, n3, n4);
    }

    public int[] getGeometry() {
        Box box = object;
        int[] nArray = new int[4];
        Object object = nArray;
        if (box.getGeometry(nArray)) {
            return object;
        }
        return null;
    }

    public boolean getGeometry(@Size(min=4L) int[] nArray) {
        if (!this.mRecycled) {
            if (nArray.length >= 4) {
                return Box.nativeGetGeometry(this.mNativeBox, nArray);
            }
            throw new IllegalArgumentException("Geometry array must be at least 4 elements long");
        }
        throw new IllegalStateException();
    }

    public void recycle() {
        if (!this.mRecycled) {
            Box.nativeDestroy(this.mNativeBox);
            this.mRecycled = true;
        }
    }

    public void finalize() throws Throwable {
        block4: {
            try {
                if (this.mRecycled) break block4;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            Box box = this;
            Log.w((String)TAG, (String)"Box was not terminated using recycle()");
            box.recycle();
        }
        super.finalize();
    }
}

