/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Bitmap;
import com.googlecode.leptonica.android.Convert;
import com.googlecode.leptonica.android.Pix;
import java.io.File;

public class WriteFile {
    public static byte[] writeBytes8(Pix pix) {
        if (pix != null) {
            Pix pix2 = pix;
            byte[] byArray = new byte[pix2.getWidth() * pix.getHeight()];
            if (pix2.getDepth() != 8) {
                Pix pix3 = Convert.convertTo8(pix);
                WriteFile.writeBytes8(pix3, byArray);
                pix3.recycle();
            } else {
                WriteFile.writeBytes8(pix, byArray);
            }
            return byArray;
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static int writeBytes8(Pix pix, byte[] byArray) {
        if (pix != null) {
            int n = pix.getWidth() * pix.getHeight();
            if (byArray.length >= n) {
                return WriteFile.nativeWriteBytes8(pix.getNativePix(), byArray);
            }
            throw new IllegalArgumentException("Data array must be large enough to hold image bytes");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static boolean writeImpliedFormat(Pix pix, File file) {
        if (pix != null) {
            if (file != null) {
                return WriteFile.nativeWriteImpliedFormat(pix.getNativePix(), file.getAbsolutePath());
            }
            throw new IllegalArgumentException("File must be non-null");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Bitmap writeBitmap(Pix pix) {
        if (pix != null) {
            int[] nArray = pix.getDimensions();
            if (nArray != null) {
                Pix pix2 = pix;
                pix = Bitmap.createBitmap((int)nArray[0], (int)nArray[1], (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (WriteFile.nativeWriteBitmap(pix2.getNativePix(), (Bitmap)pix)) {
                    return pix;
                }
                pix.recycle();
            }
            return null;
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native int nativeWriteBytes8(long var0, byte[] var2);

    private static native boolean nativeWriteImpliedFormat(long var0, String var2);

    private static native boolean nativeWriteBitmap(long var0, Bitmap var2);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

