/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.Size;

public class Boxa {
    private static final String TAG;
    private final long mNativeBoxa;
    private boolean mRecycled = false;

    public Boxa(long l) {
        this.mNativeBoxa = l;
        this.mRecycled = false;
    }

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetGeometry(long var0, int var2, int[] var3);

    private static native int nativeGetCount(long var0);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
        TAG = Boxa.class.getSimpleName();
    }

    public long getNativeBoxa() {
        if (!this.mRecycled) {
            return this.mNativeBoxa;
        }
        throw new IllegalStateException();
    }

    public int getCount() {
        if (!this.mRecycled) {
            return Boxa.nativeGetCount(this.mNativeBoxa);
        }
        throw new IllegalStateException();
    }

    public Rect getRect(int n) {
        int[] nArray = ((Boxa)object).getGeometry(n);
        Object object = nArray;
        n = nArray[0];
        int n2 = nArray[1];
        int n3 = n + object[2];
        int n4 = n2 + object[3];
        return new Rect(n, n2, n3, n4);
    }

    public int[] getGeometry(int n) {
        if (!((Boxa)object).mRecycled) {
            Boxa boxa = object;
            int[] nArray = new int[4];
            Object object = nArray;
            if (boxa.getGeometry(n, nArray)) {
                return object;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public boolean getGeometry(int n, @Size(min=4L) int[] nArray) {
        if (!this.mRecycled) {
            if (nArray.length >= 4) {
                return Boxa.nativeGetGeometry(this.mNativeBoxa, n, nArray);
            }
            throw new IllegalArgumentException("Geometry array must be at least 4 elements long");
        }
        throw new IllegalStateException();
    }

    public synchronized void recycle() {
        if (!this.mRecycled) {
            Boxa.nativeDestroy(this.mNativeBoxa);
            this.mRecycled = true;
        }
    }

    public void finalize() throws Throwable {
        block4: {
            try {
                if (this.mRecycled) break block4;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            Boxa boxa = this;
            Log.w((String)TAG, (String)"Boxa was not terminated using recycle()");
            boxa.recycle();
        }
        super.finalize();
    }
}

