/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class GrayQuant {
    public static Pix pixThresholdToBinary(Pix pix, int n) {
        if (pix != null) {
            int n2 = pix.getDepth();
            if (n2 != 4 && n2 != 8) {
                throw new IllegalArgumentException("Source pix depth must be 4 or 8 bpp");
            }
            if (n2 == 4 && n > 16) {
                throw new IllegalArgumentException("4 bpp thresh not in {0-16}");
            }
            if (n2 == 8 && n > 256) {
                throw new IllegalArgumentException("8 bpp thresh not in {0-256}");
            }
            long l = GrayQuant.nativePixThresholdToBinary(pix.getNativePix(), n);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new RuntimeException("Failed to perform binarization");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native long nativePixThresholdToBinary(long var0, int var2);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

