/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import androidx.annotation.FloatRange;
import com.googlecode.leptonica.android.Pix;

public class Binarize {
    public static final int OTSU_SIZE_X = 32;
    public static final int OTSU_SIZE_Y = 32;
    public static final int OTSU_SMOOTH_X = 2;
    public static final int OTSU_SMOOTH_Y = 2;
    public static final float OTSU_SCORE_FRACTION = 0.1f;
    public static final int SAUVOLA_DEFAULT_WINDOW_HALFWIDTH = 8;
    public static final float SAUVOLA_DEFAULT_REDUCTION_FACTOR = 0.35f;
    public static final int SAUVOLA_DEFAULT_NUM_TILES_X = 1;
    public static final int SAUVOLA_DEFAULT_NUM_TILES_Y = 1;

    public static Pix otsuAdaptiveThreshold(Pix pix) {
        return Binarize.otsuAdaptiveThreshold(pix, 32, 32, 2, 2, 0.1f);
    }

    public static Pix otsuAdaptiveThreshold(Pix pix, int n, int n2, int n3, int n4, @FloatRange(from=0.0, to=1.0) float f) {
        if (pix != null) {
            if (pix.getDepth() == 8) {
                long l = Binarize.nativeOtsuAdaptiveThreshold(pix.getNativePix(), n, n2, n3, n4, f);
                if (l != 0L) {
                    return new Pix(l);
                }
                throw new RuntimeException("Failed to perform Otsu adaptive threshold on image");
            }
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Pix sauvolaBinarizeTiled(Pix pix) {
        return Binarize.sauvolaBinarizeTiled(pix, 8, 0.35f, 1, 1);
    }

    public static Pix sauvolaBinarizeTiled(Pix pix, int n, @FloatRange(from=0.0) float f, int n2, int n3) {
        if (pix != null) {
            if (pix.getDepth() == 8) {
                long l = Binarize.nativeSauvolaBinarizeTiled(pix.getNativePix(), n, f, n2, n3);
                if (l != 0L) {
                    return new Pix(l);
                }
                throw new RuntimeException("Failed to perform Sauvola binarization on image");
            }
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native long nativeOtsuAdaptiveThreshold(long var0, int var2, int var3, int var4, int var5, float var6);

    private static native long nativeSauvolaBinarizeTiled(long var0, int var2, float var3, int var4, int var5);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

