/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.intelligence.OcrBitmapInput;
import io.scanbot.sdk.ocr.intelligence.OcrInput;
import io.scanbot.sdk.ocr.intelligence.OcrPagesInput;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.OcrResultBlock;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010@\u001a\u00020>\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u00109\u001a\u000206\u0012\u0006\u0010D\u001a\u00020A\u0012\u0006\u0010=\u001a\u00020:\u0012\u0006\u00100\u001a\u00020-\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0005\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0005\u0010\u000eJ%\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0015J%\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0017J\u0017\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0018J-\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u0005\u0010\u001eJ1\u0010\u0005\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u0005\u0010#J\u0017\u0010\u0005\u001a\u00020&2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b\u0005\u0010'J\u001d\u0010\u0005\u001a\u00020\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u0013H\u0002\u00a2\u0006\u0004\b\u0005\u0010*J\u000f\u0010+\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b+\u0010,R\u0016\u00100\u001a\u00020-8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00103\u001a\u0002018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00102R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00109\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u0010=\u001a\u00020:8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010@\u001a\u00020>8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010?R\u0016\u0010D\u001a\u00020A8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010F\u00a8\u0006I"}, d2={"Lio/scanbot/sdk/ocr/intelligence/SimpleOcrPerformer;", "Lio/scanbot/sdk/ocr/process/OcrPerformer;", "", "ocrStartedMillis", "", "a", "(J)V", "Lio/scanbot/sdk/ocr/intelligence/OcrInput;", "input", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "Lio/scanbot/sdk/ocr/process/OcrResult;", "b", "(Lio/scanbot/sdk/ocr/intelligence/OcrInput;Ljava/util/Set;)Lio/scanbot/sdk/ocr/process/OcrResult;", "languages", "Lio/scanbot/sdk/ocr/intelligence/OcrPagesInput;", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "tessBaseAPI", "", "Lio/scanbot/sdk/ocr/process/OcrResult$OCRPage;", "(Lio/scanbot/sdk/ocr/intelligence/OcrPagesInput;Lcom/googlecode/tesseract/android/TessBaseAPI;)Ljava/util/List;", "Lio/scanbot/sdk/ocr/intelligence/OcrBitmapInput;", "(Lcom/googlecode/tesseract/android/TessBaseAPI;Lio/scanbot/sdk/ocr/intelligence/OcrBitmapInput;)Ljava/util/List;", "(Lcom/googlecode/tesseract/android/TessBaseAPI;)Lio/scanbot/sdk/ocr/process/OcrResult$OCRPage;", "", "pageIteratorLevel", "Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;", "blockType", "Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "(Lcom/googlecode/tesseract/android/TessBaseAPI;ILio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;)Ljava/util/List;", "Lcom/googlecode/tesseract/android/ResultIterator;", "resultIterator", "Lcom/googlecode/leptonica/android/Pix;", "thresholdedImage", "(Lcom/googlecode/tesseract/android/ResultIterator;ILcom/googlecode/leptonica/android/Pix;Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;)Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "Lio/scanbot/sdk/persistence/Page;", "page", "Ljava/io/File;", "(Lio/scanbot/sdk/persistence/Page;)Ljava/io/File;", "", "languageCodes", "(Ljava/util/List;)Lcom/googlecode/tesseract/android/TessBaseAPI;", "recognize", "()Lio/scanbot/sdk/ocr/process/OcrResult;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "g", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "bitmapBinarizer", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "h", "Lio/scanbot/sdk/ocr/intelligence/OcrInput;", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "d", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "f", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "Lio/scanbot/sap/SapManager;", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/persistence/PageFileStorage;", "e", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "c", "Ljava/util/Set;", "<init>", "(Lio/scanbot/sap/SapManager;Ljava/util/Set;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;Lio/scanbot/sdk/ocr/intelligence/OcrInput;)V", "sdk-ocr_release"})
public final class SimpleOcrPerformer
implements OcrPerformer {
    private final Logger a;
    private final SapManager b;
    private final Set<Language> c;
    private final BlobStoreStrategy d;
    private final PageFileStorage e;
    private final OcrSettings f;
    private final OcrPdfRenderer.BitmapBinarizer g;
    private final OcrInput h;

    private final void a(long l) {
        long l2 = SystemClock.elapsedRealtime() - l;
        this.a.d("OCR", "Ocr total: " + (float)l2 / 1000.0f + " sec");
    }

    private final OcrResult b(OcrInput ocrInput, Set<? extends Language> set) throws IOException {
        this.a.d("OCR", "Starting OCR with languages: " + set);
        return this.a(ocrInput, set);
    }

    private final OcrResult a(OcrInput ocrInput, Set<? extends Language> object) throws IOException {
        block4: {
            Document document;
            block3: {
                List<OcrResult.OCRPage> list;
                block2: {
                    object = ((SimpleOcrPerformer)((Object)list)).a(Language.Companion.languageCodes(object));
                    if (!(ocrInput instanceof OcrBitmapInput)) break block2;
                    list = ((SimpleOcrPerformer)((Object)list)).a((TessBaseAPI)object, (OcrBitmapInput)ocrInput);
                    break block3;
                }
                if (!(ocrInput instanceof OcrPagesInput)) break block4;
                list = ((SimpleOcrPerformer)((Object)list)).a((OcrPagesInput)ocrInput, (TessBaseAPI)object);
            }
            ocrInput = document;
            document = new Document();
            return new OcrResult((Document)ocrInput, null, list);
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<OcrResult.OCRPage> a(OcrPagesInput object, TessBaseAPI tessBaseAPI) {
        ArrayList arrayList;
        Object object2 = object;
        object = arrayList;
        arrayList = new ArrayList();
        try {
            Iterator<Page> iterator = ((OcrPagesInput)object2).getPages().iterator();
            while (iterator.hasNext()) {
                File file = this.a(iterator.next());
                if (!file.exists()) continue;
                if (this.f.getBinarizeImage()) {
                    Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeFile(pageFile.absolutePath)");
                    tessBaseAPI.setImage(this.g.binarizeBitmap(bitmap, true));
                } else {
                    tessBaseAPI.setImage(file);
                }
                ((ArrayList)object).add(this.a(tessBaseAPI));
            }
        }
        catch (Throwable throwable) {
            tessBaseAPI.end();
            throw throwable;
        }
        {
            continue;
        }
        tessBaseAPI.end();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<OcrResult.OCRPage> a(TessBaseAPI tessBaseAPI, OcrBitmapInput ocrBitmapInput) {
        try {
            ocrBitmapInput = this.f.getBinarizeImage() ? this.g.binarizeBitmap(ocrBitmapInput.getBitmap(), false) : ocrBitmapInput.getBitmap();
            TessBaseAPI tessBaseAPI2 = tessBaseAPI;
            tessBaseAPI2.setImage((Bitmap)ocrBitmapInput);
            List list = CollectionsKt.listOf((Object)this.a(tessBaseAPI2));
            tessBaseAPI.end();
            return list;
        }
        catch (Throwable throwable) {
            tessBaseAPI.end();
            throw throwable;
        }
    }

    private final OcrResult.OCRPage a(TessBaseAPI object) {
        SimpleOcrPerformer simpleOcrPerformer = string;
        String string = ((TessBaseAPI)object).getUTF8Text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tessBaseAPI.utF8Text");
        Object object2 = OcrResultBlock.OcrResultBlockType.PARAGRAPH;
        object2 = simpleOcrPerformer.a((TessBaseAPI)object, 1, (OcrResultBlock.OcrResultBlockType)((Object)object2));
        Object object3 = OcrResultBlock.OcrResultBlockType.LINE;
        object3 = simpleOcrPerformer.a((TessBaseAPI)object, 2, (OcrResultBlock.OcrResultBlockType)((Object)object3));
        OcrResultBlock.OcrResultBlockType ocrResultBlockType = OcrResultBlock.OcrResultBlockType.WORD;
        object = simpleOcrPerformer.a((TessBaseAPI)object, 3, ocrResultBlockType);
        return new OcrResult.OCRPage(string, (List<OcrResultBlock>)object2, (List<OcrResultBlock>)object3, (List<OcrResultBlock>)object);
    }

    private final List<OcrResultBlock> a(TessBaseAPI object, int n, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        ArrayList<OcrResultBlock> arrayList;
        ArrayList<OcrResultBlock> arrayList2 = arrayList;
        TessBaseAPI tessBaseAPI = object;
        arrayList2();
        object = tessBaseAPI.getThresholdedImage();
        ResultIterator resultIterator = tessBaseAPI.getResultIterator();
        resultIterator.begin();
        Intrinsics.checkNotNullExpressionValue((Object)resultIterator, (String)"resultIterator");
        arrayList.add(this.a(resultIterator, n, (Pix)object, ocrResultBlockType));
        while (resultIterator.next(n)) {
            arrayList2.add(this.a(resultIterator, n, (Pix)object, ocrResultBlockType));
        }
        return arrayList2;
    }

    private final OcrResultBlock a(ResultIterator resultIterator, int n, Pix pix, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        RectF rectF;
        Rect rect;
        Object object = resultIterator.getUTF8Text(n);
        if (object == null) {
            object = "";
        }
        int[] nArray = resultIterator.getBoundingBox(n);
        Rect rect2 = rect;
        rect = new Rect();
        RectF rectF2 = rectF;
        rectF = new RectF();
        if (nArray.length == 4) {
            Rect rect3;
            rect2 = rect3;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            rect3 = new Rect(n2, n3, n4, n5);
            if (pix != null) {
                RectF rectF3;
                rectF2 = rectF3;
                float f = (float)nArray[0] / (float)pix.getWidth();
                float f2 = (float)nArray[1] / (float)pix.getHeight();
                float f3 = (float)nArray[2] / (float)pix.getWidth();
                float f4 = (float)nArray[3] / (float)pix.getHeight();
                rectF3 = new RectF(f, f2, f3, f4);
            }
        }
        float f = resultIterator.confidence(n);
        return new OcrResultBlock((String)object, rectF2, rect2, f, ocrResultBlockType);
    }

    private final File a(Page page) throws IOException {
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(this.e.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
        if (new File(this.e.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()).exists()) {
            file4 = file3;
        }
        return file4;
    }

    private final TessBaseAPI a(List<String> list) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.d.getOcrDataDirectory().toString(), TextUtils.join((CharSequence)"+", list));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    public SimpleOcrPerformer(@NotNull SapManager sapManager, @NotNull Set<? extends Language> set, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer, @NotNull OcrInput ocrInput) {
        SimpleOcrPerformer simpleOcrPerformer = this;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        Intrinsics.checkNotNullParameter(set, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)bitmapBinarizer, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)ocrInput, (String)"input");
        this.b = sapManager;
        this.c = set;
        this.d = blobStoreStrategy;
        this.e = pageFileStorage;
        this.f = ocrSettings;
        this.g = bitmapBinarizer;
        simpleOcrPerformer.h = ocrInput;
        simpleOcrPerformer.a = LoggerProvider.getLogger();
    }

    @Override
    @NotNull
    public OcrResult recognize() {
        OcrResult ocrResult;
        OcrResult ocrResult2 = ocrResult;
        List list = CollectionsKt.emptyList();
        ocrResult = new OcrResult(null, null, list);
        if (!this.b.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return ocrResult2;
        }
        SimpleOcrPerformer simpleOcrPerformer = this;
        long l = SystemClock.elapsedRealtime();
        OcrInput ocrInput = simpleOcrPerformer.h;
        try {
            ocrResult2 = simpleOcrPerformer.b(ocrInput, simpleOcrPerformer.c);
        }
        catch (IOException iOException) {
            this.a.logException((Throwable)iOException);
        }
        this.a(l);
        return ocrResult2;
    }
}

