/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.graphics.Bitmap;
import android.graphics.Rect;
import androidx.annotation.WorkerThread;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.Pixa;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TessBaseAPI {
    public static final String VAR_CHAR_WHITELIST = "tessedit_char_whitelist";
    public static final String VAR_CHAR_BLACKLIST = "tessedit_char_blacklist";
    public static final String VAR_SAVE_BLOB_CHOICES = "save_blob_choices";
    public static final String VAR_TRUE = "T";
    public static final String VAR_FALSE = "F";
    public static final int OEM_TESSERACT_ONLY = 0;
    @Deprecated
    public static final int OEM_LSTM_ONLY = 1;
    @Deprecated
    public static final int OEM_TESSERACT_LSTM_COMBINED = 2;
    public static final int OEM_DEFAULT = 3;
    private long mNativeData;
    private ProgressNotifier progressNotifier;
    private boolean mRecycled;

    public TessBaseAPI() {
        long l;
        TessBaseAPI tessBaseAPI = this;
        this.mNativeData = l = tessBaseAPI.nativeConstruct();
        if (l != 0L) {
            this.mRecycled = false;
            return;
        }
        throw new RuntimeException("Can't create TessBaseApi object");
    }

    public TessBaseAPI(ProgressNotifier progressNotifier) {
        this();
        this.progressNotifier = progressNotifier;
    }

    private static native void nativeClassInit();

    private native long nativeConstruct();

    private native void nativeEnd(long var1);

    private native boolean nativeInit(long var1, String var3, String var4);

    private native boolean nativeInitOem(long var1, String var3, String var4, int var5);

    private native String nativeGetInitLanguagesAsString(long var1);

    private native void nativeClear(long var1);

    private native void nativeSetImageBytes(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private native void nativeSetImagePix(long var1, long var3);

    private native void nativeSetRectangle(long var1, int var3, int var4, int var5, int var6);

    private native String nativeGetUTF8Text(long var1);

    private native int nativeMeanConfidence(long var1);

    private native int[] nativeWordConfidences(long var1);

    private native boolean nativeSetVariable(long var1, String var3, String var4);

    private native void nativeSetDebug(long var1, boolean var3);

    private native int nativeGetPageSegMode(long var1);

    private native void nativeSetPageSegMode(long var1, int var3);

    private native long nativeGetThresholdedImage(long var1);

    private native long nativeGetRegions(long var1);

    private native long nativeGetTextlines(long var1);

    private native long nativeGetStrips(long var1);

    private native long nativeGetWords(long var1);

    private native long nativeGetConnectedComponents(long var1);

    private native long nativeGetResultIterator(long var1);

    private native String nativeGetBoxText(long var1, int var3);

    private native String nativeGetHOCRText(long var1, int var3);

    private native void nativeSetInputName(long var1, String var3);

    private native void nativeSetOutputName(long var1, String var3);

    private native void nativeReadConfigFile(long var1, String var3);

    private native String nativeGetVersion(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeBeginDocument(long var1, String var3);

    private native boolean nativeEndDocument(long var1);

    private native boolean nativeAddPageToDocument(long var1, long var3, String var5, long var6);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("jpgt");
        TessBaseAPI.nativeClassInit();
    }

    public boolean init(String string, String string2) {
        return this.init(string, string2, 3);
    }

    public boolean init(String string, String string2, int n) {
        if (string != null) {
            Object object = File.separator;
            if (!string.endsWith((String)object)) {
                string = string + (String)object;
            }
            if (new File(string).exists()) {
                File file;
                object = file;
                file = new File(string);
                for (String string3 : string2.split("\\+")) {
                    File file2;
                    if (string3.startsWith("~")) continue;
                    File file3 = file2;
                    if (new File(object + File.separator + string3 + ".traineddata").exists()) continue;
                    throw new IllegalArgumentException("Data file not found at " + file3);
                }
                TessBaseAPI tessBaseAPI = this;
                boolean bl = tessBaseAPI.nativeInitOem(tessBaseAPI.mNativeData, string, string2, n);
                if (bl) {
                    this.mRecycled = false;
                }
                return bl;
            }
            throw new IllegalArgumentException("Data path does not exist!");
        }
        throw new IllegalArgumentException("Data path must not be null!");
    }

    public String getInitLanguagesAsString() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetInitLanguagesAsString(tessBaseAPI.mNativeData);
        }
        throw new IllegalStateException();
    }

    public void clear() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeClear(tessBaseAPI.mNativeData);
            return;
        }
        throw new IllegalStateException();
    }

    public void end() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeEnd(tessBaseAPI.mNativeData);
            tessBaseAPI.mRecycled = true;
        }
    }

    public boolean setVariable(String string, String string2) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeSetVariable(tessBaseAPI.mNativeData, string, string2);
        }
        throw new IllegalStateException();
    }

    public int getPageSegMode() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetPageSegMode(tessBaseAPI.mNativeData);
        }
        throw new IllegalStateException();
    }

    public void setPageSegMode(int n) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetPageSegMode(tessBaseAPI.mNativeData, n);
            return;
        }
        throw new IllegalStateException();
    }

    public void setDebug(boolean bl) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetDebug(tessBaseAPI.mNativeData, bl);
            return;
        }
        throw new IllegalStateException();
    }

    public void setRectangle(Rect rect) {
        if (!this.mRecycled) {
            Rect rect2 = rect;
            int n = rect2.left;
            int n2 = rect2.top;
            int n3 = rect2.width();
            int n4 = rect2.height();
            this.setRectangle(n, n2, n3, n4);
            return;
        }
        throw new IllegalStateException();
    }

    public void setRectangle(int n, int n2, int n3, int n4) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetRectangle(tessBaseAPI.mNativeData, n, n2, n3, n4);
            return;
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public void setImage(File object) {
        if (!this.mRecycled) {
            if ((object = ReadFile.readFile((File)object)) != null) {
                long l = this.mNativeData;
                long l2 = ((Pix)object).getNativePix();
                this.nativeSetImagePix(l, l2);
                ((Pix)object).recycle();
                return;
            }
            throw new RuntimeException("Failed to read image file");
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public void setImage(Bitmap object) {
        if (!this.mRecycled) {
            if ((object = ReadFile.readBitmap((Bitmap)object)) != null) {
                long l = this.mNativeData;
                long l2 = ((Pix)object).getNativePix();
                this.nativeSetImagePix(l, l2);
                ((Pix)object).recycle();
                return;
            }
            throw new RuntimeException("Failed to read bitmap");
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public void setImage(Pix pix) {
        if (!this.mRecycled) {
            long l = this.mNativeData;
            long l2 = pix.getNativePix();
            this.nativeSetImagePix(l, l2);
            return;
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public void setImage(byte[] byArray, int n, int n2, int n3, int n4) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetImageBytes(tessBaseAPI.mNativeData, byArray, n, n2, n3, n4);
            return;
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public String getUTF8Text() {
        if (!((TessBaseAPI)((Object)string)).mRecycled) {
            TessBaseAPI tessBaseAPI = string;
            String string = tessBaseAPI.nativeGetUTF8Text(tessBaseAPI.mNativeData);
            return string != null ? string.trim() : null;
        }
        throw new IllegalStateException();
    }

    public int meanConfidence() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeMeanConfidence(tessBaseAPI.mNativeData);
        }
        throw new IllegalStateException();
    }

    public int[] wordConfidences() {
        if (!((TessBaseAPI)object).mRecycled) {
            TessBaseAPI tessBaseAPI = object;
            int[] nArray = tessBaseAPI.nativeWordConfidences(tessBaseAPI.mNativeData);
            Object object = nArray;
            if (nArray == null) {
                object = new int[0];
            }
            return object;
        }
        throw new IllegalStateException();
    }

    public Pix getThresholdedImage() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pix(tessBaseAPI.nativeGetThresholdedImage(tessBaseAPI.mNativeData));
        }
        throw new IllegalStateException();
    }

    public Pixa getRegions() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetRegions(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getTextlines() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetTextlines(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getStrips() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetStrips(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getWords() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetWords(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getConnectedComponents() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetConnectedComponents(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public ResultIterator getResultIterator() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            long l = tessBaseAPI.nativeGetResultIterator(tessBaseAPI.mNativeData);
            if (l == 0L) {
                return null;
            }
            return new ResultIterator(l);
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public String getHOCRText(int n) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetHOCRText(tessBaseAPI.mNativeData, n);
        }
        throw new IllegalStateException();
    }

    public void setInputName(String string) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetInputName(tessBaseAPI.mNativeData, string);
            return;
        }
        throw new IllegalStateException();
    }

    public void setOutputName(String string) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetOutputName(tessBaseAPI.mNativeData, string);
            return;
        }
        throw new IllegalStateException();
    }

    public void readConfigFile(String string) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeReadConfigFile(tessBaseAPI.mNativeData, string);
            return;
        }
        throw new IllegalStateException();
    }

    public String getBoxText(int n) {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetBoxText(tessBaseAPI.mNativeData, n);
        }
        throw new IllegalStateException();
    }

    public String getVersion() {
        TessBaseAPI tessBaseAPI = this;
        return tessBaseAPI.nativeGetVersion(tessBaseAPI.mNativeData);
    }

    public void stop() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeStop(tessBaseAPI.mNativeData);
            return;
        }
        throw new IllegalStateException();
    }

    public void onProgressValues(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.progressNotifier != null) {
            ProgressValues progressValues;
            Rect rect;
            Rect rect2;
            Rect rect3 = rect2;
            int n10 = n2;
            n2 = n8 - n4;
            n4 = n8 - n5;
            rect2 = new Rect(n10, n2, n3, n4);
            Rect rect4 = rect;
            rect = new Rect(n6, n9, n7, n8);
            ProgressValues progressValues2 = progressValues;
            progressValues = new ProgressValues(n, rect3, rect4);
            this.progressNotifier.onProgressValues(progressValues2);
        }
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer, String string) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePdfRenderer(), string);
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePdfRenderer(), "");
    }

    public boolean endDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeEndDocument(tessPdfRenderer.getNativePdfRenderer());
    }

    public boolean addPageToDocument(Pix pix, String string, TessPdfRenderer tessPdfRenderer) {
        long l = this.mNativeData;
        long l2 = pix.getNativePix();
        long l3 = tessPdfRenderer.getNativePdfRenderer();
        return this.nativeAddPageToDocument(l, l2, string, l3);
    }

    public long getNativeData() {
        return this.mNativeData;
    }

    public class ProgressValues {
        private final int percent;
        private final Rect wordRect;
        private final Rect textRect;

        public ProgressValues(int n, Rect rect, Rect rect2) {
            this.percent = n;
            this.wordRect = rect;
            this.textRect = rect2;
        }

        public int getPercent() {
            return this.percent;
        }

        public Rect getCurrentWordRect() {
            return this.wordRect;
        }

        public Rect getCurrentRect() {
            return this.textRect;
        }
    }

    public static interface ProgressNotifier {
        public void onProgressValues(ProgressValues var1);
    }

    public static final class PageIteratorLevel {
        public static final int RIL_BLOCK = 0;
        public static final int RIL_PARA = 1;
        public static final int RIL_TEXTLINE = 2;
        public static final int RIL_WORD = 3;
        public static final int RIL_SYMBOL = 4;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Level {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OcrEngineMode {
    }

    public static final class PageSegMode {
        public static final int PSM_OSD_ONLY = 0;
        public static final int PSM_AUTO_OSD = 1;
        public static final int PSM_AUTO_ONLY = 2;
        public static final int PSM_AUTO = 3;
        public static final int PSM_SINGLE_COLUMN = 4;
        public static final int PSM_SINGLE_BLOCK_VERT_TEXT = 5;
        public static final int PSM_SINGLE_BLOCK = 6;
        public static final int PSM_SINGLE_LINE = 7;
        public static final int PSM_SINGLE_WORD = 8;
        public static final int PSM_CIRCLE_WORD = 9;
        public static final int PSM_SINGLE_CHAR = 10;
        public static final int PSM_SPARSE_TEXT = 11;
        public static final int PSM_SPARSE_TEXT_OSD = 12;
        public static final int PSM_RAW_LINE = 13;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Mode {
        }
    }
}

