/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class AdaptiveMap {
    private static final int NORM_REDUCTION = 16;
    private static final int NORM_SIZE = 3;
    private static final int NORM_BG_VALUE = 200;
    public static final int DEFAULT_TILE_WIDTH = 10;
    public static final int DEFAULT_TILE_HEIGHT = 15;
    public static final int DEFAULT_MIN_COUNT = 40;
    public static final int DEFAULT_X_SMOOTH_SIZE = 2;
    public static final int DEFAULT_Y_SMOOTH_SIZE = 1;

    public static Pix backgroundNormMorph(Pix pix) {
        return AdaptiveMap.backgroundNormMorph(pix, 16, 3, 200);
    }

    public static Pix backgroundNormMorph(Pix pix, int n, int n2, int n3) {
        if (pix != null) {
            long l = AdaptiveMap.nativeBackgroundNormMorph(pix.getNativePix(), n, n2, n3);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new RuntimeException("Failed to normalize image background");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Pix pixContrastNorm(Pix pix) {
        return AdaptiveMap.pixContrastNorm(pix, 10, 15, 40, 2, 1);
    }

    public static Pix pixContrastNorm(Pix pix, int n, int n2, int n3, int n4, int n5) {
        if (pix != null) {
            long l = AdaptiveMap.nativePixContrastNorm(pix.getNativePix(), n, n2, n3, n4, n5);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new RuntimeException("Failed to normalize image contrast");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native long nativeBackgroundNormMorph(long var0, int var2, int var3, int var4);

    private static native long nativePixContrastNorm(long var0, int var2, int var3, int var4, int var5, int var6);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

