/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import androidx.annotation.ColorInt;
import androidx.annotation.Size;

public class Pix {
    public static final int INDEX_W = 0;
    public static final int INDEX_H = 1;
    public static final int INDEX_D = 2;
    private final long mNativePix;
    private boolean mRecycled;

    public Pix(long l) {
        this.mNativePix = l;
        this.mRecycled = false;
    }

    public Pix(int n, int n2, int n3) {
        if (n > 0 && n2 > 0) {
            if (n3 != 1 && n3 != 2 && n3 != 4 && n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
                throw new IllegalArgumentException("Depth must be one of 1, 2, 4, 8, 16, or 32");
            }
            Pix pix = this;
            pix.mNativePix = Pix.nativeCreatePix(n, n2, n3);
            pix.mRecycled = false;
            return;
        }
        throw new IllegalArgumentException("Pix width and height must be > 0");
    }

    public static Pix createFromPix(byte[] byArray, int n, int n2, int n3) {
        long l = Pix.nativeCreateFromData(byArray, n, n2, n3);
        if (l != 0L) {
            return new Pix(l);
        }
        throw new OutOfMemoryError();
    }

    private static native int nativeGetRefCount(long var0);

    private static native long nativeCreatePix(int var0, int var1, int var2);

    private static native long nativeCreateFromData(byte[] var0, int var1, int var2, int var3);

    private static native byte[] nativeGetData(long var0);

    private static native long nativeClone(long var0);

    private static native long nativeCopy(long var0);

    private static native boolean nativeInvert(long var0);

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetDimensions(long var0, int[] var2);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetDepth(long var0);

    private static native int nativeGetPixel(long var0, int var2, int var3);

    private static native void nativeSetPixel(long var0, int var2, int var3, int var4);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }

    public long getNativePix() {
        if (!this.mRecycled) {
            return this.mNativePix;
        }
        throw new IllegalStateException();
    }

    public byte[] getData() {
        if (!((Pix)object).mRecycled) {
            byte[] byArray = Pix.nativeGetData(((Pix)object).mNativePix);
            Object object = byArray;
            if (byArray != null) {
                return object;
            }
            throw new RuntimeException("native getData failed");
        }
        throw new IllegalStateException();
    }

    public int[] getDimensions() {
        if (!((Pix)object).mRecycled) {
            Pix pix = object;
            int[] nArray = new int[3];
            Object object = nArray;
            if (pix.getDimensions(nArray)) {
                return object;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public boolean getDimensions(@Size(min=3L) int[] nArray) {
        if (!this.mRecycled) {
            return Pix.nativeGetDimensions(this.mNativePix, nArray);
        }
        throw new IllegalStateException();
    }

    public Pix clone() {
        if (!this.mRecycled) {
            long l = Pix.nativeClone(this.mNativePix);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public Pix copy() {
        if (!this.mRecycled) {
            long l = Pix.nativeCopy(this.mNativePix);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public boolean invert() {
        if (!this.mRecycled) {
            return Pix.nativeInvert(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public void recycle() {
        if (!this.mRecycled) {
            Pix.nativeDestroy(this.mNativePix);
            this.mRecycled = true;
        }
    }

    public Rect getRect() {
        Pix pix = this;
        int n = pix.getWidth();
        int n2 = pix.getHeight();
        return new Rect(0, 0, n, n2);
    }

    public int getWidth() {
        if (!this.mRecycled) {
            return Pix.nativeGetWidth(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public int getHeight() {
        if (!this.mRecycled) {
            return Pix.nativeGetHeight(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public int getDepth() {
        if (!this.mRecycled) {
            return Pix.nativeGetDepth(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public int getRefCount() {
        return Pix.nativeGetRefCount(this.mNativePix);
    }

    public int getPixel(int n, int n2) {
        if (!this.mRecycled) {
            if (n >= 0 && n < this.getWidth()) {
                if (n2 >= 0 && n2 < this.getHeight()) {
                    return Pix.nativeGetPixel(this.mNativePix, n, n2);
                }
                throw new IllegalArgumentException("Supplied y coordinate exceeds image bounds");
            }
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        throw new IllegalStateException();
    }

    public void setPixel(int n, int n2, @ColorInt int n3) {
        if (!this.mRecycled) {
            if (n >= 0 && n < this.getWidth()) {
                if (n2 >= 0 && n2 < this.getHeight()) {
                    Pix.nativeSetPixel(this.mNativePix, n, n2, n3);
                    return;
                }
                throw new IllegalArgumentException("Supplied y coordinate exceeds image bounds");
            }
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        throw new IllegalStateException();
    }
}

