/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010'\u001a\u00020%\u0012\u0006\u00102\u001a\u000200\u0012\u0006\u0010+\u001a\u00020(\u0012\u0006\u0010\u001d\u001a\u00020\u001a\u0012\u0006\u0010/\u001a\u00020,\u0012\u0006\u0010$\u001a\u00020!\u00a2\u0006\u0004\b3\u00104J5\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\fJ5\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ!\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u001f\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0014J\u0017\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0015J-\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001d\u001a\u00020\u001a8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010 \u001a\u00020\u001e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001fR\u0016\u0010$\u001a\u00020!8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010'\u001a\u00020%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010&R\u0016\u0010+\u001a\u00020(8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010/\u001a\u00020,8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u00102\u001a\u0002008\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00101\u00a8\u00065"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "Lio/scanbot/sdk/entity/Document;", "document", "", "Lio/scanbot/sdk/persistence/Page;", "pages", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "", "a", "(Lio/scanbot/sdk/entity/Document;Ljava/util/List;Ljava/util/Set;)Ljava/lang/String;", "c", "b", "detectedText", "", "(Lio/scanbot/sdk/entity/Document;Ljava/lang/String;)V", "", "ocrStartedMillis", "(Lio/scanbot/sdk/entity/Document;J)V", "(Lio/scanbot/sdk/entity/Document;)V", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "config", "composeDocument", "(Lio/scanbot/sdk/entity/Document;Ljava/util/List;Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;)V", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "e", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "g", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "documentStoreStrategy", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "d", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "pdfRenderer", "Lio/scanbot/sap/SapManager;", "f", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/blob/BlobManager;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "<init>", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    private final Logger a;
    private final DocumentStoreStrategy b;
    private final BlobManager c;
    private final OcrPdfRenderer d;
    private final SimpleComposer e;
    private final SapManager f;
    private final OcrSettings g;

    /*
     * WARNING - void declaration
     */
    private final String a(Document document, List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.c((Document)var1_1, (List<Page>)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final String c(Document document, List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.a.d("OCR", "Starting OCR with languages: " + var3_3);
        return this.b((Document)var1_1, (List<Page>)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String b(Document document, List<Page> pages, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        Object object;
        Object object2 = this.d;
        Page[] pageArray = pages.toArray(new Page[0]);
        if (pageArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        OcrPdfRenderer ocrPdfRenderer = object2;
        void v1 = object;
        object = pageArray;
        object2 = this.g;
        object = ocrPdfRenderer.startRender((Document)v1, (Page[])object, (Collection<? extends Language>)var3_3, (OcrSettings)object2);
        try {
            while (object.renderNextPage()) {
                this.a.d("OCR", "Page rendered: " + object.getDetectedText());
            }
            String string = object.getDetectedText();
            object.recycle();
            return string;
        }
        catch (Throwable throwable) {
            object.recycle();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.a((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Document document, long ocrStartedMillis) {
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        this.a.d("OCR", "Ocr total: " + (float)l / 1000.0f + " sec");
    }

    private final void a(Document document) {
        if (document.language != null) {
            String string;
            void v0 = string;
            OcrComposer ocrComposer = ocrComposer.a;
            string = "OCR";
            StringBuilder stringBuilder = new StringBuilder().append("Document language assigned: ");
            Object object = v0.language;
            object = object != null ? object.getOcrBlobLanguageTag() : null;
            ocrComposer.d(string, stringBuilder.append((String)object).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"ocrSettings");
        this.b = var1_1;
        this.c = var2_2;
        this.d = var3_3;
        this.e = var4_4;
        this.f = var5_5;
        ocrComposer.g = var6_6;
        ocrComposer.a = LoggerProvider.getLogger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull List<Page> pages, @NotNull ComposerConfig config) throws IOException {
        long l;
        Set set;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)set, (String)"config");
        if (!this.f.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            l = SystemClock.elapsedRealtime();
            set = this.c.getAllLanguagesWithAvailableOcrBlobs();
        }
        catch (IOException iOException) {
            Composer.DefaultImpls.composeDocument$default((Composer)this.e, (Document)var1_1, (List)var2_2, null, (int)4, null);
            return;
        }
        {
            if (!set.isEmpty()) {
                this.a((Document)var1_1, this.a((Document)var1_1, CollectionsKt.toList((Iterable)var2_2), set));
                this.a((Document)var1_1, l);
                return;
            }
            this.a.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new IOException("OCR languages blobs are not available");
        }
    }
}

